/*

All Seeing Eye UDP packets decoding/encoding algorithm 0.1
by Luigi Auriemma
e-mail: aluigi@autistici.org
web:    aluigi.org


Introduction
============
This function is used by the program ASE to encode or decode the UDP
packets sent to its servers like tracker.udpsoft.com:27246 or
194.251.249.103:27243.
If sometimes you have run a sniffer during the usage of ASE you have
surely noticed the UDP packets with strange bytes in them, in fact
they are encoded.
These packets contain your unique IDs to be included in the friends
tracker or to verify your registration code when you start the
program.
Usually the IDs sent are MotdIdLo, MotdIdHi and UserID available in
the registry key of ASE.
I don't know if this algorithm is used also for other usages.


How to use
==========
To decode a packet:   ase_udp_decenc(packet, packet_size, 0);
To encode a packet:   ase_udp_decenc(packet, packet_size, 1);


License
=======
    Copyright 2005,2006 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl.txt

*/



void ase_udp_decenc(unsigned char *buff, int len, int decenc) {
    const static unsigned int  crc_table[] = {
        0x00000000, 0x77073096, 0xee0e612c, 0x990951ba,
        0x076dc419, 0x706af48f, 0xe963a535, 0x9e6495a3,
        0x0edb8832, 0x79dcb8a4, 0xe0d5e91e, 0x97d2d988,
        0x09b64c2b, 0x7eb17cbd, 0xe7b82d07, 0x90bf1d91,
        0x1db71064, 0x6ab020f2, 0xf3b97148, 0x84be41de,
        0x1adad47d, 0x6ddde4eb, 0xf4d4b551, 0x83d385c7,
        0x136c9856, 0x646ba8c0, 0xfd62f97a, 0x8a65c9ec,
        0x14015c4f, 0x63066cd9, 0xfa0f3d63, 0x8d080df5,
        0x3b6e20c8, 0x4c69105e, 0xd56041e4, 0xa2677172,
        0x3c03e4d1, 0x4b04d447, 0xd20d85fd, 0xa50ab56b,
        0x35b5a8fa, 0x42b2986c, 0xdbbbc9d6, 0xacbcf940,
        0x32d86ce3, 0x45df5c75, 0xdcd60dcf, 0xabd13d59,
        0x26d930ac, 0x51de003a, 0xc8d75180, 0xbfd06116,
        0x21b4f4b5, 0x56b3c423, 0xcfba9599, 0xb8bda50f,
        0x2802b89e, 0x5f058808, 0xc60cd9b2, 0xb10be924,
        0x2f6f7c87, 0x58684c11, 0xc1611dab, 0xb6662d3d,
        0x76dc4190, 0x01db7106, 0x98d220bc, 0xefd5102a,
        0x71b18589, 0x06b6b51f, 0x9fbfe4a5, 0xe8b8d433,
        0x7807c9a2, 0x0f00f934, 0x9609a88e, 0xe10e9818,
        0x7f6a0dbb, 0x086d3d2d, 0x91646c97, 0xe6635c01,
        0x6b6b51f4, 0x1c6c6162, 0x856530d8, 0xf262004e,
        0x6c0695ed, 0x1b01a57b, 0x8208f4c1, 0xf50fc457,
        0x65b0d9c6, 0x12b7e950, 0x8bbeb8ea, 0xfcb9887c,
        0x62dd1ddf, 0x15da2d49, 0x8cd37cf3, 0xfbd44c65,
        0x4db26158, 0x3ab551ce, 0xa3bc0074, 0xd4bb30e2,
        0x4adfa541, 0x3dd895d7, 0xa4d1c46d, 0xd3d6f4fb,
        0x4369e96a, 0x346ed9fc, 0xad678846, 0xda60b8d0,
        0x44042d73, 0x33031de5, 0xaa0a4c5f, 0xdd0d7cc9,
        0x5005713c, 0x270241aa, 0xbe0b1010, 0xc90c2086,
        0x5768b525, 0x206f85b3, 0xb966d409, 0xce61e49f,
        0x5edef90e, 0x29d9c998, 0xb0d09822, 0xc7d7a8b4,
        0x59b33d17, 0x2eb40d81, 0xb7bd5c3b, 0xc0ba6cad,
        0xedb88320, 0x9abfb3b6, 0x03b6e20c, 0x74b1d29a,
        0xead54739, 0x9dd277af, 0x04db2615, 0x73dc1683,
        0xe3630b12, 0x94643b84, 0x0d6d6a3e, 0x7a6a5aa8,
        0xe40ecf0b, 0x9309ff9d, 0x0a00ae27, 0x7d079eb1,
        0xf00f9344, 0x8708a3d2, 0x1e01f268, 0x6906c2fe,
        0xf762575d, 0x806567cb, 0x196c3671, 0x6e6b06e7,
        0xfed41b76, 0x89d32be0, 0x10da7a5a, 0x67dd4acc,
        0xf9b9df6f, 0x8ebeeff9, 0x17b7be43, 0x60b08ed5,
        0xd6d6a3e8, 0xa1d1937e, 0x38d8c2c4, 0x4fdff252,
        0xd1bb67f1, 0xa6bc5767, 0x3fb506dd, 0x48b2364b,
        0xd80d2bda, 0xaf0a1b4c, 0x36034af6, 0x41047a60,
        0xdf60efc3, 0xa867df55, 0x316e8eef, 0x4669be79,
        0xcb61b38c, 0xbc66831a, 0x256fd2a0, 0x5268e236,
        0xcc0c7795, 0xbb0b4703, 0x220216b9, 0x5505262f,
        0xc5ba3bbe, 0xb2bd0b28, 0x2bb45a92, 0x5cb36a04,
        0xc2d7ffa7, 0xb5d0cf31, 0x2cd99e8b, 0x5bdeae1d,
        0x9b64c2b0, 0xec63f226, 0x756aa39c, 0x026d930a,
        0x9c0906a9, 0xeb0e363f, 0x72076785, 0x05005713,
        0x95bf4a82, 0xe2b87a14, 0x7bb12bae, 0x0cb61b38,
        0x92d28e9b, 0xe5d5be0d, 0x7cdcefb7, 0x0bdbdf21,
        0x86d3d2d4, 0xf1d4e242, 0x68ddb3f8, 0x1fda836e,
        0x81be16cd, 0xf6b9265b, 0x6fb077e1, 0x18b74777,
        0x88085ae6, 0xff0f6a70, 0x66063bca, 0x11010b5c,
        0x8f659eff, 0xf862ae69, 0x616bffd3, 0x166ccf45,
        0xa00ae278, 0xd70dd2ee, 0x4e048354, 0x3903b3c2,
        0xa7672661, 0xd06016f7, 0x4969474d, 0x3e6e77db,
        0xaed16a4a, 0xd9d65adc, 0x40df0b66, 0x37d83bf0,
        0xa9bcae53, 0xdebb9ec5, 0x47b2cf7f, 0x30b5ffe9,
        0xbdbdf21c, 0xcabac28a, 0x53b39330, 0x24b4a3a6,
        0xbad03605, 0xcdd70693, 0x54de5729, 0x23d967bf,
        0xb3667a2e, 0xc4614ab8, 0x5d681b02, 0x2a6f2b94,
        0xb40bbe37, 0xc30c8ea1, 0x5a05df1b, 0x2d02ef8d };
    const static unsigned int  ase_table[] = {
        0x0ff97174, 0x1f9bd468, 0x37849969, 0x4e89ae73,
        0x612bf420, 0x67d79c63, 0x6d77656f, 0x745adb64,
        0x7bea3365, 0x834ce620, 0x89795069, 0x8f45bf73,
        0x96a87220, 0x9ec22f73, 0xa63fab74, 0xac514d6f,
        0xb267656c, 0xb8413965, 0xbfe26c6e, 0xc797b620,
        0xcc6a2266, 0xcf2ffb72, 0xd1fa4c6f, 0xd5eb436d,
        0xd9e9a020, 0xdc48ca54, 0xdcb1b468, 0xdd11b165,
        0xdd7cd620, 0xde4c6f41, 0xded49a6c, 0xdf15566c,
        0xdf5a892d, 0xdfc13753, 0xe0184665, 0xe0525065,
        0xe07cb969, 0xe09e356e, 0xe0d3c867, 0xe116bf20,
        0xe1412945, 0xe1606979, 0xe17b3365, 0xe1a59c20,
        0xe1d8f428, 0xe20c4b63, 0xe236b429, 0xe253b920,
        0xe26e8355, 0xe2aac844, 0xe2c7cd50, 0xe2f6ad20,
        0xe3117753, 0xe32e7c6f, 0xe3523366, 0xe37c9c74,
        0xe39e1820, 0xe3d5e64c, 0xe3f76254, 0xe4146744,
        0xe42cf52e, 0xe44e7120, 0xe46db168, 0xe49a5674,
        0xe4c28474, 0xe4df8970, 0xe501053a, 0xe519932f,
        0xe5345c2f, 0xe5633c77, 0xe5969477, 0xe5b15d77,
        0xe5d09e2e, 0xe5eb6775, 0xe6063064, 0xe627ac70,
        0xe64d9f73, 0xe66f1b6f, 0xe6856d66, 0xe69dfb74,
        0xe6b8c42e, 0xe6d5c963, 0xe6ec1c6f, 0xe706e56d,
        0xe71d3831, 0xe73c7880, 0xe7597d5b, 0xe76fcfdd,
        0xe79c74df, 0xe7b502d4, 0xe7d44323, 0xe7ea95a4,
        0xe80c1166, 0xe8249f5b, 0xe841a436, 0xe869d252,
        0xe88024d4, 0xe898b2c8, 0xe8b140bd, 0xe8dbaa4c,
        0xe8f43841, 0xe90a8ac2, 0xe920dd44, 0xe9449479,
        0xe95ae6fa, 0xe977ebd6, 0xe9972c24, 0xe9ad7ea6,
        0xe9c8480e, 0xe9e54ce9, 0xe9fb9f6a, 0xea142d5f,
        0xea2cbb54, 0xea4784bc, 0xea5dd73d, 0xea7429be,
        0xea936a0d, 0xeaa9bc8f, 0xeac24a83, 0xead89d05,
        0xeaeeef86, 0xeb054207, 0xeb1b9489, 0xeb31e70a,
        0xeb559e3f, 0xeb6bf0c1, 0xeb824342, 0xeb9895c3,
        0xebb59a9f, 0xebcbed20, 0xebe23fa1, 0xec05f6d7,
        0xec1e84cb, 0xec34d74d, 0xec4b29ce, 0xec63b7c3,
        0xec7a0a44, 0xec905cc5, 0xeca6af47, 0xecbd01c8,
        0xecd3544a, 0xece9a6cb, 0xecfff94c, 0xed164bce,
        0xed3350a9, 0xed49a32a, 0xed62311f, 0xed7883a0,
        0xed8ed622, 0xeda528a3, 0xedbb7b24, 0xedd1cda6,
        0xede82027, 0xedfe72a8, 0xee14c52a, 0xee2b17ab,
        0xee416a2c, 0xee57bcae, 0xee6e0f2f, 0xee8461b0,
        0xee9ab432, 0xeeb106b3, 0xeec75934, 0xeeddabb6,
        0xeef3fe37, 0xef0a50b9, 0xef20a33a, 0xef36f5bb,
        0xef4d483d, 0xef639abe, 0xef79ed3f, 0xef903fc1,
        0xefa69242, 0xefbce4c3, 0xefd33745, 0xefe989c6,
        0xefffdc47, 0xf0162ec9, 0xf02c814a, 0xf042d3cb,
        0xf059264d, 0xf06f78ce, 0xf08806c3, 0xf09e5944,
        0xf0b4abc5, 0xf0cafe47, 0xf0e150c8, 0xf0f7a34a,
        0xf10df5cb, 0xf124484c, 0xf13a9ace, 0xf150ed4f,
        0xf1673fd0, 0xf17d9252, 0xf1985bba, 0xf1aeae3b,
        0xf1c500bc, 0xf1db533e, 0xf1f1a5bf, 0xf207f840,
        0xf21e4ac2, 0xf2349d43, 0xf24aefc4, 0xf2614246,
        0xf27794c7, 0xf28de748, 0xf2a439ca, 0xf2ba8c4b,
        0xf2d0decc, 0xf2e7314e, 0xf2fd83cf, 0xf313d650,
        0xf32a28d2, 0xf3407b53, 0xf3590948, 0xf371973d,
        0xf387e9be, 0xf39e3c3f, 0xf3b48ec1, 0xf3cd1cb5,
        0xf3e36f37, 0xf3f9c1b8, 0xf4101439, 0xf42666bb,
        0xf43cb93c, 0xf4530bbd, 0xf4695e3f, 0xf47fb0c0,
        0xf4960341, 0xf4ac55c3, 0xf4c2a844, 0xf4d8fac5,
        0xf4ef4d47, 0xf5059fc8, 0xf51bf249, 0xf53244cb,
        0xf548974c, 0xf55ee9ce, 0xf5753c4f, 0xf58b8ed0,
        0xf5a1e152, 0xf5b833d3, 0xf5ce8654, 0xf5e4d8d6,
        0xf5fb2b57, 0xf6117dd8, 0xf627d05a, 0xf63e22db,
        0xf654755c, 0xf66ac7de, 0xf6811a5f, 0xf6976ce0,
        0xf6adbf62, 0xf6c411e3, 0xf6da6464, 0xffffffff };
    unsigned int   crc = 0,
                    tmp,
                    add,
                    *pl;
    int             i;
    unsigned char   *p;

    if(!decenc) {   /* DECODE */

        tmp = crc = *(unsigned int *)(buff + 4);
        add = (crc >> 28) + 1;
        len >>= 2;

        pl = (unsigned int *)buff;
        for(i = 0; i < len; i++, pl++) {
            *pl -= ase_table[tmp & 0xff] + crc;
            tmp += add;
        }
        *(unsigned int *)(buff + 4) = 0;

    } else {        /* ENCODE */

        *(unsigned int *)(buff + 4) = 0;

        p = buff;
        for(i = 0; i < len; i++, p++) {
            crc = crc_table[(*p ^ crc) & 0xff] ^ (crc >> 8);
        }

        tmp = crc;
        add = (crc >> 28) + 1;
        len >>= 2;

        pl = (unsigned int *)buff;
        for(i = 0; i < len; i++, pl++) {
            *pl += ase_table[tmp & 0xff] + crc;
            tmp += add;
        }
        *(unsigned int *)(buff + 4) = crc;
    }
}


