/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include "ase_udp_decenc.h"
#include "show_dump.h"



#define VER     "0.1"
#define BUFFSZ  65536



int main(int argc, char *argv[]) {
    FILE            *fd;
    int             len;
    unsigned char   buff[BUFFSZ];


    setbuf(stdout, NULL);

    fputs("\n"
        "ASE UDP packets decoder "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\n"
            "Usage: %s <file_udpdump.txt>\n"
            "\n", argv[0]);
        exit(1);
    }

    fd = fopen(argv[1], "rb");
    if(!fd) {
        perror("\nError");
        exit(1);
    }

    len = fread(buff, 1, BUFFSZ, fd);
    fclose(fd);
    printf("- size:   %d\n\n", len);

    ase_udp_decenc(buff, len, 0);
    show_dump(buff, len, stdout);

    return(0);
}

