/*
    Copyright 2009 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl-2.0.txt
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define ASURACMP    // reads both zsize and size automatically
#include "asura_huffboh.c"



#define VER     "0.1"



int check_overwrite(char *fname);
void std_err(void);



typedef struct {
    char    sign[8];
    int     zsize;
    int     size;
} asuracmp_t;



int main(int argc, char *argv[]) {
    asuracmp_t  asuracmp;
    FILE    *fd,
            *fdo;
    int     len;
    char    *fin,
            *fout;

    fputs("\n"
        "Asura engine \"AsuraCmp\" files decompressor "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <input> <output>\n"
            "\n"
            "the tool automatically checks if the input file uses the AsuraCmp compression\n"
            "and uncompress its content, this is NOT an extractor because this compression\n"
            "is used with various types of files and not only with the file.PC archives\n"
            "\n", argv[0]);
        exit(1);
    }

    fin  = argv[1];
    fout = argv[2];

    printf("- open file %s\n", fin);
    fd = fopen(fin, "rb");
    if(!fd) std_err();

    if((fread(&asuracmp, 1, sizeof(asuracmp_t), fd) != sizeof(asuracmp_t)) || memcmp(asuracmp.sign, "AsuraCmp", 8)) {
        printf("\nError: the input file is not compressed with AsuraCmp\n");
        exit(1);
    }
    fseek(fd, 8, SEEK_SET); // only to be sure of the correct decompression

    printf("- create file %s\n", fout);
    if(check_overwrite(fout) < 0) exit(1);
    fdo = fopen(fout, "wb");
    if(!fdo) std_err();

    len = huffboh_unpack_file2file(fd, fdo);
    printf("- %d bytes unpacked\n", len);
    if(len != asuracmp.size) {
        printf("- alert: the amount of unpacked bytes differs than how much expected (%d)\n", asuracmp.size);
    }

    fclose(fdo);
    fclose(fd);
    printf("- done\n");
    return(0);
}



int check_overwrite(char *fname) {
    FILE    *fd;
    char    ans[16];

    fd = fopen(fname, "rb");
    if(!fd) return(0);
    fclose(fd);
    printf("  the file already exists, do you want to overwrite it (y/N)? ");
    fgets(ans, sizeof(ans), stdin);
    if(tolower(ans[0]) != 'y') return(-1);
    return(0);
}



void std_err(void) {
    perror("\nError");
    exit(1);
}


