/*
    Copyright 2008 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl.txt
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ctype.h>
#include "md5.h"

typedef uint8_t     u8;



#define VER         "0.1.1"



void pb_md5_starts(md5_context *pms, int seed);
u8 *do_md5(u8 *data, int len, int seed);



int main(int argc, char *argv[]) {
    int     i;
    u8      *cdkey,
            *p;

    fputs("\n"
        "Battlefield 2/2142 cdkey to PunkBuster GUID "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\n"
            "Usage: %s <cdkey_or_MD5hash>\n"
            "\n", argv[0]);
        exit(1);
    }

    cdkey = strdup(argv[1]);    // useless
    p = cdkey;
    if(strlen(cdkey) == 32) {
        for(i = 0; cdkey[i]; i++) {
            cdkey[i] = tolower(cdkey[i]);
        }
        printf("- cdkey MD5     %s\n", cdkey);
    } else {
        for(i = 0; cdkey[i]; i++) {
            if(cdkey[i] == '-') continue;
            *p++ = toupper(cdkey[i]);
        }
        *p = 0;
        printf("- cdkey         %s\n", cdkey);
        p = do_md5(cdkey, p - cdkey, 0);
    }
    p[0]             = '7';
    p[strlen(p) - 1] = 0;
    p = do_md5(p, 32, 0x12063);
    p = do_md5(p, 32, 0x11c85);
    printf("- PB GUID       %s\n", p);
    return(0);
}



void pb_md5_starts(md5_context *pms, int seed) {
    pms->total[0] = pms->total[1] = 0;
    pms->state[0] = (seed * 11) + 0x67452301;
    pms->state[1] = (seed * 71) - 0x10325477;
    pms->state[2] = (seed * 37) - 0x67452302;
    pms->state[3] = (seed * 97) + 0x10325476;
}



u8 *do_md5(u8 *data, int len, int seed) {
    md5_context ctx;
    int     i;
    u8      digest[16],
            *p;
    static u8   ret[33];
    static const u8 hex[] = "0123456789abcdef";

    pb_md5_starts(&ctx, seed);
    md5_update(&ctx, data, len);
    md5_finish(&ctx, digest);

    p = ret;
    for(i = 0; i < 16; i++) {
        *p++ = hex[digest[i] >> 4];
        *p++ = hex[digest[i] & 15];
    }
    *p = 0;
    return(ret);
}


