/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <stdarg.h>
#include <time.h>

#ifdef WIN32
    #include <winsock.h>
    #include <conio.h>
    #include "winerr.h"

    #define close       closesocket
    #define sleep       Sleep
    #define waitms      sleep
    #define ONESEC      1000
    typedef uint32_t    in_addr_t;

    #define KEYRIGHT    0x4d
    #define KEYLEFT     0x4b
    #define KEYUP       0x48
    #define KEYDOWN     0x50
    #define KEYPGUP     0x49
    #define KEYPGDOWN   0x51
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>
    #include <sys/times.h>
    #include "kbhit.h"

    #define getch       readch
    #define waitms(x)   usleep(x * 1000);
    #define ONESEC      1

    #define KEYRIGHT    0x43
    #define KEYLEFT     0x44
    #define KEYUP       0x41
    #define KEYDOWN     0x42
    #define KEYPGUP     0x35
    #define KEYPGDOWN   0x36
#endif



#define VER         "0.1"
#define BUFFSZ      0xffff      // max supported
#define PORT        3333

#define DO_JOIN     1
#define DO_ADMIN    2
#define DO_CMD      3



typedef struct {
    uint16_t    size;
    uint16_t    type;
    uint8_t     *data;
} bv2_pck_t;



void printmsg(uint8_t *data);
uint8_t *fgetz(void);
int bv2_send(int sd, uint16_t rnd, ...);
bv2_pck_t **bv2_recv(int sd, uint16_t *rnd);
void bv2_free(bv2_pck_t **pck);
int tcp_send(int sd, uint8_t *data, int size);
int tcp_recv(int sd, uint8_t *data, int size);
int timeout(int sock);
in_addr_t resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    bv2_pck_t   **pck;
    time_t      quittime    = 0;
    int         sd,
                i,
                rn,
                rc,
                state,
                nomessages  = 0;
    uint16_t    port        = PORT,
                *rnd;
    uint8_t     buser[0x45],
                bpass[0x11],
                *user       = "",
                *pass       = "",
                *auserpass  = NULL,
                *cmd        = NULL,
                *buff       = NULL,
                *host,
                *input,
                *p;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);
    setbuf(stderr, NULL);

    fputs("\n"
        "Babo Violent 2 RCON "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\n"
            "Usage: %s [options] <host[:port]>\n"
            "\n"
            "-p PORT   default port is %hu\n"
            "-w PASS   specify the server password (not really needed, try)\n"
            "-a U P    admin username and password, will be asked at runtime\n"
            "-c CMD    one-shot command, it will be sent and then exit\n"
            "-m        don't show the user messages\n"
            "\n", argv[0], port);
        exit(1);
    }

    argc--;
    for(i = 1; i < argc; i++) {
        if(((argv[i][0] != '-') && (argv[i][0] != '/')) || (strlen(argv[i]) != 2)) {
            printf("\nError: wrong option (%s)\n", argv[i]);
            exit(1);
        }
        switch(argv[i][1]) {
            case '-':
            case '?':
            case 'h': {
                exit(1);
                } break;
            case 'p': {
                if(!argv[++i]) exit(1);
                port        = atoi(argv[i]);
                } break;
            case 'w': {
                if(!argv[++i]) exit(1);
                pass        = argv[i];
                } break;
            case 'a': {
                if(!argv[++i]) exit(1);
                if(!argv[++i]) exit(1);
                auserpass   = malloc(strlen(argv[i - 1]) + 1 + strlen(argv[i]) + 1);
                if(!auserpass) std_err();
                sprintf(auserpass, "%s %s", argv[i - 1], argv[i]);
                } break;
            case 'c': {
                if(!argv[++i]) exit(1);
                cmd         = argv[i];
                } break;
            case 'm': {
                nomessages  = 1;
                } break;
            default: {
                printf("\nError: wrong argument (%s)\n", argv[i]);
                exit(1);
            }
        }
    }

    host = argv[argc];
    p = strchr(host, ':');
    if(p) {
        *p = 0;
        port = atoi(p + 1);
    }

    printf("- resolv %s", host);
    peer.sin_addr.s_addr = resolv(host);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;
    printf(" -> %s:%hu\n", inet_ntoa(peer.sin_addr), port);

    printf("- connect...");
    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();
    if(connect(sd, (struct sockaddr *)&peer, sizeof(peer))
      < 0) std_err();
    printf("ok\n");

    buff = malloc(BUFFSZ);
    if(!buff) std_err();

    if(tcp_recv(sd, buff, 37) < 0) goto quit;
    printf("- server hash: %.28s\n", buff + 5);

    rc      = 0;    // rc is the current RAND1 number in use by us
    rn      = 0;    // rn is RAND1 number in use by the server
    state   = 0;    // the current state used for joining, admin and commands

    rnd = calloc(sizeof(uint16_t), BUFFSZ);
    if(!rnd) std_err();

#ifndef WIN32
    init_keyboard();
#endif

    for(;;) {
        pck = NULL;
        if(!timeout(sd)) {
            pck = bv2_recv(sd, &rnd[rn]);
            if(!pck) goto quit;
            rn++;

            for(i = 0; pck[i]; i++) {
                switch(pck[i]->type) {
                    case 0x7e: {
                        printf("%s\n", pck[i]->data);
                        } break;
                    case 0xca: {
                        if(!nomessages) printmsg(pck[i]->data + 1);
                        } break;
                    case 0x74: {
                        if(state != DO_JOIN) {
                            printf("- ready for joining\n");
                            state = DO_JOIN;
                        }
                        } break;
                    case 0xc9: {
                        if(state != DO_ADMIN) {
                            printf("- ready for admin login\n");
                            if(!auserpass) {
                                printf(
                                    "- insert the admin username followed by the password (user pass):\n"
                                    "  or do nothing for reading what happens in the server\n");
                            }
                            state = DO_ADMIN;
                        }
                        } break;
                    case 0x7f: {
                        if(state != DO_CMD) {
                            printf("- admin access granted, now type your commands:\n");
                            state = DO_CMD;
                        }
                        } break;
                    case 0x6a: {
                        if(bv2_send(sd, rnd[rc++],
                            pck[i]->size, 0x01, pck[i]->data,
                            NULL, NULL, NULL) < 0) goto quit;
                        } break;
                    default: {
                        // printf("%02x ", pck[i]->type);
                        } break;
                }
            }

            bv2_free(pck);
        }

        input = fgetz();                                // get async input from keyboard

        if(state == DO_JOIN) {                          // login
            printf("- join\n");

            buser[0] = 0;
            memset(buser + 1, 0, 16);
            strncpy(buser + 1 + 16, user, 32);
            strncpy(buser + 1 + 16 + 32, "00-53-45-00-00-00", 20);

            bpass[0] = 0;
            strncpy(bpass + 1, pass, 16);

            if(bv2_send(sd, rnd[rc++],
                sizeof(buser), 0xc9, buser,
                sizeof(bpass), 0x04, bpass,
                NULL, NULL, NULL) < 0) goto quit;

            state = 0;

        } else if(state == DO_ADMIN) {                  // admin
            if(!auserpass && input) {
                auserpass = strdup(input);
            }
            if(auserpass) {
                printf("- send admin login: %s\n", auserpass);

                if(bv2_send(sd, rnd[rc++],
                    strlen(auserpass) + 1, 0x06, auserpass,
                    NULL, NULL, NULL) < 0) goto quit;

                printf("  if you don't receive the \"admin access granted\" message means that the\n"
                       "   username or password you typed were wrong, so retype them (user pass)\n");

                free(auserpass);
                auserpass = NULL;
            }

        } else if(state == DO_CMD) {                    // command
            if(!cmd && input) cmd = input;
            if(cmd) {
                p = cmd;
                if(*p == '-') p++;
                while((*p == ' ') || (*p == '\t')) p++;

                printf("- send admin command: \"%s\"\n", p);

                if(bv2_send(sd, rnd[rc++],
                    strlen(p) + 1, 0x7e, p,
                    NULL, NULL, NULL) < 0) goto quit;

                if(cmd != input) quittime = time(NULL) + 2;
                cmd = NULL;
            }
        }

        if(quittime && (time(NULL) >= quittime)) goto quit;
    }

quit:
    printf("- finished or disconnected\n");
    close(sd);
    free(buff);
#ifndef WIN32
    close_keyboard();
#endif
    return(0);
}



void printmsg(uint8_t *data) {
    int         i;
    uint8_t     buff[512],
                *p;

    i = 0;
    for(p = data; *p && (i < sizeof(buff)); p++) {
        if(*p >= ' ') buff[i++] = *p;
    }
    buff[i] = 0;
    printf("%s\n", buff);
}



uint8_t *fgetz(void) {
    int     n;
    static int      cmdlen   = 0;
    static uint8_t  cmd[256] = "";

    if(kbhit()) {
        n = getch();
        fputc(n, stderr);
        if((n == '\n') || (n == '\r') || (cmdlen >= 512)) {
            cmdlen = 0;
            return(cmd);

        } else if(n == '\b') {
            fputc(' ', stderr);
            fputc('\b', stderr);
            cmd[cmdlen] = 0;
            if(cmdlen > 0) cmdlen--;

        } else {
            cmd[cmdlen++] = n;
            cmd[cmdlen]   = 0;
        }
    }
    return(NULL);
}



int bv2_send(int sd, uint16_t rnd, ...) {
    va_list     ap;
    int         num,
                i,
                len;
    uint16_t    size,
                type;
    uint8_t     *buff,
                *data,
                *p;

    len = 8 + 1;

    va_start(ap, rnd);
    for(num = 0; ; num++) {
        size = va_arg(ap, int);
        type = va_arg(ap, int);
        if(!va_arg(ap, uint8_t *)) break;
        len += 2 + 2 + size;
    }
    va_end(ap);

    buff = malloc(len);
    if(!buff) std_err();

    sprintf(buff, "RND1%04x", rnd);
    buff[8] = num;
    p = buff + 9;

    va_start(ap, rnd);
    for(i = 0; i < num; i++) {
        size = va_arg(ap, int);
        type = va_arg(ap, int);
        data = va_arg(ap, uint8_t *);

        *(uint16_t *)p = size;  p += 2;
        *(uint16_t *)p = type;  p += 2;
        memcpy(p, data, size);  p += size;
    }
    va_end(ap);

    if(tcp_send(sd, buff, len) < 0) {
        free(buff);
        return(-1);
    }
    free(buff);
    return(0);
}



bv2_pck_t **bv2_recv(int sd, uint16_t *rnd) {
    int         num,
                i;
    bv2_pck_t   **pck;
    uint8_t     buff[16];

    if(tcp_recv(sd, buff, 9) < 0) return(NULL);
    if(memcmp(buff, "RND1", 4)) return(NULL);
    sscanf(buff + 4, "%04hx", rnd);

    num = buff[8];
    pck = calloc(num + 1, sizeof(uint8_t *));
    if(!pck) return(NULL);

    for(i = 0; i < num; i++) {
        if(tcp_recv(sd, buff, 4) < 0) return(NULL);

        pck[i] = malloc(sizeof(bv2_pck_t));
        if(!pck[i]) return(NULL);

        pck[i]->size = *(uint16_t *)(buff);
        pck[i]->type = *(uint16_t *)(buff + 2);
        pck[i]->data = malloc(pck[i]->size);
        if(!pck[i]->data) return(NULL);

        if(tcp_recv(sd, pck[i]->data, pck[i]->size) < 0) return(NULL);
    }

    return(pck);
}



void bv2_free(bv2_pck_t **pck) {
    int     i;

    if(!pck) return;
    for(i = 0; pck[i]; i++) {
        if(pck[i]->data) free(pck[i]->data);
        free(pck[i]);
    }
    free(pck);
}



int tcp_send(int sd, uint8_t *data, int size) {
    if(send(sd, data, size, 0) != size) return(-1);
    return(0);
}



int tcp_recv(int sd, uint8_t *data, int size) {
    int     t;

    while(size) {
        t = recv(sd, data, size, 0);
        if(t <= 0) return(-1);
        data += t;
        size -= t;
    }
    return(0);
}



int timeout(int sock) {
    struct  timeval tout;
    fd_set  fd_read;
    int     err;

    tout.tv_sec  = 0;
    tout.tv_usec = 10000;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    err = select(sock + 1, &fd_read, NULL, NULL, &tout);
    if(err < 0) std_err();
    if(!err) return(-1);
    return(0);
}



in_addr_t resolv(char *host) {
    struct      hostent *hp;
    in_addr_t   host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n",
                host);
            exit(1);
        } else host_ip = *(in_addr_t *)(hp->h_addr);
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif

