/*
    Copyright 2009 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl-2.0.txt
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>

#ifdef WIN32
    #include <direct.h>
    #define PATHSLASH   '\\'
    #define MAKEDIR(x)  mkdir(x)   
#else
    #include <unistd.h>
    #define PATHSLASH   '/'
    #define MAKEDIR(x)  mkdir(name, 0755)
#endif

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define VER     "0.1"

#define PK1		0x04034b50	/* local_dir */
#define CH1		0xa0caaae3
#define PK2		0x02014b50	/* central_dir */
#define CH2		0x5c7eaae3
#define PK3		0x06054b50	/* end_central_dir */
#define CH3		0x242baae3

#pragma pack(2)
typedef struct {
    u16 ver;
    u16 flag;
    u16 method;
    u32 timedate;
    u32 crc;
    u32 comp_size;
    u32 uncomp_size;
    u16 name_len;
    u16 extra_len;
    /* filename */
    /* extra */
} local_dir_t;

typedef struct {
    u16 ver_made;
    u16 ver_ext;
    u16 flag;
    u16 method;
    u32 timedate;
    u32 crc;
    u32 comp_size;
    u32 uncomp_size;
    u16 name_len;
    u16 extra_len;
    u16 comm_len;
    u16 disk_start;
    u16 int_attr;
    u32 ext_attr;
    u32 offset;
    /* filename */
    /* extra */
    /* comment */
} central_dir_t;

typedef struct {
    u16 disk_num;
    u16 disk_num_start;
    u16 tot_ent_disk;
    u16 tot_ent_dir;
    u32 dir_size;
    u32 offset;
    u16 comm_len;
    /* comment */
} end_central_dir_t;
#pragma pack()



int canhel_method(int method);
void std_err(void);



int main(int argc, char *argv[]) {
    local_dir_t         local_dir;
    central_dir_t       central_dir;
    end_central_dir_t   end_central_dir;
    FILE    *fd;
    u32     sign;
    u8      *fname;

    fputs("\n"
        "Canhel PAC->ZIP and ZIP->PAC converter "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stderr);

    if(argc < 2) {
        fprintf(stderr, "\n"
            "Usage: %s <file.PAC/ZIP>\n"
            "\n"
            "the input file will be automatically modified to be a zip file (PAC->ZIP) or\n"
            "viceversa if the input is a ZIP (ZIP->PAC) so, although it's not needed, a\n"
            "backup of the original files could be useful\n"
            "\n", argv[0]);
        exit(1);
    }
    fname = argv[1];

    printf("- convert file %s\n", fname);
    fd = fopen(fname, "r+b");
    if(!fd) std_err();

#define SIMPLE_SIGN(X)  if((sign == CH##X) || (sign == PK##X)) { \
                            sign = (sign == CH##X) ? PK##X : CH##X;

    while((fread(&sign, 1, 4, fd) == 4)) {
        SIMPLE_SIGN(1)
            printf("  %08x local_dir\n", (u32)ftell(fd));
            fseek(fd, -4, SEEK_CUR);
            fwrite(&sign, 1, 4, fd);

            if(fread(&local_dir, 1, sizeof(local_dir), fd) != sizeof(local_dir)) break;
            local_dir.method = canhel_method(local_dir.method);
            fseek(fd, -sizeof(local_dir), SEEK_CUR);
            fwrite(&local_dir, 1, sizeof(local_dir), fd);

            if(fseek(fd, local_dir.name_len,  SEEK_CUR)) std_err();
            if(fseek(fd, local_dir.extra_len, SEEK_CUR)) std_err();
            if(fseek(fd, local_dir.comp_size, SEEK_CUR)) std_err();

        } else SIMPLE_SIGN(2)
            printf("  %08x central_dir\n", (u32)ftell(fd));
            fseek(fd, -4, SEEK_CUR);
            fwrite(&sign, 1, 4, fd);

            if(fread(&central_dir, 1, sizeof(central_dir), fd) != sizeof(central_dir)) break;
            central_dir.method = canhel_method(central_dir.method);
            fseek(fd, -sizeof(central_dir), SEEK_CUR);
            fwrite(&central_dir, 1, sizeof(central_dir), fd);

            if(fseek(fd, central_dir.name_len,  SEEK_CUR)) std_err();
            if(fseek(fd, central_dir.extra_len, SEEK_CUR)) std_err();
            if(fseek(fd, central_dir.comm_len,  SEEK_CUR)) std_err();

        } else SIMPLE_SIGN(3)
            printf("  %08x end_central_dir\n", (u32)ftell(fd));
            fseek(fd, -4, SEEK_CUR);
            fwrite(&sign, 1, 4, fd);

            if(fread(&end_central_dir, 1, sizeof(end_central_dir), fd) != sizeof(end_central_dir)) break;
            // nothing to change here

            if(fseek(fd, end_central_dir.comm_len,  SEEK_CUR)) std_err();

        } else {
            printf("\nError: unsupported PK sign (%08x)\n", sign);
            exit(1);
        }
    }

    fclose(fd);
    printf("- done\n");
    return(0);
}



int canhel_method(int method) {
    if(method == 8) {
        method = 1; // ZIP->PAC
        // note that some files (like in DTdata_map_a_d03.pac) use method 2 but it's just the same compression
    } else if(method == 0) {
        // do nothing
    } else {
        method = 8; // PAC->ZIP
    }
    return(method);
}



void std_err(void) {
    perror("\nError");
    exit(1);
}


