/*
    Copyright 2006 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl.txt
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>

#ifdef WIN32
    #include <direct.h>

    typedef unsigned char   u_char;
    typedef unsigned short  u_short;
    typedef unsigned int    u_int;
#else
    #include <unistd.h>

    #define MAX_PATH    512
    #define stristr strcasestr
    #define stricmp strcasecmp
#endif



#define VER         "0.1"
#define XFOFF       offset = *(u_int *)fdata;               \
                    fdata += 4
#define XFSIZE      size = *(u_int *)fdata;                 \
                    fdata += 4
#define XFNAME      XFSIZE;                                 \
                    name = malloc(size + 1);                \
                    if(!name) std_err();                    \
                    memcpy(name, fdata, size);              \
                    name[size] = 0;                         \
                    fdata += size
#define SHOWLIST    if(chdir(currdir) < 0) std_err();       \
                    fputs("\n"                              \
                        "  Offset        Size  Filename\n"  \
                        "------------------------------\n", \
                    stdout);
#define MYFSEEK(x)  if(fseek(fd, x, SEEK_SET) < 0) std_err();



u_char *extcmp(u_char *s1, u_char *s2);
u_char *filemem(u_char *fname, int *size);
void extract(FILE *fd, u_int offset, u_char *fname, u_int len);
void std_err(void);



int main(int argc, char *argv[]) {
    struct stat xstat;
    FILE    *fd      = NULL;
    u_int   fdsize,
            size,
            offset,
            num,
            nextoff,
            idx,
            workaround; // this was for Libs.bin which is unused!!!
    int     i,
            ext      = 0,
            listonly = 0;
    u_char  currdir[MAX_PATH + 1],
            *folder  = ".",
            *pattern = NULL,
            *fdata,
            *fname,
            *filename,
            *name,
            *limit,
            *p;


    setbuf(stdout, NULL);

    fputs("\n"
        "Close Combat First to Fight files extractor "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\n"
            "Usage: %s [options] <file.BIN/XXX/PWB>\n"
            "\n"
            "Options:\n"
            "-l       list files without extracting them\n"
            "-d DIR   the folder where the files will be extracted (default %s)\n"
            "-p PAT   extracts only the files containing PAT, like -p xbox for example\n"
            "\n", argv[0], folder);
        exit(1);
    }

    argc--;
    for(i = 1; i < argc; i++) {
        switch(argv[i][1]) {
            case 'l': listonly = 1;         break;
            case 'd': folder   = argv[++i]; break;
            case 'p': pattern  = argv[++i]; break;
            default: {
                printf("\nError: wrong command-line argument (%s)\n\n", argv[i]);
                exit(1);
                } break;
        }
    }

    printf("- enter folder:   %s\n", folder);
    if(chdir(folder) < 0) std_err();
    getcwd(currdir, sizeof(currdir) - 1);

    fname = argv[argc];
    p = strrchr(fname, '\\');
    if(!p) p = strrchr(fname, '/');
    if(p) {
        *p = 0;
        printf("- enter folder:   %s\n", fname);
        if(chdir(fname) < 0) std_err();
        if(fname[strlen(fname) - 1] == ':') {
            chdir("\\");    // root path work-around
        }
        fname = p + 1;
    }

    p = extcmp(fname, "pwb");
    if(p) {
        fd = fopen(fname, "rb");
        if(!fd) std_err();

        p--;
        *p = 0;
        filename = malloc((p - fname) + 13 + 1);
        if(!filename) std_err();

        fread(&num, 4, 1, fd);
        idx = 4;

        SHOWLIST;

        while(num--) {
            if(!fread(&offset, 4, 1, fd)) break;
            idx += 4;

            if(num) {
                if(!fread(&nextoff, 4, 1, fd)) break;
            } else {
                fstat(fileno(fd), &xstat);
                nextoff = xstat.st_size;
            }
            size = nextoff - offset;

            sprintf(filename, "%s_%08x.wav", fname, offset);

            if(pattern && !stristr(filename, pattern)) continue;

            printf("  %08x  %10u  %s\n", offset, size, filename);

            if(!listonly) {
                extract(fd, offset, filename, size);
            }

            MYFSEEK(idx);
            ext++;
        }

        goto show_result;
    }

    p = extcmp(fname, "xxx");
    if(p) {
        printf("- XXX is the extension for the archives, I try to load the index (BIN) file\n");
        strcpy(p, "bin");
    }

    printf("- load file:      %s\n", fname);
    fdata = filemem(fname, &fdsize);
    limit = fdata + fdsize;

    XFSIZE;
    workaround = size;
    if(!workaround) fdata += 8;

    XFNAME;
    printf("- data file:      %s\n", name);

    if(!listonly) {
        fd = fopen(name, "rb");
        if(!fd) std_err();
    }
    free(name);

    if(!workaround) {
        fdata += 17;
    } else if(workaround == 3) {
        fdata += 16;
    }

    SHOWLIST;

    while(fdata < limit) {
        fdata += 4;

        XFNAME;
        XFSIZE;
        XFOFF;

        if(!size) { // this was for Libs.bin which is unused
            offset = 0;
            fdata -= 4;
        }
        if(!*fdata && (*(u_int *)fdata != 0x3f800000)) {
            fdata += 2;     // lame solution but works
        }

        if(pattern && !stristr(name, pattern)) {
            free(name);
            continue;
        }

        printf("  %08x  %10u  %s\n", offset, size, name);

        if(!listonly) {
            extract(fd, offset, name, size);
        }
        free(name);
        ext++;
    }

show_result:
    if(!listonly) fclose(fd);
    printf("\n- %u files %s\n",
        ext,
        listonly ? "listed" : "extracted");
    return(0);
}



u_char *extcmp(u_char *s1, u_char *s2) {
    u_char  *p;

    p = strrchr(s1, '.');
    if(!p) return(NULL);
    p++;

    if(stricmp(p, s2)) return(NULL);
    return(p);
}



u_char *filemem(u_char *fname, int *size) {
    struct stat xstat;
    FILE    *fd;
    u_char  *mem;

    fd = fopen(fname, "rb");
    if(!fd) std_err();
    fstat(fileno(fd), &xstat);
    *size = xstat.st_size;
    mem = malloc(*size);
    if(!mem) std_err();
    fread(mem, *size, 1, fd);
    fclose(fd);
    return(mem);
}



void extract(FILE *fd, u_int offset, u_char *fname, u_int len) {
    FILE    *fdo;
    int     t;
    u_char  buff[4096];

    MYFSEEK(offset);

    fdo = fopen(fname, "wb");
    if(!fdo) std_err();

    for(t = sizeof(buff); len; len -= t) {
        if(t > len) t = len;
        if(!fread(buff, t, 1, fd)) break;
        fwrite(buff, t, 1, fdo);
    }

    fclose(fdo);
}



void std_err(void) {
    perror("\nError");
    exit(1);
}


