/*

    Copyright 2004,2005,2006 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl.txt

*/

#include <stdio.h>
#include <stdlib.h>



#define VER         "0.1"
#define BUFFSZ      32
#define CMR3BONUS   10  // the available cheats



char *cmr3_cheats(int code, int counter);



int main(void) {
    char    buff[BUFFSZ + 1],
            *codetypes[CMR3BONUS] = {
            "Baja Buggy",
            "Jet",
            "Hovercraft",
            "Battle Tank",
            "R/C cars",
            "All cars",
            "All tracks",
            "All parts",
            "All difficulties",
            "Ford Super Focus" };
    int     code,
            i;


    setbuf(stdout, NULL);

    fputs("\n"
        "Colin McRae Rally 3 bonus cheats calculator "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    fputs("Insert your bonus code: ", stdout);
    fgets(buff, BUFFSZ, stdin);
    code = atoi(buff);

    for(i = 0; i < CMR3BONUS; i++) {
        printf("\n  %-18s  %s",
            codetypes[i],
            cmr3_cheats(code, i));
    }

    fputs("\n\nPress RETURN to exit\n", stdout);
    fgetc(stdin);
    return(0);
}



char *cmr3_cheats(int code, int counter) {
    static char cheat[7];
    int         ecx,
                esi,
                edi;
    div_t       res;

    if((code > 9999) || (counter > 99)) {
        cheat[0] = 0;
        return(cheat);
    }

    ecx = counter % 100;
    res = div(code, 100);
    edi = ecx ^ res.rem;
    ecx ^= res.quot;

    if(edi) {
        esi = 57;
        while(--edi) {
            esi = (esi * 57) % 0x44a5;
        }
    } else esi = 1;

    if(ecx) {
        edi = 57;
        while(--ecx) {
            edi = (edi * 57) % 0x44a5;
        }
    } else edi = 1;

    res = div(esi, 26);
    cheat[0] = 'Z' - res.rem;
    esi = ((long long)0x60f25deb * esi) >> 40;
    cheat[1] = 'Z' - (esi % 26);
    cheat[2] = 'Z' - (res.quot % 26);

    res = div(edi, 26);
    cheat[5] = 'Z' - res.rem;
    edi = ((long long)0x60f25deb * edi) >> 40;
    cheat[4] = 'Z' - (edi % 26);
    cheat[3] = 'Z' - (res.quot % 26);

    cheat[6] = 0;

    return(cheat);
}


