/*

COGS Gamearena IRC challenge algorithm 0.1
by Luigi Auriemma
e-mail: aluigi@autistici.org
web:    aluigi.org


INTRODUCTION
============
The Gamearena IRC server (202.12.147.123:4445) sends a challenge request
(the CRYP command) to the client that must answer with a specific
response calculated on the received string.
This function is able to generate the needed response to send back to
the server.


HOW TO USE
==========
 #include "cogs_irc_chall.h"

  u_char data[] = "abcdabcdabcdabcd";
  cogs_irc_chall(data, strlen(data));
  printf("The challenge is %s\n", data);

the size of the data (response) is the SAME of the original (request)
Then you must simply send the CRYP command to the server as the
following example:

  CRYP :SSTVORJRRWNRSSRV


LICENSE
=======
    Copyright 2004,2005,2006 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl.txt

*/


void cogs_irc_chall(unsigned char *buff, int size) {
    int     c1,
            c2 = 2;
    char    encdata[] = "caqsaq";

    for(c1 = 0; c1 < size; c1++) {
        if((c1 == 2) || (c1 == 6)) {
            *buff = encdata[c1 % 6];
        } else {
            *buff = ((0xdb - *buff) + encdata[c2 % 6]) >> 1;
        }
        *buff = ((encdata[c1 % 6] >> 1) + *buff) >> 1;
        buff++;
        c2++;
    }
}

