/*
    Copyright 2005,2006 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl.txt
*/

#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <windows.h>
#include <wincrypt.h>

#include <winsock.h>



#define VER     "0.1"
#define KEY     "ectGameMon"
#define SIGN1   0x32812622
#define SIGN2   0x32812621
#define PUBKEY  "\x06\x02\x00\x00\x00\x24\x00\x00\x52\x53\x41\x31\x00\x02\x00\x00" \
                "\x01\x00\x01\x00\xFB\xE3\xFC\x09\xAF\xAE\x65\x8C\x96\x4C\xC5\x37" \
                "\xD2\xA4\x77\xE7\x4C\x41\xC2\xCF\xF2\xFE\x2D\x9C\x80\x94\x0C\x88" \
                "\x6D\xB3\x84\x9F\x8C\x22\xA0\xC9\xCD\xC0\xAB\x30\x65\x82\x42\x3C" \
                "\xEE\x3C\xA8\xB7\x11\xD6\x22\xFA\xFB\x23\xF7\x72\xCD\xE7\xD0\x6F" \
                "\x6A\x8E\x96\xE3"



void std_err(int type);



int main(int argc, char *argv[]) {
    FILE        *fd;
    struct stat xstat;
    HCRYPTPROV  hProv;
    HCRYPTHASH  hHash;
    HCRYPTKEY   hKey;
    DWORD       len;
    u_int      buffsz;
    u_char      *buff,
                *input,
                *output,
                *filename,
                *signature;

    struct gameguard_header {
        u_int  sign1;
        u_int  filename_size;
        u_int  signature_size;
        u_int  sign2;
    } *gh = NULL;


    setbuf(stdout, NULL);

    fputs("\n"
        "GameGuard files decrypter "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <input_file> <output_file>\n"
            "\n", argv[0]);
        exit(1);
    }

    input  = argv[1];
    output = argv[2];

    printf("- open input file:     %s\n", input);
    fd = fopen(input, "rb");
    if(!fd) std_err(0);

    fstat(fileno(fd), &xstat);
    buffsz = xstat.st_size;
    printf("  filesize:            %u\n", buffsz);

    buff = malloc(buffsz);
    if(!buff) std_err(0);
    len = fread(buff, 1, buffsz, fd);
    fclose(fd);

    len -= sizeof(struct gameguard_header);
    gh = (struct gameguard_header *)(buff + len);
    len -= (gh->filename_size + gh->signature_size);

    if((gh->sign1 != SIGN1) ||
       (gh->sign2 != SIGN2)) {
        printf("\n"
            "Alert: the signs in the file don't match the default signs, I try to continue:\n"
            "       0x%08x (should be 0x%08x) and 0x%08x (should be 0x%08x)\n"
            "\n",
            gh->sign1, SIGN1,
            gh->sign2, SIGN2);
    }

    filename  = buff + len;
    printf("- built-in filename:   %s\n", filename);
    signature = buff + len + gh->filename_size;

    if(!CryptAcquireContext(
        &hProv,
        NULL,
        MS_DEF_PROV,
        PROV_RSA_FULL,
        CRYPT_VERIFYCONTEXT)) std_err(1);

            /* VERIFY SIGNATURE */

    fputs("- verify signature:", stdout);

    if(!CryptCreateHash(
        hProv,
        CALG_MD5,
        0,
        0,
        &hHash)) std_err(1);

    if(!CryptImportKey(
        hProv,
        PUBKEY,
        sizeof(PUBKEY) - 1,
        0,
        0,
        &hKey)) std_err(1);

    if(!CryptHashData(
        hHash,
        buff,
        len + gh->filename_size,
        0)) std_err(1);

    if(!CryptVerifySignature(
        hHash,
        signature,
        gh->signature_size,
        hKey,
        NULL,
        0)) {
        fputs("    WRONG!\n", stdout);
    } else {
        fputs("    OK\n", stdout);
    }

    CryptDestroyKey(hKey);
    CryptDestroyHash(hHash);

            /* DECRYPT DATA */

    if(!CryptCreateHash(
        hProv,
        CALG_MD5,
        0,
        0,
        &hHash)) std_err(1);

    if(!CryptHashData(
        hHash,
        KEY,
        sizeof(KEY) - 1,
        0)) std_err(1);

    if(!CryptDeriveKey(
        hProv,
        CALG_RC4,
        hHash,
        0,
        &hKey)) std_err(1);

    if(!CryptDecrypt(
        hKey,
        0,
        TRUE,
        0,
        buff,
        &len)) std_err(1);

    printf("- write output file:   %s\n", output);
    fd = fopen(output, "wb");
    if(!fd) std_err(0);
    fwrite(buff, len, 1, fd);
    fclose(fd);

    CryptDestroyKey(hKey);
    CryptDestroyHash(hHash);
    CryptReleaseContext(hProv, 0);
    free(buff);
    fputs("- Finished\n", stdout);
    return(0);
}



void std_err(int type) {
    if(type) {
        printf("\n"
            "Error: error during the usage of the cryptography (0x%lx)\n"
            "       If you received a sign error before means this is not a valid GameGuard\n"
            "       INI file\n"
            "\n", GetLastError());
    } else {
        perror("\nError");
    }
    exit(1);
}


