<?php
/// Adapted from code by Luigi Auriemma: http://aluigi.altervista.org/
/// Validation code converted from C to PHP by Lithium.
/// EncType2_Decoder converted from C to VB by Tres: http://www.nfbsp.com/
/// Both of the above converted from PHP and VB to C# by FordGT90Concept.
/// C# code converted to PHP by FordGT90Concept and UltimateSniper: http://www.ulti-s.tk/
/// 
/// EncType1 not supported.

/// Takes the gamename, handoff, enctype, and handoff and returns a list of IP:Ports.
/// "gamename"	The name of the game.  A relatively complete list of these can be found in C:\Program Files\GameSpy Arcade\Services\detection.cfg
/// "handoff"	The game's handoff.  This can be found via http://motd.gamespy.com/software/services/index.aspx?mode=full&services=GAMENAME
/// "type"		Recommended to use EncType.Advanced2--EncType.Basic is obsolete and EncType.Advanced1 is unsupported.
/// "filter"	A filter to apply.  It is the same as what you would enter into GameSpy Arcade filters.
/// Returns an array of strings.  Each string represents the IP:Port of a hosting server.
function GetMasterServerList($gamename, $handoff, $enctype, $filter){

	// Open Socket to Master Browser
	$tcp = fsockopen("tcp://master.gamespy.com", 28900, $errno, $errstr, 10);

	// Try and retrieve the Header String (NOTE THE EXTRA SLASHES !!!)
	$data = fgets($tcp, 22);
	
	$addrs = null;
	if(substr($data,0,15)=="\\basic\\\\secure\\") {
		$handoff = GetArray(GetHandoff($handoff));
		$tosend = "\\basic\\gamename\\".$gamename."\\enctype\\".$enctype."\\location\\0\\where\\".$filter."\\validate\\".MakeValidate(GetArray(GetSecureKey($data)), $handoff, $enctype)."\\final\\list\\\\gamename\\".$gamename."\\final\\";
		
		//Send the server list request to the Master
		fwrite($tcp, $tosend, strlen($tosend));
	
		//Download the IP list and sort it into an array
		$received="";
		while($read=fread($tcp,50))
			$received.=$read;

		// Finally Close The Socket
		fclose($tcp);

		switch ($enctype)
		{
			case 2:
				$addrs = GetServerList(DecodeAdvanced2(GetArray($received, true), $handoff));
				break;
			default:
				// Not supported
				$addrs = null;
				break;
		}
	}
	return $addrs;
}

/// Makes the handoff 6 bytes long.  If it is already 6 bytes long, it will return it.
/// "handoff"	The handoff which is 6 bytes or longer.
/// Returns the 6 byte version of the handoff.
function GetHandoff($handoff){
	if (strlen($handoff) == 6) {
		return $handoff;
	} else {
		$return="";
		for ($i = 2; $i <= 13; $i = $i + 2)
			$return .=$handoff[$i];
		return $return;
	}
}

/// Extracts the secure key from the initial response from the master server.
/// "message"	Appears something like "\basic\\secure\SECURE"
/// Returns the 6 byte long secure key.
function GetSecureKey($message){
	return substr($message, 15, 6);
}

// Converted from Lithium's PHP code...

/// Creates an 8 byte validation code from the 6 byte secure key and 6 byte handoff.
/// "securekey"	The 6 byte string received from the master server.
/// "handoff"	A 6 or more byte long game handoff.
/// "type"		The encryption type to process.
/// Returns the 8 byte long validate string.
function MakeValidate($securekey, $handoff, $enctype){
	$table = array();
	$securecount = count($securekey);
	$handcount = count($handoff);
	$temp = array();

	// Buffer with incremental data
	for($i = 0; $i < 256; $i++)
		$table[$i] = $i;

	// Scramble with key
	for($i = 0; $i < 256; $i++){
		//Scramble the Table with our Handoff
		$temp[0] = $temp[0] + $table[$i] + $handoff[$i % $handcount] & 255;
		$temp[2] = $table[$temp[0]];

		//Update the buffer
		$table[$temp[0]] = $table[$i];
		$table[$i] = $temp[2];
	}

	// Scramble securekey with buffer
	$temp[0] = 0;
	$key = array();
	for($i = 0; $i < $securecount; $i++){
		//Add the next char to the array
		$key[$i] = $securekey[$i];

		$temp[0] = ($temp[0] + $key[$i] + 1) & 255;
		$temp[2] = $table[$temp[0]];

		$temp[1] = ($temp[1] + $temp[2]) & 255;
		$temp[3] = $table[$temp[1]];

		$table[$temp[1]] = $temp[2];
		$table[$temp[0]] = $temp[3];

		//XOR the Buffer
		$key[$i] ^= $table[($temp[2] + $temp[3]) & 255];
	}
	
	// EncType management
	switch ($enctype)
	{
			//NOT SUPPORTING
		//case EncType.Inefficient:
			//for (byte i = 0; i < securekey.Length; i++)
			//	key[i] = EncType1_Data[key[i]];
			//break;
			//
		case 2:
			for($i = 0; $i < $securecount; $i++)
				$key[$i] ^= $handoff[$i % $handcount];
			break;
	}

	$length = $securecount / 3;
	$sb = "";
	$j = 0;
	while($length >= 1){
		$length--;

		$temp[2] = $key[$j];
		$temp[3] = $key[$j + 1];

		$sb .= AddChar($temp[2] >> 2);
		$sb .= AddChar((($temp[2] & 3) << 4) | ($temp[3] >> 4));
		
		$temp[2] = $key[$j + 2];

		$sb .= AddChar((($temp[3] & 15) << 2) | ($temp[2] >> 6));
		$sb .= AddChar($temp[2] & 63);
		$j += 3;
	}

	return $sb;
}

/// Turns an integer into an ASCII char to be added to the validate code.
/// "value"		A number to convert.
/// Returns the character that represents 'value'.
function AddChar($value){
	if($value < 26) return chr($value + 65);
	if($value < 52) return chr($value + 71);
	if($value < 62) return chr($value - 4);
	if($value == 62) return "+";
	if($value == 63) return "/";
	return chr(0);
}

/// Decodes the information received from the master server.
/// "data"		The information received from the master server.
/// "handoff"	The 6 byte long array represeting the handoff.
/// Returns the decoded data as a string.
function DecodeAdvanced2($data, $handoff){
	$dest = array();
	for($i = 256; $i < 326; $i++)
		$dest[$i] = 0;
	$data[0] = ($data[0] ^ 236);
	for($i = 0; $i < count($handoff); $i++)
		$data[$i + 1] ^= $handoff[$i];
	$dest = Shared4($data, $dest);

	$datap = array();

	for($i = 0; $i < (count($data) - $data[0] - 1); $i++)
		$datap[$i] .= $data[$data[0] + $i + 1];
	if(count($datap) < 6)
		return GetString($data);

	$datap = Shared1($dest, $datap, count($datap));

	return GetString($datap);
}

// Array to string.
function GetString($array){
	$output = "";
	for ($i = 0; $i < count($array); $i++)
		$output.=chr($array[$i]);
	return $output;
}

// String to array.
function GetArray($string, $omitfirst=false){
	$ary = array();
	$i = 0;
	$p = 0;
	if($omitfirst)
		$i = 1;
	for($i; $i < strlen($string); $i++){
		$ary[$p] = ord(substr($string, $i, 1));
		$p++;
	}
	return $ary;
}

// String to IP:Port list.
function GetServerList($string){
	$addrs = array();
	$parts = explode("\\", $string);
	$p = 0;
	for ($i = 2; $i < count($parts)-1; $i += 2){
		$addrs[$p] = $parts[$i];
		$p++;
	}
	return $addrs;
}

// Converts 0x01020304 into array 0x01, 0x02, 0x03, 0x04.
function IntToArray($value){
	$hex = str_pad(dechex($value+0), 8, "0", STR_PAD_LEFT);  // Hex string
	$output = array();
	for ($i = 3; $i >=0; $i--)
		$output[3 - $i] = hexdec(substr($hex, $i * 2, 2));
	return $output;
}

$p_ind = 0;
function SumOverflow($a, $b){
	$res = ($a + $b) & 0xffffffff;
	return ($res % 4294967296) & 0xffffffff;
}
function Shared1($tbuff, $datap, $len){
	global $p_ind;
	$p_ind = 309;
	$s_ind = 309;

	$datap_ind = 0;
	$lalind = 309;

	$bytepart = 4;
	$ByteArray = array();
	while($len > 0){
		if($datap_ind % 63 == 0){
			$p_ind = $s_ind;
			$lalind = 309;
			$bytepart = 4;
			$tbuff = Shared2($tbuff, 16);
		}

		if($bytepart > 3){
			$t = $tbuff[$lalind];
			$ByteArray = IntToArray($t);
			$bytepart = 0;
			$lalind++;
		}
		$datap[$datap_ind] ^= ($ByteArray[$bytepart] % 256) & 0xff;
		$datap_ind++;
		$p_ind++;
		$bytepart++;
		$len--;
	}

	return $datap;
}
function Shared2($tbuff, $len){
	global $p_ind;
	$old_p_ind = $p_ind;
	$t2 = $tbuff[304];
	$t1 = $tbuff[305];
	$t3 = $tbuff[306];
	$t5 = $tbuff[307];
	$cnt = 0;
	for($i = 0; $i < $len; $i++){
		$p_ind = $t2 + 272;
		while($t5 < 65536){
			$t1 = SumOverflow($t1, $t5);
			$p_ind++;
			$t3 = SumOverflow($t3, $t1);
			$t1 = SumOverflow($t1, $t3);
			$tbuff[$p_ind - 17] = $t1;
			$tbuff[$p_ind - 1] = $t3;
			$t4 = (($t3 << 24) & 0xffffffff) | ($t3 >> 8);
			$tbuff[$p_ind + 15] = $t5;
			$t5 = ($t5 << 1) & 0xffffffff;
			$t2++;
			$t1 ^= $tbuff[$t1 & 255];
			$t4 ^= $tbuff[$t4 & 255];
			$t3 = (($t4 << 24) & 0xffffffff) | ($t4 >> 8);
			$t4 = ($t1 >> 24) | (($t1 << 8) & 0xffffffff);
			$t4 ^= $tbuff[$t4 & 255];
			$t3 ^= $tbuff[$t3 & 255];
			$t1 = ($t4 >> 24) | (($t4 << 8) & 0xffffffff);
		}

		$t3 ^= $t1;
		$tbuff[$old_p_ind + $i] = $t3;
		$t2--;
		$t1 = $tbuff[$t2 + 256];
		$t5 = $tbuff[$t2 + 272];
		$t1 = ~$t1 & 0xffffffff;
		$t3 = (($t1 << 24) & 0xffffffff) | ($t1 >> 8);
		$t3 ^= $tbuff[$t3 & 255];
		$t5 ^= $tbuff[$t5 & 255];
		$t1 = (($t3 << 24) & 0xffffffff) | ($t3 >> 8);
		$t4 = ($t5 >> 24) | (($t5 << 8) & 0xffffffff);
		$t1 ^= $tbuff[$t1 & 255];
		$t4 ^= $tbuff[$t4 & 255];
		$t3 = ($t4 >> 24) | (($t4 << 8) & 0xffffffff);

		$t5 = (($tbuff[$t2 + 288] << 1) + 1) & 0xffffffff;
		$cnt++;
	}
	$tbuff[304] = $t2;
	$tbuff[305] = $t1;
	$tbuff[306] = $t3;
	$tbuff[307] = $t5;
	return $tbuff;
}
function Shared3($data, $n1, $n2){
	$t2 = $n1;
	$t1 = 0;
	$t4 = 1;
	$data[304] = 0;
	$i = 32768;

	while($i != 0){
		$t2 = SumOverflow($t2, $t4);
		$t1 = SumOverflow($t1, $t2);
		$t2 = SumOverflow($t2, $t1);
		if(($n2 & $i) != 0){
			$t2 = ~$t2 & 0xffffffff;
			$t4 = (($t4 << 1) & 0xffffffff) + 1;
			$t3 = (($t2 << 24) & 0xffffffff) | ($t2 >> 8);
			$t3 ^= $data[$t3 & 255];
			$t1 ^= $data[$t1 & 255];
			$t2 = (($t3 << 24) & 0xffffffff) | ($t3 >> 8);
			$t3 = ($t1 >> 24) | (($t1 << 8) & 0xffffffff);
			$t2 ^= $data[$t2 & 255];
			$t3 ^= $data[$t3 & 255];
			$t1 = ($t3 >> 24) | (($t3 << 8) & 0xffffffff);
		}
		else{
			$data[$data[304] + 256] = $t2;
			$data[$data[304] + 272] = $t1;
			$data[$data[304] + 288] = $t4;
			$data[304]++;
			$t3 = (($t1 << 24) & 0xffffffff) | ($t1 >> 8);
			$t2 ^= $data[$t2 & 0xff];
			$t3 ^= $data[$t3 & 0xff];
			$t1 = (($t3 << 24) & 0xffffffff) | ($t3 >> 8);
			$t3 = ($t2 >> 24) | (($t2 << 8) & 0xffffffff);
			$t3 ^= $data[$t3 & 0xff];
			$t1 ^= $data[$t1 & 0xff];
			$t2 = ($t3 >> 24) | (($t3 << 8) & 0xffffffff);
			$t4 <<= 1 & 0xffffffff;
		}

		$i >>= 1;
	}
	$data[305] = $t2;
	$data[306] = $t1;
	$data[307] = $t4;
	$data[308] = $n1;
	return $data;
}
function Shared4($data, $dest){
	$src = array();
	for($i = 0; $i < count($data) - 1; $i++)
		$src[$i] = $data[$i + 1];
	$size = $data[0];

	for($i = 0; $i <= 255; $i++)
		$dest[$i] = 0;
	for($y = 0; $y <= 3; $y++){
		for($i = 0; $i <= 255; $i++)
			$dest[$i] = (($dest[$i] << 8) + $i) & 4294967295;

		$pos = $y;
		for($x = 0; $x <= 1; $x++)
			for($i = 0; $i <= 255; $i++){
				$tmp = $dest[$i];
				$pos = ($pos + ($tmp + $src[$i % $size])) & 0xff; //ToByte

				$dest[$i] = $dest[$pos];
				$dest[$pos] = $tmp;
			}
	}

	for($i = 0; $i <= 255; $i++)
		$dest[$i] ^= $i;

	$dest = Shared3($dest, 0, 0);

	return $dest;
}

?>