/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <pcap.h>
#include <winsock.h>



#define VER     "0.1"



void dispatcher_handler(u_char *temp1, const struct pcap_pkthdr *header, const u_char *pkt_data);
void gamespyxor(u_char *string, int len);
u_int resolv(char *host);



struct iphdr {
    u_int   ihl:4;
    u_int   version:4;
    u_char  tos;
    u_short tot_len;
    u_short id;
    u_short frag_off;
    u_char  ttl;
    u_char  protocol;
    u_short check;
    u_int   saddr;
    u_int   daddr;
};

struct udphdr {
    u_short source;
    u_short dest;
    u_short len;
    u_short check;
};

u_short port;



int main(int argc, char *argv[]) {
    char        errbuf[PCAP_ERRBUF_SIZE];
    pcap_t      *fp;
    int         i,
                inum;
    pcap_if_t   *alldevs,
                *d;


    setbuf(stdout, NULL);
    setbuf(stderr, NULL);

    fputs("\n"
        "GsHlog "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stderr);

    if(argc < 2) {
        printf("\n"
            "Vulnerable games                 Latest bugged versions  Default query ports\n"
            "----------------------------------------------------------------------------\n"
            "  Battlefield 1942               1.6.19, 1.6rc1          23000, 22000 (LAN)\n"
            "  Contract Jack                  1.1                     27888\n"
            "  Gore                           1.48 (1.49)             27778\n"
            "  Halo                           1.031                   2302\n"
            "  Hidden & Dangerous 2           1.04                    11004\n"
            "  IGI 2: Covert Strike           1.3                     26001\n"
            "  Judge Dredd: Dredd vs. Death   1.01                    25858\n"
            "  Need For Speed Hot Pursuit 2   242                     61220\n"
            "  TRON2.0                        1.042                   27888\n"
            "  ...possibly others...\n"
            "\n"
            "\n"
            "Usage: %s <query_port_to_log>\n"
            "\n", argv[0]);
        exit(1);
    }

    port = htons(atoi(argv[1]));

    if(pcap_findalldevs(&alldevs, errbuf) < 0) {
        fprintf(stderr, "Error in pcap_findalldevs: %s\n", errbuf);
        exit(1);
    }

    i = 0;
    fprintf(stderr, "\n\nInterfaces list:\n\n");
    for(d = alldevs; d; d = d->next) {
        fprintf(stderr, "%d. %s", ++i, d->name);
        if(d->description) fprintf(stderr, " (%s)\n", d->description);
            else fprintf(stderr, " (No description available)\n");
    }

    if(!i) {
        fprintf(stderr, "\nNo interfaces found! Make sure WinPcap is installed.\n");
        pcap_freealldevs(alldevs);
        exit(1);
    }
    if(i > 1) {
        fprintf(stderr, "\n\nEnter the interface number (1 - %d): ",i);
        scanf("%d", &inum);

        if(inum < 1 || inum > i) {
            fprintf(stderr, "\nInterface number out of range.\n");
            pcap_freealldevs(alldevs);
            exit(1);
        }
    } else inum = 1;

    inum--;
    for(d = alldevs, i = 0; i < inum; d = d->next, i++);
    fprintf(stderr, "\n\nAdapter used: %s\n\n", d->name);
    fp = pcap_open_live(d->name, 65535, 1, 1000, errbuf);
    if(fp == NULL) {
        fprintf(stderr, "\nError: %s\n", errbuf);
        pcap_freealldevs(alldevs);
        exit(1);
    }

    if(pcap_datalink(fp) != DLT_EN10MB) {
        fprintf(stderr,"\nThis program works only on Ethernet networks.\n");
        pcap_freealldevs(alldevs);
        exit(1);
    }

    pcap_freealldevs(alldevs);

    pcap_loop(fp, 0, dispatcher_handler, NULL);

    return(0);
}



void dispatcher_handler(u_char *temp1, const struct pcap_pkthdr *header, const u_char *pkt_data) {
    time_t  datex;
    struct  tm      *tmx;
    struct  iphdr   *iphdr;
    struct  udphdr  *udphdr;
    u_char  *data;
    int     off,
            len;

    /* offset */
    /* this is very important, so if you have problems to get packets from your */
    /* interface you must modify the following switch */

    switch(htons(*(u_short *)(pkt_data + 12))) {
        case 0x8864: off = 22; break;   /* ADSL */
        /* case 0x0800: off = 14; break; */
        default: off = 14; break;
    }

    iphdr  = (struct iphdr *)(pkt_data + off);
    udphdr = (struct udphdr *)((u_char *)iphdr + sizeof(struct iphdr));
    data   = (u_char *)((u_char *)udphdr + sizeof(struct udphdr));

    if(iphdr->protocol != IPPROTO_UDP) return;
    if((udphdr->source != port) && (udphdr->dest != port)) return;
    if(*data != ';') return;

    time(&datex);
    tmx = localtime(&datex);
    printf("%02d:%02d:%02d   %s:%hu -> %s:%hu\n",
        tmx->tm_hour, tmx->tm_min, tmx->tm_sec,
        inet_ntoa(*(struct in_addr *)&iphdr->saddr),
        htons(udphdr->source),
        inet_ntoa(*(struct in_addr *)&iphdr->daddr),
        htons(udphdr->dest));

    len = htons(udphdr->len) - sizeof(struct udphdr);
    gamespyxor(data, len);
    data[len] = 0;
    printf("  %s\n", data);
}



void gamespyxor(u_char *string, int len) {
    u_char  gamespy[] = "gamespy",
            *gs;
    for(gs = gamespy; len; len--, gs++, string++) {
        if(!*gs) gs = gamespy;
        *string ^= *gs;
    }
}



u_int resolv(char *host) {
    struct  hostent *hp;
    u_int  host_ip;

    WSADATA wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u_int *)(hp->h_addr);
    }
    return(host_ip);
}


