/*

    Copyright 2004,2005,2006 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl.txt

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netdb.h>
#endif



#define VER         "0.4"
#define BUFFSZ      2048
#define TIMEOUT     3
#define QTYPE2      "\xfe\xfd\x00\xDE\xAD\xC0\xDE\xff\xff\xff"



u_short in_cksum(u_short *addr, int len);
void show(u_char *buff, int size, u_char del, u_char nt);
int timeout(int sock);
u_int resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    u_char  *buff,
            *ptr,
            *info[] = {
                "\\basic\\",
                "\\info\\",
                "\\rules\\",
                "\\status\\",
                "\\players\\",
                "\\level_property\\",
                "\\game_property\\",
                "\\player_property\\",
                "\\game_property\\",
                "\\teams\\",
                "\\secure\\ABCDEF"
            },
            type = 0;
    u_short *cksum;
    struct  sockaddr_in peer;
    int     sd,
            len,
            cksumlen,
            rlen,
            i,
            x,
            infonum;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif


    setbuf(stdout, NULL);

    fputs("\n"
        "GSInfo (Gamepsy querying protocol) "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <server> <port> [type]\n"
            "\n"
            "Type:\n"
            "0 = common old query (as \\status\\)   (DEFAULT)\n"
            "1 = new query        (as FE_FD_00_01_02_03_04_FF_FF_FF)\n"
            "\n", argv[0]);
        exit(1);
    }

    if(argc > 3) type = argv[3][0] & 1;

    peer.sin_addr.s_addr = resolv(argv[1]);
    peer.sin_port        = htons(atoi(argv[2]));
    peer.sin_family      = AF_INET;
    rlen                 = sizeof(peer);

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    buff = malloc(BUFFSZ + 1);
    if(!buff) std_err();

    if(!type) {
        infonum = sizeof(info) / sizeof(u_char *);

        cksum = calloc(infonum, sizeof(short));
        if(!cksum) std_err();

        fputs("\nRequests:\n", stdout);
        for(i = 0; i < infonum; i++) {
            printf("    %s\n", info[i]);
            if(sendto(sd, info[i], strlen(info[i]), 0, (struct sockaddr *)&peer, rlen)
              < 0) std_err();
            sleep(0);   // needed
        }

        printf("\nWaiting %d seconds for replies\n", TIMEOUT);

        for(i = 0; i < infonum; i++) {
            if(timeout(sd) < 0) {
                if(!i) fputs("\nAll the requests timed out\n", stdout);
                    else fputs("\nReplies finished\n", stdout);
                break;
            }
            len = recvfrom(sd, buff, BUFFSZ, 0, (struct sockaddr *)&peer, &rlen);
            if(len < 0) std_err();
            buff[len] = 0;

                /* some games provide the same informations, so we skip the visualization */
                /* if the 16bit checksum of the packets is the same */

            ptr = strstr(buff, "\\queryid\\");
            if(ptr) {
                cksumlen = ptr - buff;
            } else {
                cksumlen = len;
            }

            cksum[i] = in_cksum((u_short *)buff, cksumlen);
            for(x = 0; x < i; x++) {
                if(cksum[i] != cksum[x]) continue;
                fputc('.', stdout);
                x = -1;
                break;
            }
            if(x < 0) continue;

            show(buff, len, '\\', 1);
        }
    } else {
        if(sendto(sd, QTYPE2, sizeof(QTYPE2) - 1, 0, (struct sockaddr *)&peer, rlen)
          < 0) std_err();
        printf("\nWaiting %d seconds for a reply\n", TIMEOUT);
        if(timeout(sd) < 0) {
            fputs("\nError: timeout\n", stdout);
        } else {
            len = recvfrom(sd, buff, BUFFSZ, 0, (struct sockaddr *)&peer, &rlen);
            if(len < 0) std_err();
            show(buff + 5, len - 5, 0, 0);
        }
    }

    close(sd);
    fputc('\n', stdout);
    return(0);
}



u_short in_cksum(u_short *addr, int len) {
    u_int  sum = 0;

    while(len > 1)  {
        sum += *addr++;
        len--;
        len--;
    }
    if(len) sum += *(u_char *)addr;
    sum = (sum >> 16) + (sum & 0xffff);
    sum += (sum >> 16);
    sum &= 0xffff;
    return(~sum);
}



void show(u_char *buff, int size, u_char del, u_char nt) {
    u_char  *string,
            *end;

    end = buff + size;
    while(buff < end) {
        string = strchr(buff, del);
        if(!string) break;
        *string = 0;

            /* \n or \t */
        if(!nt) {
            printf("%35s: ", buff);
            nt++;
        } else {
            printf("%s\n", buff);
            nt = 0;
        }
        buff = string + 1;
    }
    printf("%s\n", buff);
}



int timeout(int sock) {
    struct  timeval tout;
    fd_set  fd_read;
    int     err;

    tout.tv_sec = TIMEOUT;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    err = select(sock + 1, &fd_read, NULL, NULL, &tout);
    if(err < 0) std_err();
    if(!err) return(-1);
    return(0);
}



u_int resolv(char *host) {
    struct  hostent *hp;
    u_int  host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u_int *)(hp->h_addr);
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif

