/*

GS key challenge builder 0.1
by Luigi Auriemma
e-mail: aluigi@autistici.org
web:    aluigi.org


INTRODUCTION
============
This file is a practical example of the first part of the document
available here:

  http://aluigi.org/papers/gskey-auth.txt

It can be used to create the challenge responses to send to the game
servers when they request the cd-key authorization.


HOW TO USE
==========
The function requires 3 arguments:
- the cdkey
- the server token
- the client token, if this value is zero it will be randomly generated
  by the function. Is better if this number is a positive integer so
  minor/equal than 2147483647.

Usage example:

 #include "gskeychall.h"

  printf("%s\n", gskeychall("1111-2222-3333-4444", "aBcDeFg", 0);
  printf("%s\n", gskeychall("1111-2222-3333-4444", "aBcDeFg", 0x12345678));


LICENSE
=======
    Copyright 2004,2005,2006 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl.txt

*/

#include <time.h>
#include <malloc.h>
#include <string.h>
#include "md5.h"


char *gskeychall(char *cdkey, char *stoken, int ctoken) {
    static char     chall[73];
    char            *tmp;
    unsigned char   md5h[16],
                    *ptr;
    const char      *hex = "0123456789abcdef";
    md5_context     md5t;
    int             i,
                    tmplen;

    #define DOMD5(x,y) \
                    md5_starts(&md5t); \
                    md5_update(&md5t, x, y); \
                    md5_finish(&md5t, md5h);


    if(!ctoken) {
        srand(time(NULL));
        ctoken = (rand() << 16) ^ rand();
    }
    ctoken = abs(ctoken);   // needed, positive integer

        /* 1) CDKEY HASH */
    DOMD5(cdkey, strlen(cdkey));
    for(ptr = chall, i = 0; i < 16; i++) {
        *ptr++ = hex[md5h[i] >> 4];
        *ptr++ = hex[md5h[i] & 0xf];
    }

        /* 2) CLIENT TOKEN */
    sprintf(
        ptr,
        "%.8x",
        ctoken);

        /* 3) THIRD STRING */
    tmplen = strlen(cdkey) + 5 + strlen(stoken);
    tmp = alloca(tmplen + 1);   // auto-free
    if(!tmp) return("");

    i = sprintf(
        tmp,
        "%s%d%s",
        cdkey,
        ctoken % 0xffff,
        stoken);
    DOMD5(tmp, i);
    for(ptr += 8, i = 0; i < 16; i++) {
        *ptr++ = hex[md5h[i] >> 4];
        *ptr++ = hex[md5h[i] & 0xf];
    }

    *ptr = 0;
    return(chall);
}

