/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef WIN32
    #include <direct.h>

    #define u_int  unsigned int
    #define u_char  unsigned char
#else
    #include <unistd.h>
    #include <sys/stat.h>
#endif



#define VER         "0.2"
#define BUFFSZ      32768
#define NAMESZ      512



void getfile(FILE *fdin, u_char *fname, u_int size);
void std_err(void);
void io_err(void);



int main(int argc, char *argv[]) {
    struct {
        u_int  dunno;
        u_int  size;
        u_int  offset;
    } fileoff;

    FILE    *fdname,
            *fdoff,
            *fd;
    u_int  nameoff,
            offoff,
            numfiles;
    u_char  fname[NAMESZ + 1],
            *p;


    setbuf(stdout, NULL);

    fputs("\n"
        "Halo PC music extractor and concatenator "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <sounds.map> <output_directory>\n"
            "\n"
            " All the Halo songs are divided in some pieces to allow dynamic music.\n"
            " This tool concatenates all these pieces in sequential order but naturally\n"
            " some RARE songs could sound a bit strange or \"loopy\" (exists this word?) due\n"
            " to the dynamic content. Any flaw in the songs (like some pops) is caused by\n"
            " the original files, this is only an extractor and concatenator, nothing more.\n"
            "\n"
            " Usage example:   halomus c:\\halo\\maps\\sounds.map c:\\halo-music\n"
            "\n", argv[0]);
        exit(1);
    }

    printf("- open input file \"%s\"\n", argv[1]);
    fd = fopen(argv[1], "rb");
    if(!fd) std_err();

    fdname = fopen(argv[1], "rb");
    if(!fdname) std_err();

    fdoff = fopen(argv[1], "rb");
    if(!fdoff) std_err();

    printf("- enter in directory \"%s\": ", argv[2]);
    if(chdir(argv[2]) < 0) std_err();
    fputs("ok\n", stdout);

    fseek(fd, 4, SEEK_SET);
    fread((void *)&nameoff, 4, 1, fd);
    fseek(fdname, nameoff, SEEK_SET);

    fread((void *)&offoff, 4, 1, fd);
    fseek(fdoff, offoff, SEEK_SET);

    fread((void *)&numfiles, 4, 1, fd);

    while(numfiles--) {
        p = fname;
        while((*p++ = fgetc(fdname)));

        fread((void *)&fileoff, 12, 1, fdoff);

        if(
          !strstr(fname, "\\music\\") &&
          !strstr(fname, "\\sinomatixx\\") &&
          !strstr(fname, "\\sinomatixx_music\\")
        ) continue;

        if(strstr(fname, "foley")) continue;

        printf("\n"
            "File:       %s\n"
            "Offset:     %08x   Size: %u\n",
            fname, fileoff.offset, fileoff.size);

        fseek(fd, fileoff.offset, SEEK_SET);

        getfile(fd, fname, fileoff.size);
    }

    fclose(fd);
    fclose(fdname);
    fclose(fdoff);
    fputs("\nFinished\n\n", stdout);
    return(0);
}



void getfile(FILE *fdin, u_char *fname, u_int size) {
    FILE            *fdout;
    int             len;
    static  u_char  buff[BUFFSZ];
    u_char          *p;

    p = strchr(fname, '\\');
    if(p) {
        fname = p + 1;
        p = strchr(fname, '\\');
        if(p) fname = p + 1;
    }

    p = strchr(fname, '\\');
    if(!p) p = strstr(fname, "__");
    if(p) *p = 0;

    strcat(fname, ".ogg");

    printf("Append:     %s\n", fname);

    fdout = fopen(fname, "ab");
    if(!fdout) std_err();

    for(len = BUFFSZ; size; size -= len) {
        if(size < len) len = size;

        if(fread(buff, len, 1, fdin) != 1) io_err();
        if(fwrite(buff, len, 1, fdout) != 1) io_err();
    }

    fclose(fdout);
}



void std_err(void) {
    perror("\nError");
    exit(1);
}



void io_err(void) {
    fputs("\nError: I/O error, the file is incomplete or the disk space is finished\n", stdout);
    exit(1);
}



