/*

by Luigi Auriemma

Linux version

This software is covered by GNU/GPL
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <netdb.h>
#include <netinet/ip.h>
#include <netinet/udp.h>
#include <net/if_arp.h>
#include <net/if.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <linux/if_ether.h>
#include "ether_hdrlen.h"
#include "show_dump.h"
#include "hldec.h"



#define VER         "0.1.3"
#define SNIFFSZ     65535




u_int resolv(char *host);
void std_err(void);





unsigned char   dropff = 1;
unsigned int   sniffhost = 0;




int main(int argc, char *argv[]) {
    u_char  packet[SNIFFSZ],
            *data;
    int     sd,
            off,
            i,
            len,
            port = 0;
    struct  iphdr   *ip;
    struct  udphdr  *udp;
    struct  ifreq   ifr;


    setbuf(stdout, NULL);

    fputs("\n"
        "Half-Life packets decoder sniffer "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\nUsage: %s [options] <interface>\n"
            "\nOptions:\n"
            "-p PORT    gets only the packets with this source/dest port (useful)\n"
            "-i HOST    sniff only from a specific host\n"
            "-f         DOESN'T drop the packets that start with 0xffffffff\n"
            "\n", argv[0]);
        exit(1);
    }

    argc--;
    for(i = 1; i < argc; i++) {
        switch(argv[i][1]) {
            case 'p': port = htons(atoi(argv[++i])); break;
            case 'i': sniffhost = resolv(argv[++i]); break;
            case 'f': dropff = 0; break;
            default: {
                printf("\nError: Wrong argument (%s)\n", argv[i]);
                exit(1);
                } break;
        }
    }

    memset(&ifr, 0, sizeof(struct ifreq));

    sd = socket(PF_PACKET, SOCK_RAW, htons(ETH_P_ALL));
    if(sd < 0) std_err();
    strncpy(ifr.ifr_name, argv[argc], sizeof(ifr.ifr_name));
    if(ioctl(sd, SIOCGIFHWADDR, &ifr)
      < 0) std_err();

    off = 14 + ether_hdrlen(ifr.ifr_hwaddr.sa_family);

    ip   = (struct iphdr *)(packet + off);
    udp  = (struct udphdr *)((u_char *)ip + sizeof(struct iphdr));
    data = (u_char *)((u_char *)udp + sizeof(struct udphdr));

    while(1) {
        if(read(sd, packet, SNIFFSZ) < 0) std_err();

        if(sniffhost) {
            if((ip->saddr != sniffhost) && (ip->daddr != sniffhost)) continue;
        }

        if(ip->protocol != IPPROTO_UDP) continue;

        if(dropff) {
            if(!memcmp(data + 1, "\xff\xff\xff", 3)) continue;
        }
        if(port) {
            if((udp->source != port) && (udp->dest != port)) continue;
        }

        len = htons(udp->len) - sizeof(struct udphdr);
        hldec(data, len);

        printf("\n%s:%u --> ",
            inet_ntoa(*(struct in_addr *)&ip->saddr),
            htons(udp->source));
        printf("%s:%u\n",
            inet_ntoa(*(struct in_addr *)&ip->daddr),
            htons(udp->dest));

        show_dump(data, len, stdout);
    }

    close(sd);
    return(0);
}




u_int resolv(char *host) {
    struct  hostent *hp;
    u_int  host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolve hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u_int *)(hp->h_addr);
    }

    return(host_ip);
}




void std_err(void) {
    perror("\nError");
    exit(1);
}



