/*
    Copyright 2007,2008 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl-2.0.txt
*/

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <time.h>



typedef uint8_t     u8;
typedef uint16_t    u16;
typedef int32_t     i32;
typedef uint32_t    u32;



#define _ANONYMOUS_UNION __extension__
#define _ANONYMOUS_STRUCT __extension__

#define IMAGE_DOS_SIGNATURE                 0x5A4D
#define IMAGE_OS2_SIGNATURE                 0x454E
#define IMAGE_OS2_SIGNATURE_LE              0x454C
#define IMAGE_VXD_SIGNATURE                 0x454C
#define IMAGE_NT_SIGNATURE                  0x00004550
#define IMAGE_NT_OPTIONAL_HDR32_MAGIC       0x10b
#define IMAGE_NT_OPTIONAL_HDR64_MAGIC       0x20b
#define IMAGE_NT_OPTIONAL_HDR_MAGIC         IMAGE_NT_OPTIONAL_HDR32_MAGIC
#define IMAGE_ROM_OPTIONAL_HDR_MAGIC        0x107
#define IMAGE_SEPARATE_DEBUG_SIGNATURE      0x4944
#define IMAGE_NUMBEROF_DIRECTORY_ENTRIES    16
#define IMAGE_SIZEOF_ROM_OPTIONAL_HEADER    56
#define IMAGE_SIZEOF_STD_OPTIONAL_HEADER    28
#define IMAGE_SIZEOF_NT_OPTIONAL_HEADER     224
#define IMAGE_SIZEOF_SHORT_NAME             8
#define IMAGE_SIZEOF_SECTION_HEADER         40
#define IMAGE_SIZEOF_SYMBOL                 18
#define IMAGE_SIZEOF_AUX_SYMBOL             18
#define IMAGE_SIZEOF_RELOCATION             10
#define IMAGE_SIZEOF_BASE_RELOCATION        8
#define IMAGE_SIZEOF_LINENUMBER             6
#define IMAGE_SIZEOF_ARCHIVE_MEMBER_HDR     60

#define IMAGE_FILE_MACHINE_I386             0x014c

#define IMAGE_FILE_RELOCS_STRIPPED          1
#define IMAGE_FILE_EXECUTABLE_IMAGE         2
#define IMAGE_FILE_LINE_NUMS_STRIPPED       4
#define IMAGE_FILE_LOCAL_SYMS_STRIPPED      8
#define IMAGE_FILE_AGGRESIVE_WS_TRIM        16
#define IMAGE_FILE_LARGE_ADDRESS_AWARE      32
#define IMAGE_FILE_BYTES_REVERSED_LO        128
#define IMAGE_FILE_32BIT_MACHINE            256
#define IMAGE_FILE_DEBUG_STRIPPED           512
#define IMAGE_FILE_REMOVABLE_RUN_FROM_SWAP  1024
#define IMAGE_FILE_NET_RUN_FROM_SWAP        2048
#define IMAGE_FILE_SYSTEM                   4096
#define IMAGE_FILE_DLL                      8192
#define IMAGE_FILE_UP_SYSTEM_ONLY           16384
#define IMAGE_FILE_BYTES_REVERSED_HI        32768

#define IMAGE_SUBSYSTEM_UNKNOWN             0
#define IMAGE_SUBSYSTEM_NATIVE              1
#define IMAGE_SUBSYSTEM_WINDOWS_GUI         2
#define IMAGE_SUBSYSTEM_WINDOWS_CUI         3
#define IMAGE_SUBSYSTEM_OS2_CUI             5
#define IMAGE_SUBSYSTEM_POSIX_CUI           7
#define IMAGE_SUBSYSTEM_NATIVE_WINDOWS      8
#define IMAGE_SUBSYSTEM_WINDOWS_CE_GUI      9
#define IMAGE_SUBSYSTEM_XBOX                14

#define IMAGE_SCN_CNT_CODE                  32
#define IMAGE_SCN_CNT_INITIALIZED_DATA      64
#define IMAGE_SCN_CNT_UNINITIALIZED_DATA    128
#define IMAGE_SCN_LNK_OTHER                 256
#define IMAGE_SCN_LNK_INFO                  512
#define IMAGE_SCN_TYPE_OVER                 1024
#define IMAGE_SCN_LNK_REMOVE                2048
#define IMAGE_SCN_LNK_COMDAT                4096
#define IMAGE_SCN_MEM_DISCARDABLE           0x2000000
#define IMAGE_SCN_MEM_NOT_CACHED            0x4000000
#define IMAGE_SCN_MEM_NOT_PAGED             0x8000000
#define IMAGE_SCN_MEM_SHARED                0x10000000
#define IMAGE_SCN_MEM_EXECUTE               0x20000000
#define IMAGE_SCN_MEM_READ                  0x40000000
#define IMAGE_SCN_MEM_WRITE                 0x80000000



typedef struct {
    u16     e_magic;
    u16     e_cblp;
    u16     e_cp;
    u16     e_crlc;
    u16     e_cparhdr;
    u16     e_minalloc;
    u16     e_maxalloc;
    u16     e_ss;
    u16     e_sp;
    u16     e_csum;
    u16     e_ip;
    u16     e_cs;
    u16     e_lfarlc;
    u16     e_ovno;
    u16     e_res[4];
    u16     e_oemid;
    u16     e_oeminfo;
    u16     e_res2[10];
    i32     e_lfanew;
} IMAGE_DOS;

typedef struct {
    u16     Machine;
    u16     NumberOfSections;
    u32     TimeDateStamp;
    u32     PointerToSymbolTable;
    u32     NumberOfSymbols;
    u16     SizeOfOptionalHeader;
    u16     Characteristics;
} IMAGE_FILE;

typedef struct {
    u32     VirtualAddress;
    u32     Size;
} IMAGE_DATA_DIRECTORY;

typedef struct {
    u16     Magic;
    u8      MajorLinkerVersion;
    u8      MinorLinkerVersion;
    u32     SizeOfCode;
    u32     SizeOfInitializedData;
    u32     SizeOfUninitializedData;
    u32     AddressOfEntryPoint;
    u32     BaseOfCode;
    u32     BaseOfData;
    u32     ImageBase;
    u32     SectionAlignment;
    u32     FileAlignment;
    u16     MajorOperatingSystemVersion;
    u16     MinorOperatingSystemVersion;
    u16     MajorImageVersion;
    u16     MinorImageVersion;
    u16     MajorSubsystemVersion;
    u16     MinorSubsystemVersion;
    u32     Win32VersionValue;
    u32     SizeOfImage;
    u32     SizeOfHeaders;
    u32     CheckSum;
    u16     Subsystem;
    u16     DllCharacteristics;
    u32     SizeOfStackReserve;
    u32     SizeOfStackCommit;
    u32     SizeOfHeapReserve;
    u32     SizeOfHeapCommit;
    u32     LoaderFlags;
    u32     NumberOfRvaAndSizes;
    IMAGE_DATA_DIRECTORY DataDirectory[IMAGE_NUMBEROF_DIRECTORY_ENTRIES];
} IMAGE_OPTIONAL;

typedef struct {
    _ANONYMOUS_UNION union {
        u32     Characteristics;
        u32     OriginalFirstThunk;
    } DUMMYUNIONNAME;
    u32     TimeDateStamp;
    u32     ForwarderChain;
    u32     Name;
    u32     FirstThunk;
} IMAGE_IMPORT_DESCRIPTOR;

#define IMAGE_ORDINAL_FLAG32 0x80000000

typedef struct {
    union {
        u32     ForwarderString;
        u32     Function;
        u32     Ordinal;
        u32     AddressOfData;
    } u1;
} IMAGE_THUNK_DATA;

typedef struct {
    u32     Characteristics;
    u32     TimeDateStamp;
    u16     MajorVersion;
    u16     MinorVersion;
    u32     Name;
    u32     Base;
    u32     NumberOfFunctions;
    u32     NumberOfNames;
    u32     AddressOfFunctions;
    u32     AddressOfNames;
    u32     AddressOfNameOrdinals;
} IMAGE_EXPORT_DIRECTORY;

#define PE_DIR_ExportTable  DataDirectory[0]
#define PE_DIR_ImportTable  DataDirectory[1]
#define PE_DIR_Resource     DataDirectory[2]
#define PE_DIR_Exception    DataDirectory[3]
#define PE_DIR_Security     DataDirectory[4]
#define PE_DIR_Relocation   DataDirectory[5]
#define PE_DIR_Debug        DataDirectory[6]
#define PE_DIR_Copyright    DataDirectory[7]
#define PE_DIR_GlobalPtr    DataDirectory[8]
#define PE_DIR_TLSTable     DataDirectory[9]
#define PE_DIR_LoadConfig   DataDirectory[10]
#define PE_DIR_BoundImport  DataDirectory[11]
#define PE_DIR_IAT          DataDirectory[12]
#define PE_DIR_DelayImport  DataDirectory[13]
#define PE_DIR_COM          DataDirectory[14]
#define PE_DIR_Reserved     DataDirectory[15]

typedef struct {
    u8      Name[IMAGE_SIZEOF_SHORT_NAME];
    union {
        u32     PhysicalAddress;
        u32     VirtualSize;
    } Misc;
    u32     VirtualAddress;
    u32     SizeOfRawData;
    u32     PointerToRawData;
    u32     PointerToRelocations;
    u32     PointerToLinenumbers;
    u16     NumberOfRelocations;
    u16     NumberOfLinenumbers;
    u32     Characteristics;
} IMAGE_SECTION_HEADER;



void PE_dos_fwrite(FILE *fd) {
    IMAGE_DOS   hdr;
    static const u8 dosdata[0x100] =
        "\x0e\x1f\xba\x0e\x00\xb4\x09\xcd\x21\xb8\x01\x4c\xcd\x21\x54\x68"
        "\x69\x73\x20\x70\x72\x6f\x67\x72\x61\x6d\x20\x63\x61\x6e\x6e\x6f"
        "\x74\x20\x62\x65\x20\x72\x75\x6e\x20\x69\x6e\x20\x44\x4f\x53\x20"
        "\x6d\x6f\x64\x65\x2e\x0d\x0d\x0a\x24\x00\x00\x00\x00\x00\x00\x00"
        "\xdb\xd6\xcc\x61\x9f\xb7\xa2\x32\x9f\xb7\xa2\x32\x9f\xb7\xa2\x32"
        "\xe4\xab\xae\x32\x97\xb7\xa2\x32\xf0\xa8\xa9\x32\x90\xb7\xa2\x32"
        "\x1c\xab\xac\x32\xae\xb7\xa2\x32\xf0\xa8\xa8\x32\x31\xb7\xa2\x32"
        "\xc0\x95\xa8\x32\x9e\xb7\xa2\x32\x65\x93\xbb\x32\x9d\xb7\xa2\x32"
        "\xc0\x95\xa9\x32\xb1\xb7\xa2\x32\x18\xab\xa0\x32\xb9\xb7\xa2\x32"
        "\x70\x95\x92\x32\x9e\xb7\xa2\x32\x9f\xb7\xa3\x32\x6c\xb7\xa2\x32"
        "\xfd\xa8\xb1\x32\x8e\xb7\xa2\x32\xe1\x95\xbe\x32\x9c\xb7\xa2\x32"
        "\xac\x95\x87\x32\x9b\xb7\xa2\x32\xcb\x94\x93\x32\xab\xb7\xa2\x32"
        "\xcb\x94\x92\x32\xf2\xb7\xa2\x32\x58\xb1\xa4\x32\x9e\xb7\xa2\x32"
        "\x9f\xb7\xa2\x32\x80\xb7\xa2\x32\x60\x97\xa6\x32\x8c\xb7\xa2\x32"
        "\x52\x69\x63\x68\x9f\xb7\xa2\x32\x00\x00\x00\x00\x00\x00\x00\x00"
        "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";

    memset(&hdr, 0, sizeof(hdr));
    hdr.e_magic     = IMAGE_DOS_SIGNATURE;
    hdr.e_cblp      = 0x0090;
    hdr.e_cp        = 0x0003;
    hdr.e_cparhdr   = 0x0004;
    hdr.e_maxalloc  = 0xffff;
    hdr.e_sp        = 0x00b8;
    hdr.e_lfarlc    = 0x0040;
    hdr.e_lfanew    = sizeof(hdr) + sizeof(dosdata);
    fwrite(&hdr,     sizeof(hdr),     1, fd);
    fwrite(&dosdata, sizeof(dosdata), 1, fd);
}



void PE_sign_fwrite(FILE *fd) {
    u32         hdr;

    hdr = IMAGE_NT_SIGNATURE;
    fwrite(&hdr,     sizeof(hdr),     1, fd);
}



void PE_file_fwrite(FILE *fd, u32 sections, u32 Characteristics) {
    IMAGE_FILE  hdr;

    memset(&hdr, 0, sizeof(hdr));
    hdr.Machine                 = IMAGE_FILE_MACHINE_I386;
    hdr.NumberOfSections        = sections;
    hdr.TimeDateStamp           = time(NULL);
    hdr.SizeOfOptionalHeader    = sizeof(IMAGE_OPTIONAL);
    hdr.Characteristics         = Characteristics;
    fwrite(&hdr,     sizeof(hdr),     1, fd);
}


