/*

    Copyright 2004,2005,2006 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl.txt

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define    close    closesocket
    #define sleep   Sleep
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netdb.h>
#endif



#define VER     "0.1.6"
#define BUFFSZ  4096
#define PORT    27015
#define INFOS   "\xff\xff\xff\xff" \
                "infostring\n\0"
#define DETAILS "\xff\xff\xff\xff" \
                "details\n"
#define PLAYERS "\xff\xff\xff\xff" \
                "players"
#define RULES   "\xff\xff\xff\xff" \
                "rules"
#define CHALL   "\xff\xff\xff\xff"\
                "getchallenge\n"
#define RCON    "\xff\xff\xff\xff"\
                "challenge rcon\n"
#define TIMEOUT 5    //5 seconds



void showinfostring(unsigned char *buff, int size);
void showdetails(unsigned char *buff, int size);
void showrules(unsigned char *buff, int size);
void showplayers(unsigned char *buff, int size);
u_int resolv(char *host);
void timeout(int sock);
void std_err(void);
char *yesno(unsigned char byte);



int main(int argc, char *argv[]) {
    unsigned char   buff[BUFFSZ],
                    *server,
                    *ptrport;
    struct  sockaddr_in    peer;
    int     sd,
            err,
            recvlen,
            port = PORT;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(2,0), &wsadata);
#endif


    setbuf(stdout, NULL);

    fputs("\n"
        "Halflife GetInfo " VER "\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\nUsage: %s <host[:port]> [port(default %d)]\n"
            "\n", argv[0], PORT);
        exit(1);
    }

    server = argv[1];
    ptrport = strchr(server, ':');
    if(ptrport) {
        *ptrport = 0;
        port = atoi(ptrport + 1);
    }
    if(argc > 2) port = atoi(argv[2]);


    peer.sin_addr.s_addr = resolv(server);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;
    recvlen              = sizeof(peer);

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    /* GET INFORMATIONS */
    err = sendto(sd, INFOS, sizeof(INFOS) - 1, 0, (struct sockaddr *)&peer, recvlen);
    if(err < 0) std_err();
    timeout(sd);
    err = recvfrom(sd, buff, BUFFSZ, 0, (struct sockaddr *)&peer, &recvlen);
    if(err < 0) std_err();
    buff[err] = 0;
    showinfostring(buff, err);

    /* GET DETAILS (like INFO but with some more info) */
    err = sendto(sd, DETAILS, sizeof(DETAILS) - 1, 0, (struct sockaddr *)&peer, recvlen);
    if(err < 0) std_err();
    timeout(sd);
    err = recvfrom(sd, buff, BUFFSZ, 0, (struct sockaddr *)&peer, &recvlen);
    if(err < 0) std_err();
    buff[err] = 0;
    showdetails(buff, err);

    /* GET RULES */
    err = sendto(sd, RULES, sizeof(RULES) - 1, 0, (struct sockaddr *)&peer, recvlen);
    if(err < 0) std_err();
    timeout(sd);
    err = recvfrom(sd, buff, BUFFSZ, 0, (struct sockaddr *)&peer, &recvlen);
    if(err < 0) std_err();
    buff[err] = 0;
    showrules(buff, err);

    /* GET PLAYERS */
    err = sendto(sd, PLAYERS, sizeof(PLAYERS) - 1, 0, (struct sockaddr *)&peer, recvlen);
    if(err < 0) std_err();
    timeout(sd);
    err = recvfrom(sd, buff, BUFFSZ, 0, (struct sockaddr *)&peer, &recvlen);
    if(err < 0) std_err();
    buff[err] = 0;
    showplayers(buff, err);

    fputs("\n--------------------------------------------------\n", stdout);

    /* GET CHALL */
    err = sendto(sd, CHALL, sizeof(CHALL) - 1, 0, (struct sockaddr *)&peer, recvlen);
    if(err < 0) std_err();
    timeout(sd);
    err = recvfrom(sd, buff, BUFFSZ, 0, (struct sockaddr *)&peer, &recvlen);
    if(err < 0) std_err();
    buff[err] = 0;
    printf("Challenge: %s\n", buff + 4);

    /* GET RCON */
    err = sendto(sd, RCON, sizeof(RCON) - 1, 0, (struct sockaddr *)&peer, recvlen);
    if(err < 0) std_err();
    timeout(sd);
    err = recvfrom(sd, buff, BUFFSZ, 0, (struct sockaddr *)&peer, &recvlen);
    if(err < 0) std_err();
    buff[err] = 0;
    printf("Rcon:      %s\n", buff + 4);

    close(sd);
    fputc('\n', stdout);
    return(0);
}



void showinfostring(unsigned char *buff, int size) {
    int        nt = 1,
            len;
    unsigned char    *string;

    fputs("\n--------------------------------------------------\n", stdout);

/*
    if(*(int *)buff != -1) {
        printf("\nError: Bad answer from the server (it is not a true server)\n");
        exit(1);
    }
*/
    len = strlen(buff);
    if(len < size) buff += len + 1;

    while(1) {
        string = strchr(buff, '\\');
        if(!string) break;

        *string = 0;

        /* \n or \t */
        if(!nt) {
            printf("%s:   ", buff);
            nt++;
        } else {
            printf("%s\n", buff);
            nt = 0;
        }

        buff = string + 1;
    }

    printf("%s\n", buff);
}



void showdetails(unsigned char *buff, int size) {
    int    err;
    unsigned char    *ptr,
            *totptr;

    fputs("\n--------------------------------------------------\n", stdout);

/*
    if((*(int *)buff != -1) || (buff[4] != 'm')) {
        printf("\nError: Bad answer from the server (it is not a true server)\n");
        exit(1);
    }
*/

    if(buff[4] != 'm') {
        printf("\nError: Bad answer from the server (it is not a true server)\n");
        exit(1);
    }

    totptr = buff + size;
    buff += 5;
    if(buff >= totptr) return;

    err = printf("Server address:     %s\n", buff);
    buff += err - 20;
    if(buff >= totptr) return;
    err = printf("Server name:        %s\n", buff);
    buff += err - 20;
    if(buff >= totptr) return;
    err = printf("Map name:           %s\n", buff);
    buff += err - 20;
    if(buff >= totptr) return;
    err = printf("Game directory:     %s\n", buff);
    buff += err - 20;
    if(buff >= totptr) return;
    err = printf("Game desctiption:   %s\n", buff);
    buff += err - 20;
    if(buff >= totptr) return;
    printf("Active clients:     %d\n", *buff);
    buff++;
    if(buff >= totptr) return;
    printf("Max clients:        %d\n", *buff);
    buff++;
    if(buff >= totptr) return;
    printf("Protocol version:   %d\n", *buff);
    buff++;
    if(buff >= totptr) return;

    switch(*buff) {
        case 'l': ptr = "listen"; break;
        case 'd': ptr = "dedicated"; break;
        default: ptr = "unknown"; break;
    }
    printf("Type of server:     %s\n", ptr);
    buff++;
    if(buff >= totptr) return;

    switch(*buff) {
        case 'w': ptr = "Windows"; break;
        case 'l': ptr = "Linux"; break;
        default: ptr = "unknown"; break;
    }
    printf("Server OS:          %s\n", ptr);
    buff++;
    if(buff >= totptr) return;

    printf("Password protect:   %s\n", yesno(*buff));
    buff++;
    if(buff >= totptr) return;
    printf("MOD running:        %s\n", yesno(*buff));
    buff++;
    if(buff >= totptr) return;
    if(*buff) {
        err = printf("MOD info URL:       %s\n", buff);
        buff += err - 20;
        if(buff >= totptr) return;
        err = printf("MOD download URL:   %s\n", buff);
        buff += err - 20;
        if(buff >= totptr) return;
        err = printf("Empty string:       %s\n", buff);
        buff += err - 20;
        if(buff >= totptr) return;
        printf("MOD version:        %u\n", *(u_int *)buff);
        buff += 4;
        if(buff >= totptr) return;
        printf("MOD size:           %u\n", *(u_int *)buff);
        buff += 4;
        if(buff >= totptr) return;
        printf("MOD server side:    %s\n", yesno(*buff));
        buff++;
        if(buff >= totptr) return;
        printf("Client dll needed:  %s\n", yesno(*buff));
        buff++;
        if(buff >= totptr) return;
    }
    printf("Secure server:      %s\n", yesno(*buff));
}



void showrules(unsigned char *buff, int size) {
    int        rcount,
            len,
            i;
    unsigned char    *totptr;

    fputs("\n--------------------------------------------------\n", stdout);

/*
    if((*(int *)buff != -1) || (buff[4] != 'E')) {
        printf("\nError: Bad answer from the server (it is not a true server)\n");
        exit(1);
    }
*/

    if(buff[4] != 'E') {
        printf("\nError: Bad answer from the server (it is not a true server)\n");
        exit(1);
    }

    totptr = buff + size;
    buff += 5;
    if(buff >= totptr) return;
    rcount = *(u_short *)buff;
    buff += 2;
    if(buff >= totptr) return;

    for(i = 0; i < rcount; i++) {
        len = printf("%s: ", buff);
        buff += len - 1;
        if(buff >= totptr) return;

        len = printf("%s\n", buff);
        buff += len;
        if(buff >= totptr) return;
    }
}



void showplayers(unsigned char *buff, int size) {
    int        ccount,
            i,
            err;
    unsigned char    *totptr;

    fputs("\n--------------------------------------------------\n", stdout);

/*
    if((*(int *)buff != -1) || (buff[4] != 'D')) {
        printf("\nError: Bad answer from the server (it is not a true server)\n");
        exit(1);
    }
*/

    if(buff[4] != 'D') {
        printf("\nError: Bad answer from the server (it is not a true server)\n");
        exit(1);
    }

    totptr = buff + size;
    buff += 5;
    if(buff >= totptr) return;
    ccount = *buff;
    printf("Active clients:     %d\n", ccount);
    buff++;
    if(buff >= totptr) return;

    for(i = 0; i < ccount; i++) {
        printf("Client number:      %d\n", *buff);
        buff++;
        if(buff >= totptr) return;
        err = printf("Player name:        %s\n", buff);
        buff += err - 20;   /* 20 - 1 */
        if(buff >= totptr) return;
        printf("Frags:              %d\n", *(int *)buff);
        buff += 4;
        if(buff >= totptr) return;
        printf("Total time in game: %f\n", *(float *)buff);
        buff += 4;
        if(buff >= totptr) return;
    }
}



unsigned int resolv(char *host) {
    struct  hostent *hp;
    unsigned int   host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u_int *)(hp->h_addr);
    }
    return(host_ip);
}



void timeout(int sock) {
    struct    timeval    tout;
    fd_set    fd_read;
    int    err;

    tout.tv_sec = TIMEOUT;
    tout.tv_usec = 0;

    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    err = select(sock + 1, &fd_read, NULL, NULL, &tout);
    if(err < 0) std_err();
    if(!err) {
        fputs("\nError: Socket timeout, no answers received\n", stdout);
        exit(1);
    }
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif



char *yesno(unsigned char byte) {
    if(byte) return("true");
        else return("false");
}



