/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>



#define VER "0.1"



int main(int argc, char *argv[]) {
    unsigned char   cdkey[14],
                    *ptr,
                    *ptr1;
    unsigned int   eax,
                    edx,
                    edi,
                    i,
                    slen;


    setbuf(stdout, NULL);

    fputs("\n"
        "CD-Key checker for Half-Life "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\nUsage: %s <Half-Life_CD-Key>\n"
            "\n", argv[0]);
        exit(1);
    }


    slen = strlen(argv[1]);
    ptr = argv[1];
    ptr1 = cdkey;
    for(eax = 0, i = 0; i < slen; i++, ptr++) {
        if(*ptr == '-') continue;
        *ptr1 = *ptr;
        ptr1++;
        eax++;
        if(eax == 0xe) {
            fputs("\nError: CD-Key must be 13 chars long (yours is major)\n", stdout);
            exit(1);
        }
    }
    if(eax < 0xd) {
        fputs("\nError: CD-Key must be 13 chars long (yours is minor)\n", stdout);
        exit(1);
    }
    *ptr1 = 0;


    eax = 3;
    ptr = cdkey;
    for(i = 0; i < 0xc; i++, ptr++) {
        edi = eax << 1;
        edx = *ptr - 0x30;
        edx ^= edi;
        eax += edx;
    }
    eax %= 0xa;
    eax -= *ptr;
    if(eax == 0xFFFFFFD0) fputs("\nCD-Key is OK!\n", stdout);
        else fputs("\nCD-Key is invalid\n", stdout);


    return(0);
}


