/*

    Copyright 2004,2005,2006 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl.txt

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netdb.h>
#endif



#define VER     "0.2"
#define BUFFSZ  2048
#define PORT    27960
#define TIMEOUT 5



char *info[] = {
    "\xff\xff\xff\xff" "getinfo xxx\n",
    "\xff\xff\xff\xff" "getstatus\n",
    "\xff\xff\xff\xff" "getchallenge\n",
    "\xff\xff\xff\xff" "rcon\n"
//    "\xff\xff\xff\xff" "pb_plist\n"
//    "\xff\xff\xff\xff" "ipAuthorize\n"
//    "what you want, remember the comma"
};



void show(u_char *buff, int size);
int timeout(int sock);
u_int resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    u_char  *buff;
    u_short port = PORT;
    struct  sockaddr_in    peer;
    int     sd,
            err,
            i,
            num,
            psz;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif


    setbuf(stdout, NULL);

    fputs("\n"
        "ID Software GETINFO "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\nUsage: %s <host> [port(%d)]\n", argv[0], PORT);
        exit(1);
    }

    if(argc > 2) port = atoi(argv[2]);

    peer.sin_addr.s_addr = resolv(argv[1]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;
    psz                  = sizeof(peer);

    buff = malloc(BUFFSZ + 1);
    if(!buff) std_err();

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    num = sizeof(info) / sizeof(char *);
    for(i = 0; i < num; i++) {
        printf("\n"
            "--------------------------------------------------\n"
            "\t\t%s\n", info[i]);
        if(sendto(sd, info[i], strlen(info[i]), 0, (struct sockaddr *)&peer, psz)
          < 0) std_err();
        if(timeout(sd) < 0) {
            printf("\nError: Socket timeout, no answers received\n");
            continue;
        }
        err = recvfrom(sd, buff, BUFFSZ, 0, (struct sockaddr *)&peer, &psz);
        if(err < 0) std_err();
        show(buff, err);
    }

    close(sd);

    return(0);
}



void show(u_char *buff, int size) {
    int     nt = 1,
            gametype = 0;
    u_char  *string;

    buff[size] = 0;
    buff += 4;
    while(1) {
        string = strchr(buff, '\\');
        if(!string) break;
        *string = 0;

            /* gametype */
        if(gametype) {
            switch(*buff) {
                case '0': printf("Free for All\n"); break;
                case '1': printf("Tournament\n"); break;
                case '3': printf("Team Deathmatch\n"); break;
                case '4': printf("Capture the flag\n"); break;
                default: printf("Type unknown\n"); break;
            }
            buff = string + 1;
            gametype = nt = 0;
            continue;
        }

            /* \n or \t */
        if(!nt) {
            printf("%20s: ", buff);
            nt++;
        } else {
            printf("%s\n", buff);
            nt = 0;
        }

            /* gametype */
        if(strstr(buff, "gametype")) gametype = 1;
        buff = string + 1;
    }
    printf("%s\n", buff);
}



int timeout(int sock) {
    struct  timeval tout;
    fd_set  fd_read;
    int     err;

    tout.tv_sec = TIMEOUT;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    err = select(sock + 1, &fd_read, NULL, NULL, &tout);
    if(err < 0) std_err();
    if(!err) return(-1);
    return(0);
}



u_int resolv(char *host) {
    struct  hostent *hp;
    u_int  host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u_int *)(hp->h_addr);
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif

