/*
    Copyright 2006,2007,2008,2009 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl-2.0.txt
*/

#define	_STDIO_H_   //#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <windows.h>
#include <msacm.h>
#include "wa_ipc.h"
#include "in2.h"
#include "stdio2win.h"
#include "mywav.h"
#include "uXboxAdpcmDecoder.h"



#define VER             "0.1.3"
#define PLUGIN_NAME     "Xbox ADPCM plugin"
#define MIN_SAMPLE_WA   16      // blah, winamp crashes when using too small buffers, the rule of the 576 samples I think
#define SAMPLESIZE(x)   (x * NCH)
#define GETLENGTH(x)    (((x * 10) / ((SAMPLERATE / 100) * NCH * (BPS >> 3)) / XBOX_ADPCM_SRCSIZE) * XBOX_ADPCM_DSTSIZE)
#define BPS             16
#define XWBSIGN         "WBND"
#define WBASIGN         "HVSI" "WBA\0"
//#define ZWB_HANDLE      // disabled because I have seen this format only in one game so no need to support it



#ifdef ZWB_HANDLE
    #include <zlib.h>
#endif
In_Module mod;
HANDLE  input_file       = INVALID_HANDLE_VALUE,
        thread_handle    = INVALID_HANDLE_VALUE;
u_int   SAMPLERATE       = 44100;
int     data_offset      = 0,
        file_length      = 0,
        decode_pos_ms    = 0,
        paused           = 0,
        seek_needed      = 0,
        killDecodeThread = 0,
        sub_cur          = 0,
        sub_num          = 0,
        *sub_off         = NULL,
        *sub_len         = NULL,
        *sub_rate        = NULL;
u_short NCH              = 2;
short   *sub_nch         = NULL;
char    mytitle[FILENAME_MAX + 1 + 32] = "",
        lastfn[MAX_PATH + FILENAME_MAX + 1] = "";




BOOL WINAPI _DllMainCRTStartup(HANDLE hInst, ULONG ul_reason_for_call, LPVOID lpReserved) {
    return(TRUE);
}



DWORD WINAPI __stdcall DecodeThread(int *);



#ifdef ZWB_HANDLE
HANDLE unzip(HANDLE hFile, HANDLE hzip) {
    wa_inflate_struct   *zwa,
                        zwa_dll;
    HINSTANCE   hLib  = NULL;
    z_stream    z;
    HANDLE      htmp;
    DWORD       l,
                len;
    int         err,
                oldsz = 0,
                insz,
                outsz;
    u_char      *in   = NULL,
                *out  = NULL;

    zwa = (wa_inflate_struct *)SendMessage(mod.hMainWindow, WM_WA_IPC, 0x10100000, IPC_GETUNCOMPRESSINTERFACE);
    if(!zwa) {
        hLib = LoadLibrary("zlib1.dll");
        if(!hLib) return(hFile);
        zwa_dll.inflateReset = (void *)GetProcAddress(hLib, "inflateReset");
        zwa_dll.inflateInit_ = (void *)GetProcAddress(hLib, "inflateInit_");
        zwa_dll.inflate      = (void *)GetProcAddress(hLib, "inflate");
        zwa_dll.inflateEnd   = (void *)GetProcAddress(hLib, "inflateEnd");
        zwa                  = &zwa_dll;
    }

    z.zalloc = (alloc_func)0;
    z.zfree  = (free_func)0;
    z.opaque = (voidpf)0;

    if(zwa->inflateInit(&z) != Z_OK) goto errorx;

    insz  = 2048;       // 2 kb for input
    outsz = insz * 512; // 1 Mb for output
    in  = malloc(insz);
    out = malloc(outsz);
    if(!in || !out) goto errorx;

    while(ReadFile(hFile, in, insz, &len, NULL) && len) {
        z.next_in   = in;
        z.avail_in  = len;
        z.next_out  = out;
        z.avail_out = outsz;
        err = zwa->inflate(&z, Z_NO_FLUSH);
        WriteFile(hzip, out, z.total_out - oldsz, &l, NULL);
        oldsz = z.total_out;
        if(err != Z_OK) goto errorx;
    }

    htmp  = hFile;
    hFile = hzip;
    hzip  = htmp;

errorx:
    if(in)  free(in);
    if(out) free(out);
    zwa->inflateEnd(&z);
    if(hzip != INVALID_HANDLE_VALUE) CloseHandle(hzip);
    if(hLib) FreeLibrary(hLib);
    return(hFile);
}



HANDLE zwb_unzip(char *fn, HANDLE hFile) {
    HANDLE  hzip = INVALID_HANDLE_VALUE;
    DWORD   l,
            size;
    char    path[MAX_PATH + FILENAME_MAX + 1],
            *p;

    SetFilePointer(hFile, 4, NULL, FILE_BEGIN);
    ReadFile(hFile, &size, 4, &l, NULL);

    p = strrchr(fn, '\\');
    if(p) fn = p + 1;
    p = strchr(fn, '.');
    if(!p) p = fn + strlen(fn);
    sprintf(path + GetTempPath(MAX_PATH, path), "%.*s.xwb", p - fn, fn);

    hzip = CreateFile(
        path,
        GENERIC_READ,
        FILE_SHARE_READ | FILE_SHARE_WRITE,
        NULL,
        OPEN_EXISTING,
        FILE_ATTRIBUTE_NORMAL,
        NULL);
    if(hzip != INVALID_HANDLE_VALUE) {
        if(GetFileSize(hzip, NULL) == size) {
            CloseHandle(hFile);
            return(hzip);
        }
        CloseHandle(hzip);
    }

    hzip = CreateFile(
        path,
        GENERIC_READ    | GENERIC_WRITE,
        FILE_SHARE_READ | FILE_SHARE_WRITE,
        NULL,
        CREATE_NEW,
        FILE_ATTRIBUTE_NORMAL,
        NULL);
    if(hzip == INVALID_HANDLE_VALUE) return(hFile);

    return(unzip(input_file, hzip));
}
#endif



void config(HWND hwndParent) {
    MessageBox(
        hwndParent,
        "No configuration",
        "Configuration",
        MB_OK);
}



void about(HWND hwndParent) {
    MessageBox(
        hwndParent,
        PLUGIN_NAME" "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "plugin: http://aluigi.org/papers.htm#xbox\n",
        PLUGIN_NAME,
        MB_OK);
}



void init(void) {
}



void quit(void) {
}



int isourfile(char *fn) {
    return(0);
}



int getwavinfo(HANDLE hFile) {
    mywav_fmtchunk  fmt;
    int     wavsize;

    wavsize = mywav_data(hFile, &fmt);
    if(wavsize >= 0) {
        if((fmt.wFormatTag != 0x0069) && (fmt.wFormatTag != 0x0011)) {  // handle both xbox and ima adpcm, it's just 99% the same
            SetFilePointer(hFile, 0, NULL, FILE_BEGIN);
            return(-1);
        }
        NCH         = fmt.wChannels;
        SAMPLERATE  = fmt.dwSamplesPerSec;
        data_offset = SetFilePointer(hFile, 0, NULL, FILE_CURRENT);
    } else {
        SetFilePointer(hFile, 0, NULL, FILE_BEGIN);
        wavsize     = GetFileSize(hFile, NULL);
    }

    return(wavsize);
}



int getxwbinfo(HANDLE fd, int add_xwb) {
#define XWBRATE             ((meta24.type >> 5) & 0xffff)
#define XWBCHANS            ((meta24.type >> 2) & 3)
#define XWBCODEC            (meta24.type & 3)           // 0 = PCM, 1 = ADPCM, 2 = WMA
#define MYFSEEK(x)          if(SetFilePointer(fd, add_xwb + x, NULL, FILE_BEGIN) == INVALID_SET_FILE_POINTER) goto xwb_quit;
#define read_file(a,b,c)    if(!ReadFile(a, b, c, &l, NULL) || !l) goto xwb_quit;

    DWORD   l;
    u_int   i,
            ver,
            segment[4][2],
            filelen;
    u_char  sign[4];

    struct {
        u_int   flags;
        u_int   entry_num;
        u_char  bank_name[16];
        u_int   entry_metasz;
        u_int   entry_namesz;
        u_int   align;
    } seg0;

    struct {
        u_int   flags;
        u_int   type;
        u_int   off;
        u_int   len;
        u_int   region_off;
        u_int   region_len;
    } meta24;

    SetFilePointer(fd, add_xwb, NULL, FILE_BEGIN);

    read_file(fd, sign, 4);
    read_file(fd, &ver, 4);

    if(memcmp(sign, XWBSIGN, 4)) {
        MYFSEEK(0);
        return(-1);
    }

    for(i = 0; i < 4; i++) {
        read_file(fd, &segment[i][0], 4);
        read_file(fd, &segment[i][1], 4);
    }

    MYFSEEK(segment[0][0]);
    read_file(fd, &seg0, sizeof(seg0));

    memset(&meta24, 0, sizeof(meta24));

    sub_off  = malloc(sizeof(int)   * seg0.entry_num);
    sub_len  = malloc(sizeof(int)   * seg0.entry_num);
    sub_rate = malloc(sizeof(int)   * seg0.entry_num);
    sub_nch  = malloc(sizeof(short) * seg0.entry_num);

    for(i = 0; i < seg0.entry_num; i++) {
        MYFSEEK(segment[1][0]);

        if(seg0.entry_metasz < sizeof(meta24)) {
            meta24.len = 0;
            read_file(fd, &meta24, seg0.entry_metasz);
            if(!meta24.len) meta24.len = segment[3][1];
        } else {
            read_file(fd, &meta24, sizeof(meta24));
            if(seg0.entry_metasz > sizeof(meta24)) {
                SetFilePointer(fd, seg0.entry_metasz - sizeof(meta24), NULL, FILE_CURRENT);
            }
        }

        segment[1][0] += seg0.entry_metasz;
        meta24.off    += segment[3][0];

        if(XWBCODEC != 1) continue;

        sub_off[sub_num]  = meta24.off;
        sub_len[sub_num]  = meta24.len;
        sub_rate[sub_num] = XWBRATE;
        sub_nch[sub_num]  = XWBCHANS;
        sub_num++;
    }

xwb_quit:
    filelen = 0;
    if(sub_num) {
        for(i = 0; (int)i < sub_num; i++) {
            sub_off[i] += add_xwb;
//            filelen += sub_len[i];    // wrong!
        }
        data_offset = SetFilePointer(fd, sub_off[0], NULL, FILE_BEGIN);
        filelen     = (sub_off[sub_num - 1] + sub_len[sub_num - 1]) - sub_off[0];
    }
    return(filelen);

#undef XWBRATE
#undef XWBCHANS
#undef XWBCODEC
#undef MYFSEEK
#undef read_file
}



void getxshinfo(HANDLE hFile) {
    DWORD   l;
    int     i;
    u_char  data[100];

    SetFilePointer(hFile, 8, NULL, FILE_BEGIN);
    ReadFile(hFile, &sub_num, 4, &l, NULL);

    sub_off  = malloc(sizeof(int)   * sub_num);
    sub_len  = malloc(sizeof(int)   * sub_num);
    sub_rate = malloc(sizeof(int)   * sub_num);
    sub_nch  = malloc(sizeof(short) * sub_num);

    for(i = 0; i < sub_num; i++) {
        ReadFile(hFile, data, sizeof(data), &l, NULL);
        sub_off[i]  = *(int *)(data + 36);
        sub_len[i]  = *(int *)(data + 40);
        sub_nch[i]  = *(short *)(data + 82);
        sub_rate[i] = *(int *)(data + 84);
    }
}



HANDLE check_file(char *fn, HANDLE hFile, int *length) {
    HANDLE  htmp;
    DWORD   l;
    u_char  sign[8],
            *ext;

    SAMPLERATE  = 44100;
    NCH         = 2;
    data_offset = 0;
    if(sub_num) {
        free(sub_off);
        free(sub_len);
        free(sub_rate);
        free(sub_nch);
        sub_num = 0;
        sub_cur = 0;
    }

    ext = strrchr(fn, '.');
    if(ext) {
        ext++;
#ifdef ZWB_HANDLE
        if(!stricmp(ext, "zwb")) {
            hFile = zwb_unzip(fn, hFile);
            SetFilePointer(hFile, 0, NULL, FILE_BEGIN);
        } else
#endif
        if(!stricmp(ext, "xsh")) {
            strcpy(ext, "xsd");
            htmp = CreateFile(
                fn,
                GENERIC_READ,
                FILE_SHARE_READ | FILE_SHARE_WRITE,
                NULL,
                OPEN_EXISTING,
                FILE_ATTRIBUTE_NORMAL,
                NULL);
            if(htmp != INVALID_HANDLE_VALUE) {
                getxshinfo(hFile);
                CloseHandle(hFile);
                *length = GetFileSize(htmp, NULL);
                return(htmp);
            }

        } else if(!stricmp(ext, "xsd")) {
            strcpy(ext, "xsh");
            htmp = CreateFile(
                fn,
                GENERIC_READ,
                FILE_SHARE_READ | FILE_SHARE_WRITE,
                NULL,
                OPEN_EXISTING,
                FILE_ATTRIBUTE_NORMAL,
                NULL);
            if(htmp != INVALID_HANDLE_VALUE) {
                getxshinfo(htmp);
                CloseHandle(htmp);
                *length = GetFileSize(hFile, NULL);
                return(hFile);
            }
        }
    }

    ReadFile(hFile, sign, sizeof(sign), &l, NULL);
    SetFilePointer(hFile, 0, NULL, FILE_BEGIN);

    if(!memcmp(sign, XWBSIGN, sizeof(XWBSIGN) - 1)) {
        *length = getxwbinfo(hFile, 0);
    } else if(!memcmp(sign, WBASIGN, sizeof(WBASIGN) - 1)) {
        *length = getxwbinfo(hFile, 4096);
    } else {
        *length = getwavinfo(hFile);
    }
    return(hFile);
}



int set_output_audio(void) {
    int     maxlatency;

    maxlatency = mod.outMod->Open(
        SAMPLERATE,
        NCH,
        BPS,
        -1,
        -1);

    if(maxlatency < 0) {
        CloseHandle(input_file);
        input_file = INVALID_HANDLE_VALUE;
        return(1);
    }

    mod.SetInfo(
        (SAMPLERATE * BPS * NCH) / 1000,
        SAMPLERATE / 1000,
        NCH,
        1);

    mod.SAVSAInit(
        maxlatency,
        SAMPLERATE);

    mod.VSASetInfo(
        SAMPLERATE,
        NCH);

    return(0);
}



int play(char *fn) {
    DWORD   thread_id;
    char    *p;

    input_file = CreateFile(
        fn,
        GENERIC_READ,
        FILE_SHARE_READ | FILE_SHARE_WRITE,
        NULL,
        OPEN_EXISTING,
        FILE_ATTRIBUTE_NORMAL,
        NULL);
    if(input_file == INVALID_HANDLE_VALUE) return(1);

    input_file = check_file(fn, input_file, &file_length);
    if(file_length < 0) {
        CloseHandle(input_file);
        input_file = INVALID_HANDLE_VALUE;
        return(1);
    }

    p = strrchr(fn, '\\');
    if(p) {
        p++;
    } else {
        p = fn;
    }
    strcpy(mytitle, p);

    strcpy(lastfn, fn);
    paused        = 0;
    decode_pos_ms = 0;
    seek_needed   = -1;

    if(sub_num) {
        SAMPLERATE = sub_rate[0];
        NCH        = sub_nch[0];
    }
    if(set_output_audio() < 0) return(1);

    mod.outMod->SetVolume(
        -666);

    killDecodeThread = 0;

    thread_handle = (HANDLE)CreateThread(
        NULL,
        0,
        (LPTHREAD_START_ROUTINE)DecodeThread,
        (void *)&killDecodeThread,
        0,
        &thread_id);

    return(0);
}



void pause(void) {
    paused = 1;
    mod.outMod->Pause(1);
}



void unpause(void) {
    paused = 0;
    mod.outMod->Pause(0);
}



int ispaused(void) {
    return(paused);
}



void stop(void) {
    if(thread_handle != INVALID_HANDLE_VALUE) {
        killDecodeThread = 1;
        if(WaitForSingleObject(thread_handle,INFINITE) == WAIT_TIMEOUT) {
            TerminateThread(thread_handle, 0);
        }
        CloseHandle(thread_handle);
        thread_handle = INVALID_HANDLE_VALUE;
    }
    if(input_file != INVALID_HANDLE_VALUE) {
        CloseHandle(input_file);
        input_file = INVALID_HANDLE_VALUE;
    }

    mod.outMod->Close();

    mod.SAVSADeInit();
}



int getlength(void) {
    return(GETLENGTH(file_length));
}



int getoutputtime(void) {
    return(decode_pos_ms + (mod.outMod->GetOutputTime() - mod.outMod->GetWrittenTime()));
}



void setoutputtime(int time_in_ms) {
    seek_needed = time_in_ms;
}



void setvolume(int volume) {
    mod.outMod->SetVolume(volume);
}



void setpan(int pan) {
    mod.outMod->SetPan(pan);
}



int infoDlg(char *fn, HWND hwnd) {
    return(0);
}



void getfileinfo(char *filename, char *title, int *length_in_ms) {
    char    *p;

    if(sub_num && title) {
        sprintf(
            title,
            "%s - %d / %d",
            mytitle,
            sub_cur + 1, sub_num);

    } else if(filename && *filename && title) {
        p = strrchr(filename, '\\');
        if(p) {
            p++;
        } else {
            p = filename;
        }
        strcpy(title, p);
    }
    if(length_in_ms) {
        *length_in_ms = getlength();
    }
}



void eq_set(int on, char data[10], int preamp) {
}



int get_samples(u_char *buf) {
    DWORD   l,
            tot;
    int     i;
    u_char  locbuf[SAMPLESIZE(XBOX_ADPCM_SRCSIZE)];

    tot = 0;
    for(i = 0; i < MIN_SAMPLE_WA; i++) {
        if(!ReadFile(
            input_file,
            locbuf,
            sizeof(locbuf),
            &l,
            NULL) || !l) break;
        tot += TXboxAdpcmDecoder_Decode_Memory((void *)locbuf, l, (void *)(buf + tot), NCH);
    }

    return(tot);
}



void set_ms_seek(int fileoff) {
    int     tmp;

    SetFilePointer(input_file, fileoff, NULL, FILE_BEGIN);
    tmp           = GETLENGTH(fileoff);
    decode_pos_ms = tmp - (tmp % 1000);
    mod.outMod->Flush(decode_pos_ms);
}



DWORD WINAPI __stdcall DecodeThread(int *stop_now) {
    int     done = 0,
            i,
            l,
            offs;
    u_char  sample_buffer[SAMPLESIZE(XBOX_ADPCM_DSTSIZE) * MIN_SAMPLE_WA];

    while(!*stop_now) {
        if(seek_needed != -1) {
            decode_pos_ms = seek_needed - (seek_needed % 1000);
            seek_needed   = -1;
            done          = 0;
            mod.outMod->Flush(decode_pos_ms);
            offs = data_offset + ((((decode_pos_ms / 1000) * SAMPLERATE) / XBOX_ADPCM_DSTSIZE) * XBOX_ADPCM_SRCSIZE * NCH * (BPS >> 3));
            if(sub_num) {
                for(sub_cur = 0; (sub_cur < sub_num) && (offs >= sub_off[sub_cur]); sub_cur++);
                sub_cur--;
                offs -= sub_off[sub_cur];
                offs = sub_off[sub_cur] + (offs - (offs % (XBOX_ADPCM_SRCSIZE * NCH)));
                while(offs < sub_off[sub_cur]) sub_cur--;
                SAMPLERATE = sub_rate[sub_cur];
                NCH        = sub_nch[sub_cur];
                set_output_audio();
            }
            SetFilePointer(input_file, offs, NULL, FILE_BEGIN);
        }
        if(done) {
            mod.outMod->CanWrite();
            if(!mod.outMod->IsPlaying()) {
                PostMessage(mod.hMainWindow, WM_WA_MPEG_EOF, 0, 0);
                return(0);
            }
            Sleep(10);

        } else if(mod.outMod->CanWrite() >= (int)(sizeof(sample_buffer) << (mod.dsp_isactive() ? 1 : 0))) {
            offs = SetFilePointer(input_file, 0, NULL, FILE_CURRENT);
            if(offs >= (data_offset + file_length)) {
                done = 1;
                continue;
            }
            if(sub_num) {
                if(offs >= (sub_off[sub_cur] + sub_len[sub_cur])) {
                    do {
                        sub_cur++;
                        if(sub_cur >= sub_num) {
                            sub_cur = 0;
                            done = 1;
                            break;
                        }
                    } while(offs >= (sub_off[sub_cur] + sub_len[sub_cur]));
                    for(i = 0; mod.outMod->IsPlaying() && (i < 40); i++) Sleep(50);
                        // WORK-AROUND!!!
                        // unfortunately XMPlay sometimes freezes so I need to use the "&& (i <" work-around

                    SAMPLERATE = sub_rate[sub_cur];
                    NCH        = sub_nch[sub_cur];
                    set_ms_seek(sub_off[sub_cur]);
                    set_output_audio();
                }
            }
            l = get_samples(sample_buffer);
            if(l) {
                mod.SAAddPCMData((u_char *)sample_buffer,  NCH, BPS, decode_pos_ms);
                mod.VSAAddPCMData((u_char *)sample_buffer, NCH, BPS, decode_pos_ms);
                decode_pos_ms += ((l / NCH / (BPS >> 3)) * 1000) / SAMPLERATE;
                if(mod.dsp_isactive()) {
                    l = mod.dsp_dosamples(
                        (short *)sample_buffer,
                        l / NCH / (BPS >> 3),
                        BPS,
                        NCH,
                        SAMPLERATE) * (NCH * (BPS >> 3));
                }
                mod.outMod->Write(sample_buffer, l);
            } else {
                done = 1;
            }
        } else {
            Sleep(20);
        }
    }
    return(0);
}



In_Module mod = {
    IN_VER,
    PLUGIN_NAME" "VER,
    0,
    0,
    "WAV\0Xbox wave file (*.WAV)\0"
    "XWB\0Xbox wave bank file (*.XWB)\0"
#ifdef ZWB_HANDLE
    "ZWB\0Xbox wave bank file (*.ZWB)\0"
#endif
    "WBA\0Xbox wave bank file (*.WBA)\0"
    "XSD\0Xbox stream data file (*.XSD)\0"
    "XSH\0Xbox stream header file (*.XSH)\0"
//    "XSS\0Xbox stream file (*.XSS)\0"
//    "DAT\0Xbox old unxwb file (*.DAT)\0"
    ,
    1,
    1,
    config,
    about,
    init,
    quit,
    getfileinfo,
    infoDlg,
    isourfile,
    play,
    pause,
    unpause,
    ispaused,
    stop,

    getlength,
    getoutputtime,
    setoutputtime,

    setvolume,
    setpan,

    0,0,0,0,0,0,0,0,0,

    0,0,

    eq_set,

    NULL,

    0
};



__declspec(dllexport) In_Module * winampGetInModule2(void) {
    return(&mod);
}


