/*

by Luigi Auriemma

*/

#define FILE            HANDLE
#undef  SEEK_SET
#define	SEEK_SET        FILE_BEGIN
#undef  SEEK_CUR
#define	SEEK_CUR        FILE_CURRENT
#undef  SEEK_END
#define	SEEK_END        FILE_END
#ifndef FILENAME_MAX
    #define FILENAME_MAX    260
#endif



int sprintf(char *, const char *, ...);



size_t fread(void *buff, size_t len, size_t blen, FILE *fd) {
    DWORD   l;

    if(!ReadFile(fd, buff, len * blen, &l, NULL) || !l) return(-1);
    return(l / len);
}



size_t fwrite(void *buff, size_t len, size_t blen, FILE *fd) {
    DWORD   l;

    if(!WriteFile(fd, buff, len * blen, &l, NULL) || !l) return(-1);
    return(l / len);
}


int	fseek(FILE *fd, long offset, int method) {
    if(SetFilePointer(fd, offset, NULL, method) == INVALID_SET_FILE_POINTER) {
        return(-1);
    }
    return(0);
}


