/*
    Copyright 2009 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl-2.0.txt
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef unsigned char   u8;
typedef unsigned short  u16;
typedef unsigned int    u32;



#define VER         "0.1"



void lfs_dump(u8 *car, u8 *name, u8 *data, int datalen);
void quick_tea(u32 *k, u32 *data);
void lfs_tea(u32 x0, u32 x1, u32 x2, u32 x3, u8 *name, u8 *data, int datalen);
void std_err(void);



int main(int argc, char *argv[]) {
    FILE    *fd;
    u32     x0  = 0,
            x1  = 0,
            x2  = 0,
            x3  = 0;
    int     len;
    u8      buff[0xff],
            name[16],
            car[32],
            *fname,
            *fdir   = NULL;

    fputs("\n"
        "Live for Speed setups dumper "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\n"
            "Usage: %s <dump_file> [output_folder]\n"
            "\n"
            "how to generate the dump_file:\n"
            "- launch a sniffer like Wireshark\n"
            "- join a server\n"
            "- after having joined the server stop the sniffer\n"
            "- select one of the tcp packets and select \"Follow TCP Stream\"\n"
            "- select \"Save As\" and save the dump_file from which will be get and\n"
            "  decrypted all the setups used by the other players on the server\n"
            "\n", argv[0]);
        exit(1);
    }
    fname = argv[1];
    if(argc > 2) fdir = argv[2];

    printf("- open %s\n", fname);
    fd = fopen(fname, "rb");
    if(!fd) std_err();

    if(fdir) {
        printf("- set output folder %s\n", fdir);
        if(chdir(fdir) < 0) std_err();
    }

    for(;;) {
        len = fgetc(fd);
        if(len < 0) break;
        if(fread(buff, 1, len, fd) != len) break;

        if(buff[0] == 4) {
            memcpy(name, buff + 4, 16);
            x1 = *(u16 *)(buff + 38);
            x2 = *(u8 *)(buff + 41);
            x3 = *(u8 *)(buff + 40);
        } else if(buff[0] == 5) {
            x0 = *(u32 *)(buff + 4);
            memcpy(car, buff + 12, 32);
            lfs_tea(x0, x1, x2, x3, name, buff + 0x5c, 0x78);
            lfs_dump(car, name, buff + 0x5c, 0x78);
        }
    }

    fclose(fd);
    printf("- done\n");
    return(0);
}



void lfs_dump(u8 *car, u8 *name, u8 *data, int datalen) {
    FILE    *fd;
    u32     filever;
    int     i;
    u8      tmp[64];

    if(!memcmp(car, "FORMULA", 7)) {
        memmove(car + 1, car + 7, 32 - 7);
        car[(32 - 7) - 1] = 0;
    }
    for(i = 0; i < 32;) {
        if(!car[i]) break;
        if(car[i] == ' ') {
            memmove(car + i, car + i + 1, 32 - (i + 1));
            car[32 - 1] = 0;
        } else {
            i++;
        }
    }
    if(!memcmp(car, "FBM", 3) || !memcmp(car, "XFG", 3) || !memcmp(car, "XRG", 3)) {
        filever = 763;  // demo cars
    } else {
        filever = 762;
    }

    for(i = 0;; i++) {
        sprintf(tmp, "%.3s_%.16s", car, name);
        if(i) sprintf(tmp + strlen(tmp), "_%d", i);
        strcat(tmp, ".set");
        fd = fopen(tmp, "rb");
        if(!fd) break;
        fclose(fd);
    }
    printf("- create %s\n", tmp);
    fd = fopen(tmp, "wb");
    if(!fd) std_err();
    fwrite("SRSETT\0", 1, 7, fd);
    fwrite(&filever,   1, 4, fd);
    fputc(0x00, fd);
    memmove(tmp, data + 20, 12);
    memmove(data + 20, data + 32, 4);
    memmove(data + 20 + 4, tmp, 12);
    fwrite(data, 1, datalen, fd);
    fclose(fd);
}



void quick_tea(u32 *k, u32 *data) {
    u32     y, z, i, sum;

    y = data[0];
    z = data[1];
    sum = 0xc6ef3720;
    for(i = 0; i < 32; i++) {
        z -= ((y << 4) + k[2]) ^ (y + sum) ^ ((y >> 5) + k[3]);
        y -= ((z << 4) + k[0]) ^ (z + sum) ^ ((z >> 5) + k[1]);
        sum -= 0x9e3779b9;
    }
    data[0] = y;
    data[1] = z;
}



void lfs_tea(u32 x0, u32 x1, u32 x2, u32 x3, u8 *name, u8 *data, int datalen) {
    u32     key[4];
    int     i;

    memcpy(key, name, 16);
    key[0] ^= x0;
    key[1] ^= x1;
    key[2] ^= x2;
    key[3] ^= x3;

    datalen /= 8;
    for(i = 0; i < datalen; i++) {
        quick_tea(key, (u32 *)data);
        data += 8;
    }
}



void std_err(void) {
    perror("\nError");
    exit(1);
}


