/*

    Copyright 2004,2005,2006 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl.txt

*/

#include <stdio.h>
#include <stdlib.h>



#define VER     "0.1"
#define BUFFSZ  32768   // DON'T MODIFY IT! must be a multiplier of 256



typedef unsigned char   u_char;
typedef unsigned int   u_int;



void std_err(int err);



int main(int argc, char *argv[]) {
    FILE                *fd,
                        *fdout;
    int                 i,
                        len,
                        xornum,
                        op;
    u_char              buff[BUFFSZ],
                        *ptr;
    const static u_char fixhead[] =
            "\x23\x24\x25\x5E\x18\xCE\xAB\x00\x11\x37\xDE\x00\xBE\x18\x00\x00"
            "\x5F\x3D\x48\x6D";


    setbuf(stdout, NULL);

    fputs("\n"
        "Massive Assault Network files decoder/encoder "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 4) {
        printf("\nUsage: %s <d/e> <input_file> <output_file>\n"
            "\n"
            " d = use it to decode a MAN file (like local\\misc.txt)\n"
            " e = use it to encode a previously decoded MAN file\n"
            "\n", argv[0]);
        exit(1);
    }

    op = argv[1][0];
    if((op != 'd') && (op != 'e')) {
        fputs("\nError: you can choose between 'd' to decode and 'e' to encode a MAN file\n", stdout);
        exit(1);
    }

    printf("- Open input:      %s\n", argv[2]);
    fd = fopen(argv[2], "rb");
    if(!fd) std_err(0);

    printf("- Create output:   %s\n", argv[3]);
    fdout = fopen(argv[3], "wb");
    if(!fdout) std_err(0);

    if(op == 'd') {
        if(fread(buff, 20, 1, fd) != 1) std_err(1);
        if((*(u_int *)buff != 0x5e252423) || (*(u_int *)(buff + 16) != 0x6d483d5f)) {
            fputs("\nError: the input file is not a Massive Assault Network encoded file\n", stdout);
            exit(1);
        }
        xornum = buff[12];
        printf("- Encoding number: 0x%02x\n", xornum);

        while((len = fread(buff, 1, BUFFSZ, fd))) {
            ptr = buff;
            for(i = 0; i < len; i++) {
                *ptr = (*ptr ^ 0xed) - (i * i) - xornum - 0x6f;
                ptr++;
            }
            if(fwrite(buff, len, 1, fdout) != 1) std_err(2);
        }

    } else {
        fputs("- Add header\n", stdout);
        if(fwrite(fixhead, sizeof(fixhead) - 1, 1, fdout) != 1) std_err(2);
        xornum = fixhead[12];
        printf("- Encoding number: 0x%02x\n", xornum);

        while((len = fread(buff, 1, BUFFSZ, fd))) {
            ptr = buff;
            for(i = 0; i < len; i++) {
                *ptr = (*ptr + (i * i) + xornum + 0x6f) ^ 0xed;
                ptr++;
            }
            if(fwrite(buff, len, 1, fdout) != 1) std_err(2);
        }
    }

    fclose(fd);
    fclose(fdout);
    fputs("- Finished\n", stdout);

    return(0);
}



void std_err(int err) {
    if(!err) {
        perror("\nError");
    } else if(err == 1) {
        fputs("\nError: the input file is probably corrupted\n", stdout);
    } else if(err == 2) {
        fputs("\nError: impossible to write the output file, probably the disk space is finished\n", stdout);
    }
    exit(1);
}

