/*
    Copyright 2007,2008,2009,2010 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl.txt
*/

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <time.h>
#include <direct.h>
#include <windows.h>
#include "orkdec_files.h"

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define READBITS    0
#define WRITEBITS   1
#define SEARCH1     "\x68" "\x62\xA9\x7C\x4A" /* push 4A7CA962 */ \
                    "\x68" "\xFB\xC8\x89\x91" /* push 9189C8FB */ \
                    "\x68" "\x48\x20\x4F\xDD" /* push DD4F2048 */
#define SEARCH2     "\x68" "\x92\x28\x8e\xc3" \
                    "\x68" "\x91\xb9\xa7\x7d" \
                    "\x68" "\x4d\x45\xf7\xd3"
#define SEARCH3     "\x68" "\xa5\x97\x91\xf8" /* Exigo and Battle March */ \
                    "\x68" "\xf2\x8b\x59\xfb" \
                    "\x68" "\xa3\xce\x8b\x48"



FILE        *fd = NULL;
void        *orkdec_off     = NULL;
static u8   dumpfile[64],
            *orkdec_jmp     = NULL;



void orkdec_files(const void *args, ...) {
    static int lame_skip = -1;  // work-around for Battle March
    u32     keyset1,
            keyset2,
            keyset3;
    int     filenamesz;
    u8      *filename,
            *stack;

    stack = (void *)&args;
    stack += sizeof(void *) * 3;    // we must skip the push eax, ecx and edx
                                    stack += sizeof(void *);
                                    stack += sizeof(void *);
    if(lame_skip > 0)               stack += lame_skip;
    keyset1    = *(u32 *)stack;     stack += sizeof(void *);
    keyset2    = *(u32 *)stack;     stack += sizeof(void *);
    keyset3    = *(u32 *)stack;     stack += sizeof(void *);
    filename   = *(u8 **)stack;     stack += sizeof(void *);
    filenamesz = *(int *)stack;     stack += sizeof(void *);

    if(lame_skip < 0) { // executed only the first time
        for(lame_skip = 0; (unsigned)filenamesz > 2000; lame_skip += sizeof(void *)) {
            filename   = *(u8 **)(stack - sizeof(void *));  // filename = filenamesz
            filenamesz = *(int *)stack;     stack += sizeof(void *);
        }
    }

    fprintf(fd, "%.*s\r\n", filenamesz, filename);
    fflush(fd);
}



int jmp(u8 *buff, void *from, void *to) {
    buff[0] = 0xe9;
    *(u32 *)(buff + 1) = to - (from + 5);
    return(5);
}



int call(u8 *buff, void *from, void *to) {
    buff[0] = 0xe8;
    *(u32 *)(buff + 1) = to - (from + 5);
    return(5);
}



int mm(u8 *dst, u8 *src, int len) {
    memcpy(dst, src, len);
    return(len);
}



void *find_bytes(void *buff, int buffsz, u8 *data, int datalen) {
    u8      *p,
            *l;

    l = buff + buffsz - datalen;
    for(p = buff; p <= l; p++) {
        if(!memcmp(p, data, datalen)) return(p);
    }
    return(NULL);
}



int get_current_section(IMAGE_NT_HEADERS *nthdr, IMAGE_SECTION_HEADER **sechdr, u32 file) {
    int     i;

    for(i = 0; i < nthdr->FileHeader.NumberOfSections; i++) {
        if((file >= sechdr[i]->PointerToRawData) && (file < (sechdr[i]->PointerToRawData + sechdr[i]->SizeOfRawData))) {
            return(i);
        }
    }
    return(0);
}



void *parse_PE(void *filemem, u32 *filesize) {
    IMAGE_DOS_HEADER        *doshdr;
    IMAGE_NT_HEADERS        *nthdr;
    IMAGE_SECTION_HEADER    **sechdr;
    int     i,
            sec;
    u8      *dosdata,
            *p;

    p = filemem;
    doshdr  = (IMAGE_DOS_HEADER *)p;    p += sizeof(IMAGE_DOS_HEADER);
    dosdata = p;                        p += doshdr->e_lfanew - sizeof(IMAGE_DOS_HEADER);
    nthdr   = (IMAGE_NT_HEADERS *)p;    p += sizeof(IMAGE_NT_HEADERS);

    if((doshdr->e_magic != IMAGE_DOS_SIGNATURE) || (nthdr->Signature != IMAGE_NT_SIGNATURE)) {
        return(NULL);
    }
    if((nthdr->FileHeader.Machine != IMAGE_FILE_MACHINE_I386) || (nthdr->OptionalHeader.Magic != IMAGE_NT_OPTIONAL_HDR_MAGIC)) {
        return(NULL);
    }

    sechdr = calloc(sizeof(IMAGE_SECTION_HEADER *), nthdr->FileHeader.NumberOfSections);
    for(i = 0; i < nthdr->FileHeader.NumberOfSections; i++) {
        sechdr[i] = (IMAGE_SECTION_HEADER *)p;
        p += sizeof(IMAGE_SECTION_HEADER);
    }

    sec = get_current_section(nthdr, sechdr, nthdr->OptionalHeader.AddressOfEntryPoint);
    if(sec < 0) {
        fprintf(stderr, "\nAlert: the entrypoint is outside the file, I scan the first section\n");
        sec = 0;
    }

    filemem  += sechdr[sec]->PointerToRawData;
    *filesize = sechdr[sec]->SizeOfRawData;

    free(sechdr);
    return(filemem);
}



void orkdec_init(void) {
    DWORD   oldvp;
    char    *wd;
    u32     memsize;
    int     skipbytes   = 13;
    u8      buff[MAX_PATH + 512],
            tmp[2 + 5],
            *p;
    void    *mem;

    mem = parse_PE(GetModuleHandle(NULL), &memsize);
    if(mem) {
        orkdec_off = find_bytes((void *)mem, memsize, (void *)SEARCH1, sizeof(SEARCH1) - 1);
        if(!orkdec_off) orkdec_off = find_bytes((void *)mem, memsize, (void *)SEARCH2, sizeof(SEARCH2) - 1);
        if(!orkdec_off) orkdec_off = find_bytes((void *)mem, memsize, (void *)SEARCH3, sizeof(SEARCH3) - 1);
    }
    if(orkdec_off) {
        orkdec_off += (sizeof(SEARCH1) - 1);
        if(((u8 *)orkdec_off)[skipbytes] != 0xe8) {
            skipbytes = 5;
            while(((u8 *)orkdec_off)[skipbytes] != 0xe8) {
                skipbytes++;
                //orkdec_off = NULL;
            }
        }
    }
    if(!orkdec_off) {
        MessageBox(0,
            TITLE
            "Error: the needed function has not been found in the process\n"
            "Remember that you need to use the no-cd executable because the original one is encrypted\n",
            HEAD,
            MB_OK | MB_TASKMODAL);
        exit(1);
    }

    orkdec_off += skipbytes + 1;
    orkdec_off += 4 + (*(u32 *)orkdec_off);

    ReadProcessMemory(GetCurrentProcess(), (void *)orkdec_off, tmp, sizeof(tmp), NULL);

    orkdec_jmp = VirtualAlloc(
        NULL,
        4096,   // after all 4096 is the minimum page size, so using 32 is the same
        MEM_COMMIT | MEM_RESERVE,
        PAGE_EXECUTE_READWRITE);    // write for memcpy

    p = buff;
    p += jmp(p, (void *)orkdec_off, (void *)orkdec_jmp);
    while((p - buff) < (int)sizeof(tmp)) *p++ = 0x90;
    VirtualProtect((void *)orkdec_off, p - buff, PAGE_EXECUTE_READWRITE, &oldvp);
    WriteProcessMemory(GetCurrentProcess(), (void *)orkdec_off, buff, p - buff, NULL);
    VirtualProtect((void *)orkdec_off, p - buff, oldvp, &oldvp);

    p = orkdec_jmp;
    *p++ = 0x50;
    *p++ = 0x51;
    *p++ = 0x52;
    p += call(p, p, (void *)orkdec_files);
    *p++ = 0x5a;
    *p++ = 0x59;
    *p++ = 0x58;
    p += mm(p, (void *)tmp, sizeof(tmp));
    p += jmp(p, (void *)p, (void *)orkdec_off + sizeof(tmp));

    sprintf((char *)dumpfile, "%08x_orkdec_files.txt", (u32)time(NULL));

    wd = getcwd(NULL, 0);
    sprintf((char *)buff,
        TITLE
        "DLL successfully injected and ready to work:\n"
        "- filename function  %p\n"
        "\n"
        "Dump file: %s\\%s\n"
        "\n"
        "Do you want to continue?\n",
        orkdec_off,
        wd, dumpfile);
    free(wd);

    if(MessageBox(0,
        (char *)buff,
        HEAD,
        MB_OKCANCEL | MB_TASKMODAL) == IDCANCEL) exit(1);

    fd = fopen((char *)dumpfile, "wb");
    if(!fd) exit(1);
}



BOOL APIENTRY DllMain(HMODULE hModule, DWORD ulReason, LPVOID lpReserved) {
    switch(ulReason) {
        case DLL_PROCESS_ATTACH: {
            DisableThreadLibraryCalls(hModule);
            orkdec_init();
            } break;
        case DLL_THREAD_ATTACH: {
            } break;
        case DLL_PROCESS_DETACH: {
            if(fd) fclose(fd);
            } break;
        case DLL_THREAD_DETACH: {
            } break;
    }
    return(TRUE);
}


