/*
    Copyright 2011 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl-2.0.txt
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef unsigned char   u8;
typedef unsigned int    u32;



#define VER     "0.1.1"



typedef struct {
    u8      *ver;
    u8      *key1;
    u8      *key2;
} keys_t;

keys_t  keys[] = {
    {
        "1.4",
        "\x4B\x61\x58\x34\x59\x6B\x62\x5A\x76\x24\x38\x66\x63\x4D\x6D\x35\x76\x26\x68\x25\x59\x35\x78\x63\x48\x79\x4A\x2B\x79\x57\x47\x41",
        "\x33\x6E\x79\x55\x77\x5A\x50\x5F\x23\x48\x33\x2B\x42\x6E\x41\x59\x51\x21\x6D\x4E\x58\x70\x2D\x44\x72\x55\x48\x25\x50\x4D\x65\x5F\x33\x42\x4B\x35\x4B\x54\x76\x3F\x37\x2B\x6D\x7A\x7A\x37\x45\x39\x48\x68\x37\x55\x53\x4B\x53\x2B\x34\x66\x6B\x41\x56\x66\x59"
    },{
        "1.2/1.3",
        "\xA6\xAC\xE6\xEC\xF1\xA8\x2B\xFC\xE8\xBF\x0B\x76\xF3\x2B\xA1\x3B\x2D\x76\x23\x2D\x2D\x3F\x2B\xA6\x4C\xF6\x7A\x57\xE1\xEF\x4C\x54",
        "\xA6\x26\xE7\x78\x6E\x76\x4C\x2E\x5A\x2C\x74\xEA\x6D\xF6\x54\x76\x44\x30\x7C\xE6\xA8\x49\x3D\xEC\x54\xA6\x5E\xA2\x4E\x27\x3C\x38\x2D\x2B\x38\x2D\x2D\xAA\xAF\xD5\x2B\x54\x2E\x3E\x5E\x41\x71\x48\x76\x45\xFB\x2D\x54\xF7\x2D\x5A\x2F\x4C\x74\xAA\x6D\xA6\x2B"
    },{
        NULL,
        NULL,
        NULL
    }
};



int osrw_scramble(u32 *n, u8 *ctx1, u8 *ctx2);
int osrw_crypt(u8 *key1, u8 *key2, u8 *data, int size, int encrypt);
void std_err(void);



int main(int argc, char *argv[]) {
    keys_t  *key    = &keys[0];
    FILE    *fd;
    int     i,
            size,
            encrypt = 0;
    u8      *buff,
            *ver    = NULL,
            *in,
            *out;

    fputs("\n"
        "OSRW anticheat logs decrypter "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s [options] <input.rar> <output.txt>\n"
            "\n"
            "Options:\n"
            "-v VER   OSRW version (default is %s)\n"
            "-e       encrypt instead of decrypting\n"
            "\n", argv[0], key->ver);
        exit(1);
    }

    argc -= 2;
    for(i = 1; i < argc; i++) {
        if(((argv[i][0] != '-') && (argv[i][0] != '/')) || (strlen(argv[i]) != 2)) {
            printf("\nError: recheck your options, %s is not valid\n", argv[i]);
            exit(1);
        }
        switch(argv[i][1]) {
            case 'v': ver       = argv[++i];    break;
            case 'e': encrypt   = 1;            break;
            default: {
                printf("\nError: wrong command-line argument (%s)\n\n", argv[i]);
                exit(1);
                break;
            }
        }
    }
    in  = argv[argc];
    out = argv[argc + 1];

    printf("- open file %s\n", in);
    fd = fopen(in, "rb");
    if(!fd) std_err();
    fseek(fd, 0, SEEK_END);
    size = ftell(fd);
    buff = malloc(size);
    if(!buff) std_err();
    fseek(fd, 0, SEEK_SET);
    fread(buff, 1, size, fd);
    fclose(fd);

    if(ver) {
        for(i = 0; keys[i].ver; i++) {
            if(strstr(keys[i].ver, ver)) {
                key = &keys[i];
                break;
            }
        }
    }

    printf("- decrypt %d bytes using the keys of OSRW version %s\n", size, key->ver);
    osrw_crypt(
        key->key1,
        key->key2,
        buff,
        size,
        encrypt);

    // each file starts with -STARTUP- so it can be scanned to guess the key/version

    printf("- create file %s\n", out);
    fd = fopen(out, "wb");
    if(!fd) std_err();
    fwrite(buff, 1, size, fd);
    fclose(fd);

    printf("- done\n");
    return(0);
}



int osrw_scramble(u32 *n, u8 *ctx1, u8 *ctx2) {
    u32     x,
            y,
            z,
            *p;
    int     i,
            j;
    u8      a,
            b;

    x = n[0];
    y = n[1];
    p = (u32 *)ctx1;
    for(i = 0; i < 0x20; i++) {
        z = x;
        x += p[i];
        for(j = 0; j < 4; j++) {
            a = (x >> (j * 8)) & 0xff;
            b = a & 0x0f;
            a = (a & 0xf0) | ctx2[b + (0x20 * j)];
            b = (a & 0xf0) >> 4;
            a = (a & 0x0f) | ctx2[b + (0x20 * j) + 0x10];
            x &= ~(0xff << (j * 8));
            x |= a << (j * 8);
        }
        x = (x >> 5)    | (x << 27);
        x = (x >> 0x10) | (x << 0x10);
        x ^= y;
        y = z;
    }
    n[0] = y;
    n[1] = x;
    return(0);
}



int osrw_crypt(u8 *key1, u8 *key2, u8 *data, int size, int encrypt) {
    u32     n[2],
            t[2],
            *p32;
    int     i,
            x;
    u8      ctx1[0x80],
            ctx2[0x80],
            *p,
            a,
            b;

    p = ctx1;
    memcpy(p,        key1, 0x20);
    memcpy(p + 0x20, key1, 0x20);
    memcpy(p + 0x40, key1, 0x20);
    for(i = 0; i < 0x20; i++) { // reverse
        p[0x60 + i] = key1[(0x20 - 1) - i];
    }

    x = 1;
    p = ctx2;
    for(i = 0; i < 0x40; i++) {
        if(!(i & 7)) x = !x;
        a = (key2[i] >> 4) & 0xf;
        b = key2[i] & 0xf;
        if(x) {
            a <<= 4;
            b <<= 4;
        }
        *p++ = a;
        *p++ = b;
    }

    //n[0] = 0x10101010;
    //n[1] = 0x10101010;
    //osrw_scramble(n, ctx1, ctx2);

    p32 = (u32 *)data;
    size >>= 3;
    n[0] = 0;
    n[1] = 0;
    for(i = 0; i < size; i++) {
        if(!encrypt) {
            t[0] = p32[0];
            t[1] = p32[1];
        }
        osrw_scramble(n, ctx1, ctx2);
        p32[0] ^= n[0];
        p32[1] ^= n[1];
        if(encrypt) {
            n[0] = p32[0];
            n[1] = p32[1];
        } else {
            n[0] = t[0];
            n[1] = t[1];
        }
        p32 += 2;
    }    
    return(0);
}



void std_err(void) {
    perror("\nError");
    exit(1);
}

