/*
    Copyright 2004,2005,2006,2007,2008,2009 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl-2.0.txt
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef WIN32
    #include <winsock.h>
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <arpa/inet.h>
    #include <netdb.h>
#endif



#define VER     "0.3"



#include "peerchat_ip.h"
int fgetz(char *buff, int size);
void decenc(char *ipstr);



int main(int argc, char *argv[]) {
    int     i;
    char    buff[1024];

    fputs("\n"
        "Peerchat IP decoder/encoder "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    printf(
        "- type the IP addresses you want to decode or encode or specify them at\n"
        "  command-line. the tool can also encode and decode the IPs of the user's room\n"
        "  if are specified other 2 values: a 0 and the port of the server. examples:\n"
        "    1.2.3.4 0 1234\n"
        "    X19s4Fp1DX\n"
        "    MD9NqJlJJM 0 1234\n"
        "\n");

    if(argc > 1) {
        for(i = 1; i < argc; i++) {
            decenc(argv[i]);
        }
    } else {
        while(fgetz(buff, sizeof(buff)) >= 0) {
            decenc(buff);
        }
    }
    return(0);
}



int fgetz(char *buff, int size) {
    char    *p;

    if(!fgets(buff, size, stdin)) return(-1);
    for(p = buff; *p && (*p != '\n') && (*p != '\r'); p++);
    *p = 0;
    return(p - buff);
}



char *get_arg(char **data) {
    char    *p;

    if(!data || !*data) return(NULL);
    for(p = *data; *p && (*p <= ' '); p++);
    *data = p;
    while(*p && (*p > ' ')) p++;
    if(!*p) return(NULL);
    *p = 0;
    return(p + 1);
}



int get_num(char *str) {
    int     offset;

    if(!strncmp(str, "0x", 2) || !strncmp(str, "0X", 2)) {
        sscanf(str + 2, "%x", &offset);
    } else {
        sscanf(str, "%u", &offset);
    }
    return(offset);
}



void decenc(char *ipstr) {
    struct in_addr  ip;
    int     type;
    char    *arg1 = NULL,
            *arg2 = NULL,
            *arg3 = NULL;

    arg1 = ipstr;
    arg2 = get_arg(&arg1);
    arg3 = get_arg(&arg2);
           get_arg(&arg3);

    printf("\n");
    if(strchr(arg1, '.')) {
        printf("  peerchat IP:   X%sX\n", peerchat_ip_encoder(inet_addr(arg1), 0));
        if(arg2 && arg3) {
            printf("  peerchat room: M%sM\n", peerchat_room_encoder(inet_addr(arg1), get_num(arg2), get_num(arg3)));
        }
    } else {
        type = arg1[0];
        if(type == 'M') {
            if(!arg2 || !arg3) {
                printf("- you must add a 0 and the port of the server\n");
                return;
            }
            ip.s_addr = peerchat_room_decoder(arg1 + 1, get_num(arg2), get_num(arg3));
        } else if(type == '#') {
            if(!arg2 || !arg3) {
                printf("- you must add a 0 and the port of the server\n");
                return;
            }
            arg1 = strchr(arg1 + 1, '!');
            if(!arg1) return;
            arg1 = strchr(arg1 + 1, '!');
            if(!arg1) return;
            ip.s_addr = peerchat_room_decoder(arg1 + 2, get_num(arg2), get_num(arg3));
        } else if(type == 'X') {
            ip.s_addr = peerchat_ip_decoder(arg1 + 1, 0);
        } else {
            ip.s_addr = peerchat_ip_decoder(arg1, 0);
        }
        printf("  decoded IP:  %s\n", inet_ntoa(ip));
    }
}


