/*

Quake 3 engine GUID MD5 0.1
by Luigi Auriemma
e-mail: aluigi@autistici.org
web:    aluigi.org


This header file contains a modification of the md5_init() function
ables to create the Quake 3 GUID from a cd-key.
FYI: The Quake 3 GUID is visible in the cl_guid field in the connect
     packet.

You NEED the MD5 algorithm to use this little modification.
An usage example is the following:

    md5_state_t     md5t;
    unsigned char   md5h[16];

    q3_md5_init(&md5t);
    md5_append(&md5t, "0123456789abcdef", 16);
    md5_finish(&md5t, md5h);

where 0123456789abcdef is the cd-key on which you want to calculate
the Quake 3 GUID.

It is very simple to use however in case of problems you can
substituite the original md5_init() function of your MD5 algorithm
with the 4 lines (abcd[x]) of this one.


    Copyright 2004,2005,2006 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl.txt

*/

#include "md5.h"


void q3_md5_init(md5_context *pms) {
    pms->total[0] = pms->total[1] = 0;
    pms->state[0] = 0x67e685c2;  // Q3
    pms->state[1] = 0xf3df577e;  // Q3
    pms->state[2] = 0x9ad9b4cd;  // Q3
    pms->state[3] = 0x15c17579;  // Q3
}


