/*

    Copyright 2004,2005,2006 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl.txt

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "md5.h"
#include "q3_guid.h"



#define VER     "0.2"



int main(int argc, char *argv[]) {
    int             i,
                    len,
                    x;
    md5_context     md5t;
    unsigned char   md5h[16],
                    guid[33],
                    *p1;
    const char      *hex = "0123456789abcdef";


    setbuf(stdout, NULL);

    fputs("\n"
        "Quake 3 engine cd-key to GUID "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\nUsage: %s <CDKEY>\n"
            "\n", argv[0]);
        exit(1);
    }

    p1 = argv[1];
    len = strlen(argv[1]);
    for(i = 0; i < len; i++, p1++) {
        if((*p1 >= 'a') && (*p1 <= 'z')) *p1 -= 0x20;
    }

    q3_md5_init(&md5t);
    md5_update(&md5t, argv[1], strlen(argv[1]));
    md5_finish(&md5t, md5h);

    for(i = 0, x = 0; i < 16; i++) {
        guid[x++] = hex[md5h[i] >> 4];
        guid[x++] = hex[md5h[i] & 0xf];
    }
    guid[x] = 0;

    printf("\n"
        "CDKEY: %s\n"
        "GUID:  %s\n"
        "\n",
        argv[1],
        guid);

    return(0);
}


