/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define  close  closesocket
    #define sleep   Sleep
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netdb.h>
#endif



#define VER         "0.2.1"
#define AUTHSERVER  "authorize.quake3arena.com"
#define AUTHPORT    27952
#define BUFFSZ      2048
#define KEYAUTH     "\xff\xff\xff\xff" "getKeyAuthorize 0 %s"
#define TIMEOUT     5
#define OKKO        "\x00\x00\x01\x01\x01\x00\x01\x01" \
                    "\x01\x01\x01\x01\x01\x01\x01\x00" \
                    "\x00\x00\x00\x01\x01\x00\x00\x01" \
                    "\x00\x01\x00\x01\x01\x01\x00\x01" \
                    "\x00\x00\x00\x01\x01\x00"



int check_it_online(u_char *key);
int timeout(int sd);
u_int resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    FILE            *fd,        // input file (if selected)
                    *fdout;     // output file
    int             i;
    unsigned char   key[32],    // where the current key is stored
                    *ptr,
                    keyfile,    // 0 = key, 1 = file
                    ecx;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif


    setbuf(stdout, NULL);

    fputs("\n"
        "ONLINE CD-Key checker for Quake III "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf(
    "\n"
    "Usage: %s <*>\n"
    "\n"
    "*\n"
    "if the argument is a file, the program will start to check all the keys in it\n"
    "(a key for each line!) otherwise, the argument will be considered as a key\n"
    "Examples:\n"
    "\n"
    "q3onlinekeycheck mykeys.txt         = will check all the keys in the text file\n"
    "q3onlinekeycheck mykeys.txt out.txt = will check the keys and the valid keys\n"
    "                                      will be stored in out.txt\n"
    "q3onlinekeycheck 1234567890123456   = will check the key 1234567890123456 (the\n"
    "                                      output file can be used also here)\n"
    "\n"
    "Notes: the program automatically checks a key 2 times if it seems valid, so it\n"
    "will avoid false positive\n"
    "The usage of the output file is highly suggested, and if you wanna have a log\n"
    "file with the errors you must simply use the redirection:\n"
    "    q3onlinekeycheck mykeys.txt out.txt > log.txt\n"
    "\n", argv[0]);
        exit(1);
    }

        /* input file or key */

    fd = fopen(argv[1], "rb");
    if(!fd) {
        keyfile = 0;
        memcpy(key, argv[1], 16);
        key[16] = 0;
        printf("Key: %s\n", key);
    } else {
        keyfile = 1;
    }

        /* output file or stdout */

    if(argc > 2) {
        fdout = fopen(argv[2], "wb");
        if(!fdout) std_err();
    } else fdout = stdout;


    while(1) {
        if(keyfile) {
            ptr = fgets(key, 32, fd);
            if(!ptr) break;
            key[16] = 0;
            fputs(key, stdout);
        }

/* removed because it is useless
        i = strlen(key);
        if(i > 16) {
            fputs("\nError: CD-Key must be 16 bytes long (yours is major)\n", stdout);
            exit(1);
        } else if(i < 16) {
            fputs("\nError: CD-Key must be 16 bytes long (yours is minor)\n", stdout);
            exit(1);
        }
*/
            /* algorithm for local key check */

        ptr = key;
        for(i = 0; i < 16; i++, ptr++) {
            if((*ptr >= 0x61) && (*ptr <= 0x7a)) *ptr -= 0x20;
            ecx = *ptr + 0xce;
            if(ecx > 0x25) break;
            if(OKKO[ecx]) break;
        }

        if(!keyfile) {
            if(i == 16) {
                fputs("\nYour Cd-Key is OK for local game\n", stdout);
            } else {
                fputs("\nYour Cd-Key is invalid, so I will not continue the online check\n", stdout);
                exit(1);
            }
        } else {
            if(i != 16) {
                fputs(" is invalid\n", stdout);
                continue;
            }
        }

            /* double online check to avoid errors!!! */

        if(!check_it_online(key)) {
            fputs("  false positive double check...\n", stdout);
            if(!check_it_online(key)) fprintf(fdout, "%s\n", key);
        }

        if(!keyfile) break;
    }

    if(keyfile) fclose(fd);
    return(0);
}



int check_it_online(u_char *key) {
    int             sd,
                    err,
                    rlen,
                    len;
    unsigned char   buff[BUFFSZ + 1];
    struct  sockaddr_in peer;

    len = snprintf(
        buff,
        BUFFSZ,
        KEYAUTH,
        key);

    peer.sin_addr.s_addr = resolv(AUTHSERVER);
    peer.sin_port        = htons(AUTHPORT);
    peer.sin_family      = AF_INET;
    rlen                 = sizeof(peer);

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();
    err = sendto(sd, buff, len, 0, (struct sockaddr *)&peer, rlen);
    if(err < 0) std_err();
    err = timeout(sd);
    if(err < 0) {   /* timeout = OK!!! */
        close(sd);
        printf("  Key %s seems to be valid for online game!\n",
            key);
        return(0);
    }
    err = recvfrom(sd, buff, BUFFSZ, 0, (struct sockaddr *)&peer, &rlen);
    if(err < 0) std_err();
    close(sd);

    buff[err] = 0;
    printf("\nError: key doesn't seem to be valid for online game\n"
        "Check the log from the authorization server:\n"
        "%s\n"
        "\n", buff + 4);
    return(-1);
}



int timeout(int sock) {
    struct    timeval    tout;
    fd_set    fd_read;
    int    err;

    tout.tv_sec = TIMEOUT;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    err = select(sock + 1, &fd_read, NULL, NULL, &tout);
    if(err < 0) std_err();
    if(!err) return(-1);
    return(0);
}



u_int resolv(char *host) {
    struct  hostent *hp;
    u_int  host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u_int *)(hp->h_addr);
    }

    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif



