/*

    Copyright 2004,2005,2006 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl.txt

*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef WIN32
    #include <direct.h>
    #include <malloc.h>
#else
    #include <unistd.h>
    #include <sys/stat.h>
#endif



#define VER         "0.1"
#define BUFFSZ      16384



void filecopy(FILE *fdout, FILE *fdin, unsigned int size);
void std_err(void);
void io_err(void);



struct head {
    unsigned int   sign;
    unsigned int   tot;
    unsigned int   filezoff;
    unsigned int   boh;
    unsigned char   author[20];
} head;



struct filez {
    unsigned char   fname[16];
    unsigned int   len;
    unsigned int   off;
} filez;



int main(int argc, char *argv[]) {
    FILE            *fd,
                    *fddata,
                    *fdout;
    unsigned int   i;
    int             err;



    setbuf(stdout, NULL);

    fputs("\n"
        "Race Driver BIG extractor "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\nUsage: %s <file.BIG> <destination_directory>\n",
            argv[0]);
        exit(1);
    }

    fd = fopen(argv[1], "rb");
    if(!fd) std_err();
    fddata = fopen(argv[1], "rb");
    if(!fddata) std_err();


    err = fread(&head, sizeof(head), 1, fd);
    if(err != 1) io_err();

    if(head.sign != 0x46474942) {
        fputs("\nError: the file is not a valid BIG file\n", stdout);
        exit(1);
    }

    printf("\n"
        "Total files:     %u\n"
        "Starting offset: 0x%08x\n"
        "Author:          %.20s\n",
        head.tot,
        head.filezoff,
        head.author);


    err = fseek(fddata, head.filezoff, SEEK_SET);
    if(err < 0) std_err();


    printf("\nChanging dir: %s\n", argv[2]);
    err = chdir(argv[2]);
    if(err < 0) std_err();


    for(i = 0; i < head.tot; i++) {
        err = fread(&filez, sizeof(filez), 1, fd);
        if(err != 1) io_err();


        printf("%.16s\n", filez.fname);

        fdout = fopen(filez.fname, "wb");
        if(!fdout) std_err();

        err = fseek(fddata, filez.off + head.filezoff, SEEK_SET);
        if(err < 0) std_err();

        if(filez.len) filecopy(fdout, fddata, filez.len);

        fclose(fdout);
    }

    fclose(fd);
    fclose(fddata);

    return(0);
}



void filecopy(FILE *fdout, FILE *fdin, unsigned int size) {
    unsigned char   *buff;
    int             err;
    unsigned int   len;

    buff = alloca(BUFFSZ);
    if(!buff) std_err();

    len = BUFFSZ;
    do {
        if(len > size) len = size;

        err = fread(buff, len, 1, fdin);
        if(err != 1) io_err();

        err = fwrite(buff, len, 1, fdout);
        if(err != 1) io_err();

        size -= len;
    } while(size);
}



void std_err(void) {
    perror("\nError");
    exit(1);
}



void io_err(void) {
    fputs("\nError: I/O error, the file is incomplete or the disk space is finished\n", stdout);
    exit(1);
}



