/*

    Copyright 2004,2005,2006 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl.txt

*/

#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>



#define VER     "0.1"



typedef unsigned char   u_char;



void speed_challenge_filedec(u_char *data, int size);
void std_err(void);



int main(int argc, char *argv[]) {
    FILE    *fd,
            *fdout;
    u_char  *buff;
    struct  stat    xstat;


    setbuf(stdout, NULL);

    fputs("\n"
        "Speed Challenge files decoder "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <input_file> <output_file>\n"
            "\n"
            "Note: decoded files works perfectly and are accepted by the game,\n"
            "      that's why is not needed to re-encode them.\n"
            "\n", argv[0]);
        exit(1);
    }

    printf("- Open input file:    %s\n", argv[1]);
    fd = fopen(argv[1], "rb");
    if(!fd) std_err();

    printf("- Open output file:   %s\n", argv[2]);
    fdout = fopen(argv[2], "wb");
    if(!fdout) std_err();

    fstat(fileno(fd), &xstat);
    printf("- Allocating %u bytes for the decoding\n", xstat.st_size);
    buff = malloc(xstat.st_size + 1);
    if(!buff) std_err();

    fread(buff, xstat.st_size, 1, fd);
    fclose(fd);

    if(*buff != 0xae) {
        fputs("\n"
            "Error: the input file is not a Speed Challenge encoded file\n"
            "\n", stdout);
        exit(1);
    }

    speed_challenge_filedec(buff, xstat.st_size);

    fwrite(buff, xstat.st_size - 2, 1, fdout);
    fclose(fdout);

    fputs("- finished\n", stdout);

    return(0);
}



void speed_challenge_filedec(u_char *data, int size) {
    int     i;
    const static u_char
            enc1[] =
            "\x27\xF4\x94\x50\x33\x73\x67\x21\x27\xAA\xCD\x0D\x47\xD9\xD5\x78"
            "\xBE\x90\x9E\x94\x3F\xC3\x1A\x1E\xED\x20\x12\x48\x78",
            enc2[] =
            "\xF5\x11\xD7\x25\x8D\xCB\x5B\xBE\x8D\xAA\x67\xE4\x84\xCC\x2F\x44"
            "\x7B\xE5\x25\xDB\x88\x86\x28\x5D\xA0\xA0\xF8\xD8\xAD\x44\xEE\x94"
            "\xE0\xAC\xEA\x3F\x49\x7F\x8C",
            enc3[] =
            "\xCF\x20\x3A\xF7\x12\x7E\xF1\x9F\xF1\x9A\xB1\x6B\xAC\x48\x4A\xF8"
            "\x41\x1F\x47\xB4\x2F\x2D\xD1\x37\x7F\xEA\xD1\xD7\x05\x6B\x55\x76"
            "\xE4\xD8\x35\x9F\x50\x20\xF6\xD2\x98";
    u_char  *out;

    out = data;
    data += 2;
    size--;
    for(i = 0; i < size; i++) {
        *out++ = (((*data ^ *(data - 1)) ^ enc3[i % 41]) ^ enc2[i % 39]) ^ enc1[i % 29];
        data++;
    }
}



void std_err(void) {
    perror("\nError");
    exit(1);
}
