/*
    Copyright 2005,2006 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl.txt
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "speed_challenge_net.h"
#include "show_dump.h"

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>
#endif



#define VER         "0.1"
#define BUFFSZ      65536



int letsdoit(speed_challenge_net_context *ctx, int in, int out);
u_int resolv(char *host);
void std_err(void);



FILE    *fdlog;



int main(int argc, char *argv[]) {
    speed_challenge_net_context sc_server,
                                sc_client;
    struct  sockaddr_in peer,
                        peerl;
    fd_set  readset;
    int     sd,
            sdl,
            sda,
            bigsock,
            on = 1,
            psz,
            i;
    u_short port,
            localport;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif


    setbuf(stdout, NULL);

    fputs("\n"
        "Speed Challenge proxy data decrypter "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 4) {
        printf("\n"
            "Usage: %s [options] <server> <server_port> <local_port>\n"
            "\n"
            "Options:\n"
            "-d FILE   all the decoded data will be stored (appended) in the file FILE\n"
            "          instead of showed on the screen, ever in hex format\n"
            "\n"
            "How to use:\n"
            "1) launch this tool specifying the server in which you wanna join and the\n"
            "   ports to use, the game usually uses the ports 19800 or 18800 or 18797\n"
            "   so you can use this tool on multiple ports if you need\n"
            "2) open your game client\n"
            "3) connect your client to localhost on the port specified by local_port\n"
            "\n", argv[0]);
        exit(1);
    }

    fdlog = stdout;

    argc -= 3;
    for(i = 1; i < argc; i++) {
        switch(argv[i][1]) {
            case 'd': {
                i++;
                printf("- open log file %s\n", argv[i]);
                fdlog = fopen(argv[i], "ab");
                if(!fdlog) std_err();
                } break;
            default: {
                printf("\nError: wrong command-line argument (%s)\n\n", argv[i]);
                exit(1);
                } break;
        }
    }

    port = atoi(argv[argc + 1]);
    localport = atoi(argv[argc + 2]);

    peer.sin_addr.s_addr = resolv(argv[argc]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n",
        inet_ntoa(peer.sin_addr), port);

    printf("- set local proxy on port %d\n",
        localport);

    peerl.sin_addr.s_addr = INADDR_ANY;
    peerl.sin_port        = htons(localport);
    peerl.sin_family      = AF_INET;
    psz                   = sizeof(peerl);

    sdl = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sdl < 0) std_err();
    if(setsockopt(sdl, SOL_SOCKET, SO_REUSEADDR, (char *)&on, sizeof(on))
      < 0) std_err();
    if(bind(sdl, (struct sockaddr *)&peerl, sizeof(peerl))
      < 0) std_err();
    if(listen(sdl, 1)
      < 0) std_err();

    printf(
        "- Proxy enabled\n"
        "- Connect your client to localhost on port %d\n"
        "  (only one client at time is allowed)\n"
        "\n", localport);

    for(;;) {
        sda = accept(sdl, (struct sockaddr *)&peerl, &psz);
        if(sda < 0) std_err();

        fprintf(
            fdlog,
            "- client:    %s : %d\n",
            inet_ntoa(peerl.sin_addr),
            ntohs(peerl.sin_port));

        sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
        if(sd < 0) std_err();
        if(connect(sd, (struct sockaddr *)&peer, sizeof(peer))
          < 0) std_err();

        if(sd > sda) bigsock = sd + 1;
            else bigsock = sda + 1;

        speed_challenge_net_init(&sc_client);
        speed_challenge_net_init(&sc_server);

        for(;;) {
            FD_ZERO(&readset);
            FD_SET(sda, &readset);
            FD_SET(sd, &readset);
            if(select(bigsock, &readset, NULL, NULL, NULL)
              < 0) std_err();

            if(FD_ISSET(sd, &readset)) {            // from server
                fputs("    ### SERVER ###\n", fdlog);
                if(letsdoit(&sc_server, sd, sda) < 0) break;

            } else if(FD_ISSET(sda, &readset)) {    // from client
                fputs("    ### CLIENT ###\n", fdlog);
                if(letsdoit(&sc_client, sda, sd) < 0) break;
            }
        }

        shutdown(sda, 2);
        shutdown(sd, 2);
        close(sda);
        close(sd);
        fputs("- disconnected\n", fdlog);
    }

    close(sdl);
    return(0);
}



int letsdoit(speed_challenge_net_context *ctx, int in, int out) {
    int     tmp;
    u_short i,
            len;
    static u_char   buff[BUFFSZ];

    recv(in, (void *)&len, 1, 0);
    recv(in, (void *)&len + 1, 1, 0);
    if(send(out, (void *)&len, 2, 0)
      < 0) return(-1);

    len = ntohs(len) - 2;

    for(i = 0; i < len; i += tmp) {
        tmp = recv(in, buff + i, len - i, 0);
        if(tmp <= 0) return(-1);
    }
    if(send(out, buff, len, 0)
      < 0) return(-1);

    speed_challenge_net_decode(ctx, buff, len);

    show_dump(buff, len, fdlog);
    fflush(fdlog);
    return(0);
}



u_int resolv(char *host) {
    struct  hostent *hp;
    u_int  host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u_int *)(hp->h_addr);
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


