/*

Speed Challenge network encryption/decryption algorithm 0.2
by Luigi Auriemma
e-mail: aluigi@autistici.org
web:    aluigi.org

    Copyright 2004,2005,2006 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl.txt

*/



//#include <string.h>
#include "speed_challenge_net.h"



const static unsigned char
    X4d4638[] =
        "\xF7\xA9\x66\x11\xE1\x10\xEC\xC6\x7B\x67\x6A\xD4\x4B\x67\x38\xDA"
        "\x98\x38\xEC\x3A\x95\x82\xDD\x5A\xEA\x86\x28\x53\xD8\x02\x1E\x67"
        "\x24\x4F\xB9\xF7\x6E",
    X4d4660[] =
        "\x9B\x48\xE9\xD2\xE4\xF9\x86\x60\xB0\x95\x13\x67\x9D\x3E\x70\x8E"
        "\xD2\x77\xC3\xF8\x2E\x2A\x8D\x61\x57\x69\xF3\xB9\xC8\x4F\x30\xA0"
        "\x52\xC9\x84\x16\x2D\xCE\xC3\x2F\x99",
    X4d468c[] =
        "\xF1\xB2\xCD\x0E\x16\xA8\x5F\x2C\xC7\xF2\x15\x69\x17\x09\xC2\x20"
        "\xA1\x82\xC3\x8F\x3B\x56\x46\x54\x2F\xFB\x3D\xD0\x58\x94\xE2\xEA"
        "\x5C\xCD\x80\xC7\xEF\x9E\x3B\x91\xC4\xBB\xBC\x3B\xAE\xC6\x01",
    X4d46bc[] =
        "\xEB\xA5\x39\xBB\x84\x30\x97\xA4\xDB\x19\xD6\xBB\xAA\x2B\xDD\x64"
        "\xB5\x47\xF1\x90\xA8\xF9\xA5\xC2\x79\x51\xDE\x59\xDB\xF8\x2E\xAA"
        "\x16\x6C\x76\x14\xDA\xBA\xFB\x9E\x20\xC9\x64\x67\x95\xD5\xEF\xE9"
        "\x15\xE4\x3D\x9D\xAF",
    X4d46f4[] =
        "\x74\xD0\xD7\x3B\xC5\x2D\xFA\xB2\x19\xFC\x4A\x77\xFB\xE8\x53\x20"
        "\x35\x1D\xAB\x73\x99\x9F\x61\x2E\x58\x25\x15\x1C\x10\x00\x62\x72"
        "\x9A\x46\xCA\x45\x64\xE3\xC5\xA0\x59\xCE\xA4",
    X4d4720[] =
        "\x52\x7A\x88\x4B\x39\x64\xB2\x54\x61\x19\x24\x5F\x9B\xBE\x6B\x6E"
        "\xC6\xB8\x10\xA7\xD7\xAA\x22\xBC\xD3\xEA\xF9\x3E\x52\x5D\xC9\x17"
        "\x11\xCF\x20\x56\x4C\xE6\x53\xD4\x0B\xD7\xB2\x76\x63\x1E\xF3\x86"
        "\x91",
    X4d4754[] =
        "\x4D\x7F\xDB\x4C\xC8\x62\x82\x7B\xA1\x1F\xBB\x82\x91\x78\x42\x0D"
        "\x3C\xF6\x45\x65\xFA\x32\x10\xE7\x93\xD0\x4C\xED\x38\x0C\x3B\xA1"
        "\x42\x9D\x19\xBA\x60\x1C\xD9\x64\x7A\x83\x10\x41\x3F\xD5\x1E\x6A"
        "\xB4\xF8\x31",
    X4d4788[] =
        "\x53\x7C\xC9\x16\x6C\xB3\x8A\xE1\x1E\xA7\x02\x6F\xDE\xE0\x0D\xC6"
        "\x50\x2D\x13\xB5\x37\x0A\x42\x0A\x48\x90\xF6\xB2\x2A\xD2\x07\x23"
        "\x3B\xA3\x05\xEF\x09\xD5\x6D\x53\x33\x92\xDA\x31\xFC\xA0\xB0\x53"
        "\x29\x46\x8C\x5B\xF3\x21\x23",
    encbyte[] =
        "\x02\x03\x00\x01\x06\x07\x04\x05\x02\x03\x00\x05\x06\x07\x01\x04"
        "\x02\x03\x00\x05\x06\x07\x04\x01\x02\x03\x00\x06\x01\x07\x04\x05"
        "\x02\x03\x00\x06\x07\x01\x04\x05\x02\x03\x00\x07\x06\x01\x04\x05"
        "\x02\x03\x04\x00\x06\x07\x01\x05\x02\x03\x04\x01\x06\x07\x00\x05"
        "\x02\x03\x04\x05\x06\x07\x00\x01\x02\x03\x04\x06\x00\x07\x01\x05"
        "\x02\x03\x04\x06\x01\x07\x00\x05\x02\x03\x04\x06\x07\x00\x01\x05"
        "\x02\x03\x04\x06\x07\x01\x00\x05\x02\x03\x04\x07\x06\x00\x01\x05"
        "\x02\x03\x04\x07\x06\x01\x00\x05\x02\x03\x05\x00\x06\x07\x01\x04"
        "\x02\x03\x05\x00\x06\x07\x04\x01\x02\x03\x05\x01\x06\x07\x00\x04"
        "\x02\x03\x05\x06\x00\x07\x01\x04\x02\x03\x05\x06\x00\x07\x04\x01"
        "\x02\x03\x05\x06\x01\x07\x00\x04\x02\x03\x05\x06\x07\x00\x01\x04"
        "\x02\x03\x05\x06\x07\x00\x04\x01\x02\x03\x05\x06\x07\x01\x00\x04"
        "\x02\x03\x05\x07\x06\x00\x01\x04\x02\x03\x05\x07\x06\x00\x04\x01"
        "\x02\x03\x05\x07\x06\x01\x00\x04\x02\x03\x06\x00\x01\x07\x04\x05"
        "\x02\x03\x06\x00\x07\x01\x04\x05\x02\x03\x06\x01\x00\x07\x04\x05"
        "\x02\x03\x06\x01\x07\x00\x04\x05\x02\x03\x06\x05\x00\x07\x01\x04"
        "\x02\x03\x06\x05\x00\x07\x04\x01\x02\x03\x06\x05\x01\x07\x00\x04"
        "\x02\x03\x06\x05\x07\x00\x01\x04\x02\x03\x06\x05\x07\x00\x04\x01"
        "\x02\x03\x06\x05\x07\x01\x00\x04\x02\x03\x06\x07\x00\x01\x04\x05"
        "\x02\x03\x06\x07\x01\x00\x04\x05\x02\x03\x07\x00\x06\x01\x04\x05"
        "\x02\x03\x07\x01\x06\x00\x04\x05\x02\x03\x07\x05\x06\x00\x01\x04"
        "\x02\x03\x07\x05\x06\x00\x04\x01\x02\x03\x07\x05\x06\x01\x00\x04"
        "\x02\x03\x07\x06\x00\x01\x04\x05\x02\x03\x07\x06\x01\x00\x04\x05"
        "\x02\x04\x00\x01\x06\x07\x03\x05\x02\x04\x00\x05\x06\x07\x01\x03"
        "\x02\x04\x00\x05\x06\x07\x03\x01\x02\x04\x00\x06\x01\x07\x03\x05"
        "\x02\x04\x00\x06\x07\x01\x03\x05\x02\x04\x00\x06\x07\x03\x01\x05"
        "\x02\x04\x00\x07\x06\x01\x03\x05\x02\x04\x00\x07\x06\x03\x01\x05"
        "\x02\x04\x05\x00\x06\x07\x01\x03\x02\x04\x05\x00\x06\x07\x03\x01"
        "\x02\x04\x05\x01\x06\x07\x00\x03\x02\x04\x05\x06\x00\x07\x01\x03"
        "\x02\x04\x05\x06\x00\x07\x03\x01\x02\x04\x05\x06\x01\x07\x00\x03"
        "\x02\x04\x05\x06\x07\x00\x01\x03\x02\x04\x05\x06\x07\x00\x03\x01"
        "\x02\x04\x05\x06\x07\x01\x00\x03\x02\x04\x05\x06\x07\x03\x00\x01"
        "\x02\x04\x05\x07\x06\x00\x01\x03\x02\x04\x05\x07\x06\x00\x03\x01"
        "\x02\x04\x05\x07\x06\x01\x00\x03\x02\x04\x05\x07\x06\x03\x00\x01"
        "\x02\x04\x06\x00\x01\x07\x03\x05\x02\x04\x06\x00\x07\x01\x03\x05"
        "\x02\x04\x06\x00\x07\x03\x01\x05\x02\x04\x06\x01\x00\x07\x03\x05"
        "\x02\x04\x06\x01\x07\x00\x03\x05\x02\x04\x06\x01\x07\x03\x00\x05"
        "\x02\x04\x06\x05\x00\x07\x01\x03\x02\x04\x06\x05\x00\x07\x03\x01"
        "\x02\x04\x06\x05\x01\x07\x00\x03\x02\x04\x06\x05\x07\x00\x01\x03"
        "\x02\x04\x06\x05\x07\x00\x03\x01\x02\x04\x06\x05\x07\x01\x00\x03"
        "\x02\x04\x06\x05\x07\x03\x00\x01\x02\x04\x06\x07\x00\x01\x03\x05"
        "\x02\x04\x06\x07\x00\x03\x01\x05\x02\x04\x06\x07\x01\x00\x03\x05"
        "\x02\x04\x06\x07\x01\x03\x00\x05\x02\x04\x07\x00\x06\x01\x03\x05"
        "\x02\x04\x07\x00\x06\x03\x01\x05\x02\x04\x07\x01\x06\x00\x03\x05"
        "\x02\x04\x07\x01\x06\x03\x00\x05\x02\x04\x07\x05\x06\x00\x01\x03"
        "\x02\x04\x07\x05\x06\x00\x03\x01\x02\x04\x07\x05\x06\x01\x00\x03"
        "\x02\x04\x07\x05\x06\x03\x00\x01\x02\x04\x07\x06\x00\x01\x03\x05"
        "\x02\x04\x07\x06\x00\x03\x01\x05\x02\x04\x07\x06\x01\x00\x03\x05"
        "\x02\x04\x07\x06\x01\x03\x00\x05\x02\x05\x00\x01\x06\x07\x03\x04"
        "\x02\x05\x00\x01\x06\x07\x04\x03\x02\x05\x00\x06\x01\x07\x03\x04"
        "\x02\x05\x00\x06\x01\x07\x04\x03\x02\x05\x00\x06\x07\x01\x03\x04"
        "\x02\x05\x00\x06\x07\x01\x04\x03\x02\x05\x00\x06\x07\x03\x01\x04"
        "\x02\x05\x00\x06\x07\x03\x04\x01\x02\x05\x00\x07\x06\x01\x03\x04"
        "\x02\x05\x00\x07\x06\x01\x04\x03\x02\x05\x00\x07\x06\x03\x01\x04"
        "\x02\x05\x00\x07\x06\x03\x04\x01\x02\x05\x04\x00\x06\x07\x01\x03"
        "\x02\x05\x04\x00\x06\x07\x03\x01\x02\x05\x04\x01\x06\x07\x00\x03"
        "\x02\x05\x04\x06\x00\x07\x01\x03\x02\x05\x04\x06\x00\x07\x03\x01"
        "\x02\x05\x04\x06\x01\x07\x00\x03\x02\x05\x04\x06\x07\x00\x01\x03"
        "\x02\x05\x04\x06\x07\x00\x03\x01\x02\x05\x04\x06\x07\x01\x00\x03"
        "\x02\x05\x04\x06\x07\x03\x00\x01\x02\x05\x04\x07\x06\x00\x01\x03"
        "\x02\x05\x04\x07\x06\x00\x03\x01\x02\x05\x04\x07\x06\x01\x00\x03"
        "\x02\x05\x04\x07\x06\x03\x00\x01\x02\x05\x06\x00\x01\x07\x03\x04"
        "\x02\x05\x06\x00\x01\x07\x04\x03\x02\x05\x06\x00\x07\x01\x03\x04"
        "\x02\x05\x06\x00\x07\x01\x04\x03\x02\x05\x06\x00\x07\x03\x01\x04"
        "\x02\x05\x06\x00\x07\x03\x04\x01\x02\x05\x06\x01\x00\x07\x03\x04"
        "\x02\x05\x06\x01\x00\x07\x04\x03\x02\x05\x06\x01\x07\x00\x03\x04"
        "\x02\x05\x06\x01\x07\x00\x04\x03\x02\x05\x06\x01\x07\x03\x00\x04"
        "\x02\x05\x06\x07\x00\x01\x03\x04\x02\x05\x06\x07\x00\x01\x04\x03"
        "\x02\x05\x06\x07\x00\x03\x01\x04\x02\x05\x06\x07\x00\x03\x04\x01"
        "\x02\x05\x06\x07\x01\x00\x03\x04\x02\x05\x06\x07\x01\x00\x04\x03"
        "\x02\x05\x06\x07\x01\x03\x00\x04\x02\x05\x07\x00\x06\x01\x03\x04"
        "\x02\x05\x07\x00\x06\x01\x04\x03\x02\x05\x07\x00\x06\x03\x01\x04"
        "\x02\x05\x07\x00\x06\x03\x04\x01\x02\x05\x07\x01\x06\x00\x03\x04"
        "\x02\x05\x07\x01\x06\x00\x04\x03\x02\x05\x07\x01\x06\x03\x00\x04"
        "\x02\x05\x07\x06\x00\x01\x03\x04\x02\x05\x07\x06\x00\x01\x04\x03"
        "\x02\x05\x07\x06\x00\x03\x01\x04\x02\x05\x07\x06\x00\x03\x04\x01"
        "\x02\x05\x07\x06\x01\x00\x03\x04\x02\x05\x07\x06\x01\x00\x04\x03"
        "\x02\x05\x07\x06\x01\x03\x00\x04\x02\x06\x00\x01\x07\x03\x04\x05"
        "\x02\x06\x00\x05\x01\x07\x03\x04\x02\x06\x00\x05\x01\x07\x04\x03"
        "\x02\x06\x00\x05\x07\x01\x03\x04\x02\x06\x00\x05\x07\x01\x04\x03"
        "\x02\x06\x00\x05\x07\x03\x01\x04\x02\x06\x00\x05\x07\x03\x04\x01"
        "\x02\x06\x00\x07\x01\x03\x04\x05\x02\x06\x04\x00\x01\x07\x03\x05"
        "\x02\x06\x04\x00\x07\x01\x03\x05\x02\x06\x04\x00\x07\x03\x01\x05"
        "\x02\x06\x04\x01\x00\x07\x03\x05\x02\x06\x04\x01\x07\x00\x03\x05"
        "\x02\x06\x04\x01\x07\x03\x00\x05\x02\x06\x04\x05\x00\x07\x01\x03"
        "\x02\x06\x04\x05\x00\x07\x03\x01\x02\x06\x04\x05\x01\x07\x00\x03"
        "\x02\x06\x04\x05\x07\x00\x01\x03\x02\x06\x04\x05\x07\x00\x03\x01"
        "\x02\x06\x04\x05\x07\x01\x00\x03\x02\x06\x04\x05\x07\x03\x00\x01"
        "\x02\x06\x04\x07\x00\x01\x03\x05\x02\x06\x04\x07\x00\x03\x01\x05"
        "\x02\x06\x04\x07\x01\x00\x03\x05\x02\x06\x04\x07\x01\x03\x00\x05"
        "\x02\x06\x05\x00\x01\x07\x03\x04\x02\x06\x05\x00\x01\x07\x04\x03"
        "\x02\x06\x05\x00\x07\x01\x03\x04\x02\x06\x05\x00\x07\x01\x04\x03"
        "\x02\x06\x05\x00\x07\x03\x01\x04\x02\x06\x05\x00\x07\x03\x04\x01"
        "\x02\x06\x05\x01\x00\x07\x03\x04\x02\x06\x05\x01\x00\x07\x04\x03"
        "\x02\x06\x05\x01\x07\x00\x03\x04\x02\x06\x05\x01\x07\x00\x04\x03"
        "\x02\x06\x05\x01\x07\x03\x00\x04\x02\x06\x05\x07\x00\x01\x03\x04"
        "\x02\x06\x05\x07\x00\x01\x04\x03\x02\x06\x05\x07\x00\x03\x01\x04"
        "\x02\x06\x05\x07\x00\x03\x04\x01\x02\x06\x05\x07\x01\x00\x03\x04"
        "\x02\x06\x05\x07\x01\x00\x04\x03\x02\x06\x05\x07\x01\x03\x00\x04"
        "\x02\x06\x07\x00\x01\x03\x04\x05\x02\x06\x07\x01\x00\x03\x04\x05"
        "\x02\x06\x07\x05\x00\x01\x03\x04\x02\x06\x07\x05\x00\x01\x04\x03"
        "\x02\x06\x07\x05\x00\x03\x01\x04\x02\x06\x07\x05\x00\x03\x04\x01"
        "\x02\x06\x07\x05\x01\x00\x03\x04\x02\x06\x07\x05\x01\x00\x04\x03"
        "\x02\x06\x07\x05\x01\x03\x00\x04\x02\x07\x00\x01\x06\x03\x04\x05"
        "\x02\x07\x00\x05\x06\x01\x03\x04\x02\x07\x00\x05\x06\x01\x04\x03"
        "\x02\x07\x00\x05\x06\x03\x01\x04\x02\x07\x00\x05\x06\x03\x04\x01"
        "\x02\x07\x00\x06\x01\x03\x04\x05\x02\x07\x04\x00\x06\x01\x03\x05"
        "\x02\x07\x04\x00\x06\x03\x01\x05\x02\x07\x04\x01\x06\x00\x03\x05"
        "\x02\x07\x04\x01\x06\x03\x00\x05\x02\x07\x04\x05\x06\x00\x01\x03"
        "\x02\x07\x04\x05\x06\x00\x03\x01\x02\x07\x04\x05\x06\x01\x00\x03"
        "\x02\x07\x04\x05\x06\x03\x00\x01\x02\x07\x04\x06\x00\x01\x03\x05"
        "\x02\x07\x04\x06\x00\x03\x01\x05\x02\x07\x04\x06\x01\x00\x03\x05"
        "\x02\x07\x04\x06\x01\x03\x00\x05\x02\x07\x05\x00\x06\x01\x03\x04"
        "\x02\x07\x05\x00\x06\x01\x04\x03\x02\x07\x05\x00\x06\x03\x01\x04"
        "\x02\x07\x05\x00\x06\x03\x04\x01\x02\x07\x05\x01\x06\x00\x03\x04"
        "\x02\x07\x05\x01\x06\x00\x04\x03\x02\x07\x05\x01\x06\x03\x00\x04"
        "\x02\x07\x05\x06\x00\x01\x03\x04\x02\x07\x05\x06\x00\x01\x04\x03"
        "\x02\x07\x05\x06\x00\x03\x01\x04\x02\x07\x05\x06\x00\x03\x04\x01"
        "\x02\x07\x05\x06\x01\x00\x03\x04\x02\x07\x05\x06\x01\x00\x04\x03"
        "\x02\x07\x05\x06\x01\x03\x00\x04\x02\x07\x06\x00\x01\x03\x04\x05"
        "\x02\x07\x06\x01\x00\x03\x04\x05\x02\x07\x06\x05\x00\x01\x03\x04"
        "\x02\x07\x06\x05\x00\x01\x04\x03\x02\x07\x06\x05\x00\x03\x01\x04"
        "\x02\x07\x06\x05\x00\x03\x04\x01\x02\x07\x06\x05\x01\x00\x03\x04"
        "\x02\x07\x06\x05\x01\x00\x04\x03\x02\x07\x06\x05\x01\x03\x00\x04"
        "\x03\x04\x00\x01\x06\x07\x02\x05\x03\x04\x00\x05\x06\x07\x01\x02"
        "\x03\x04\x00\x05\x06\x07\x02\x01\x03\x04\x00\x06\x01\x07\x02\x05"
        "\x03\x04\x00\x06\x02\x07\x01\x05\x03\x04\x00\x06\x07\x01\x02\x05"
        "\x03\x04\x00\x06\x07\x02\x01\x05\x03\x04\x00\x07\x06\x01\x02\x05"
        "\x03\x04\x00\x07\x06\x02\x01\x05\x03\x04\x05\x00\x06\x07\x01\x02"
        "\x03\x04\x05\x00\x06\x07\x02\x01\x03\x04\x05\x01\x06\x07\x00\x02"
        "\x03\x04\x05\x06\x00\x07\x01\x02\x03\x04\x05\x06\x00\x07\x02\x01"
        "\x03\x04\x05\x06\x01\x07\x00\x02\x03\x04\x05\x06\x02\x07\x00\x01"
        "\x03\x04\x05\x06\x07\x00\x01\x02\x03\x04\x05\x06\x07\x00\x02\x01"
        "\x03\x04\x05\x06\x07\x01\x00\x02\x03\x04\x05\x06\x07\x02\x00\x01"
        "\x03\x04\x05\x07\x06\x00\x01\x02\x03\x04\x05\x07\x06\x00\x02\x01"
        "\x03\x04\x05\x07\x06\x01\x00\x02\x03\x04\x05\x07\x06\x02\x00\x01"
        "\x03\x04\x06\x00\x01\x07\x02\x05\x03\x04\x06\x00\x02\x07\x01\x05"
        "\x03\x04\x06\x00\x07\x01\x02\x05\x03\x04\x06\x00\x07\x02\x01\x05"
        "\x03\x04\x06\x01\x00\x07\x02\x05\x03\x04\x06\x01\x02\x07\x00\x05"
        "\x03\x04\x06\x01\x07\x00\x02\x05\x03\x04\x06\x01\x07\x02\x00\x05"
        "\x03\x04\x06\x05\x00\x07\x01\x02\x03\x04\x06\x05\x00\x07\x02\x01"
        "\x03\x04\x06\x05\x01\x07\x00\x02\x03\x04\x06\x05\x02\x07\x00\x01"
        "\x03\x04\x06\x05\x07\x00\x01\x02\x03\x04\x06\x05\x07\x00\x02\x01"
        "\x03\x04\x06\x05\x07\x01\x00\x02\x03\x04\x06\x05\x07\x02\x00\x01"
        "\x03\x04\x06\x07\x00\x01\x02\x05\x03\x04\x06\x07\x00\x02\x01\x05"
        "\x03\x04\x06\x07\x01\x00\x02\x05\x03\x04\x06\x07\x01\x02\x00\x05"
        "\x03\x04\x06\x07\x02\x00\x01\x05\x03\x04\x06\x07\x02\x01\x00\x05"
        "\x03\x04\x07\x00\x06\x01\x02\x05\x03\x04\x07\x00\x06\x02\x01\x05"
        "\x03\x04\x07\x01\x06\x00\x02\x05\x03\x04\x07\x01\x06\x02\x00\x05"
        "\x03\x04\x07\x05\x06\x00\x01\x02\x03\x04\x07\x05\x06\x00\x02\x01"
        "\x03\x04\x07\x05\x06\x01\x00\x02\x03\x04\x07\x05\x06\x02\x00\x01"
        "\x03\x04\x07\x06\x00\x01\x02\x05\x03\x04\x07\x06\x00\x02\x01\x05"
        "\x03\x04\x07\x06\x01\x00\x02\x05\x03\x04\x07\x06\x01\x02\x00\x05"
        "\x03\x04\x07\x06\x02\x00\x01\x05\x03\x04\x07\x06\x02\x01\x00\x05"
        "\x03\x05\x00\x01\x06\x07\x02\x04\x03\x05\x00\x01\x06\x07\x04\x02"
        "\x03\x05\x00\x06\x01\x07\x02\x04\x03\x05\x00\x06\x01\x07\x04\x02"
        "\x03\x05\x00\x06\x02\x07\x01\x04\x03\x05\x00\x06\x02\x07\x04\x01"
        "\x03\x05\x00\x06\x07\x01\x02\x04\x03\x05\x00\x06\x07\x01\x04\x02"
        "\x03\x05\x00\x06\x07\x02\x01\x04\x03\x05\x00\x06\x07\x02\x04\x01"
        "\x03\x05\x00\x07\x06\x01\x02\x04\x03\x05\x00\x07\x06\x01\x04\x02"
        "\x03\x05\x00\x07\x06\x02\x01\x04\x03\x05\x00\x07\x06\x02\x04\x01"
        "\x03\x05\x04\x00\x06\x07\x01\x02\x03\x05\x04\x00\x06\x07\x02\x01"
        "\x03\x05\x04\x01\x06\x07\x00\x02\x03\x05\x04\x06\x00\x07\x01\x02"
        "\x03\x05\x04\x06\x00\x07\x02\x01\x03\x05\x04\x06\x01\x07\x00\x02"
        "\x03\x05\x04\x06\x02\x07\x00\x01\x03\x05\x04\x06\x07\x00\x01\x02"
        "\x03\x05\x04\x06\x07\x00\x02\x01\x03\x05\x04\x06\x07\x01\x00\x02"
        "\x03\x05\x04\x06\x07\x02\x00\x01\x03\x05\x04\x07\x06\x00\x01\x02"
        "\x03\x05\x04\x07\x06\x00\x02\x01\x03\x05\x04\x07\x06\x01\x00\x02"
        "\x03\x05\x04\x07\x06\x02\x00\x01\x03\x05\x06\x00\x01\x07\x02\x04"
        "\x03\x05\x06\x00\x01\x07\x04\x02\x03\x05\x06\x00\x02\x07\x01\x04"
        "\x03\x05\x06\x00\x02\x07\x04\x01\x03\x05\x06\x00\x07\x01\x02\x04"
        "\x03\x05\x06\x00\x07\x01\x04\x02\x03\x05\x06\x00\x07\x02\x01\x04"
        "\x03\x05\x06\x00\x07\x02\x04\x01\x03\x05\x06\x01\x00\x07\x02\x04"
        "\x03\x05\x06\x01\x00\x07\x04\x02\x03\x05\x06\x01\x02\x07\x00\x04"
        "\x03\x05\x06\x01\x07\x00\x02\x04\x03\x05\x06\x01\x07\x00\x04\x02"
        "\x03\x05\x06\x01\x07\x02\x00\x04\x03\x05\x06\x07\x00\x01\x02\x04"
        "\x03\x05\x06\x07\x00\x01\x04\x02\x03\x05\x06\x07\x00\x02\x01\x04"
        "\x03\x05\x06\x07\x00\x02\x04\x01\x03\x05\x06\x07\x01\x00\x02\x04"
        "\x03\x05\x06\x07\x01\x00\x04\x02\x03\x05\x06\x07\x01\x02\x00\x04"
        "\x03\x05\x06\x07\x02\x00\x01\x04\x03\x05\x06\x07\x02\x00\x04\x01"
        "\x03\x05\x06\x07\x02\x01\x00\x04\x03\x05\x07\x00\x06\x01\x02\x04"
        "\x03\x05\x07\x00\x06\x01\x04\x02\x03\x05\x07\x00\x06\x02\x01\x04"
        "\x03\x05\x07\x00\x06\x02\x04\x01\x03\x05\x07\x01\x06\x00\x02\x04"
        "\x03\x05\x07\x01\x06\x00\x04\x02\x03\x05\x07\x01\x06\x02\x00\x04"
        "\x03\x05\x07\x06\x00\x01\x02\x04\x03\x05\x07\x06\x00\x01\x04\x02"
        "\x03\x05\x07\x06\x00\x02\x01\x04\x03\x05\x07\x06\x00\x02\x04\x01"
        "\x03\x05\x07\x06\x01\x00\x02\x04\x03\x05\x07\x06\x01\x00\x04\x02"
        "\x03\x05\x07\x06\x01\x02\x00\x04\x03\x05\x07\x06\x02\x00\x01\x04"
        "\x03\x05\x07\x06\x02\x00\x04\x01\x03\x05\x07\x06\x02\x01\x00\x04"
        "\x03\x06\x00\x01\x02\x07\x04\x05\x03\x06\x00\x01\x07\x02\x04\x05"
        "\x03\x06\x00\x05\x01\x07\x02\x04\x03\x06\x00\x05\x01\x07\x04\x02"
        "\x03\x06\x00\x05\x02\x07\x01\x04\x03\x06\x00\x05\x02\x07\x04\x01"
        "\x03\x06\x00\x05\x07\x01\x02\x04\x03\x06\x00\x05\x07\x01\x04\x02"
        "\x03\x06\x00\x05\x07\x02\x01\x04\x03\x06\x00\x05\x07\x02\x04\x01"
        "\x03\x06\x00\x07\x01\x02\x04\x05\x03\x06\x00\x07\x02\x01\x04\x05"
        "\x03\x06\x04\x00\x01\x07\x02\x05\x03\x06\x04\x00\x02\x07\x01\x05"
        "\x03\x06\x04\x00\x07\x01\x02\x05\x03\x06\x04\x00\x07\x02\x01\x05"
        "\x03\x06\x04\x01\x00\x07\x02\x05\x03\x06\x04\x01\x02\x07\x00\x05"
        "\x03\x06\x04\x01\x07\x00\x02\x05\x03\x06\x04\x01\x07\x02\x00\x05"
        "\x03\x06\x04\x05\x00\x07\x01\x02\x03\x06\x04\x05\x00\x07\x02\x01"
        "\x03\x06\x04\x05\x01\x07\x00\x02\x03\x06\x04\x05\x02\x07\x00\x01"
        "\x03\x06\x04\x05\x07\x00\x01\x02\x03\x06\x04\x05\x07\x00\x02\x01"
        "\x03\x06\x04\x05\x07\x01\x00\x02\x03\x06\x04\x05\x07\x02\x00\x01"
        "\x03\x06\x04\x07\x00\x01\x02\x05\x03\x06\x04\x07\x00\x02\x01\x05"
        "\x03\x06\x04\x07\x01\x00\x02\x05\x03\x06\x04\x07\x01\x02\x00\x05"
        "\x03\x06\x04\x07\x02\x00\x01\x05\x03\x06\x04\x07\x02\x01\x00\x05"
        "\x03\x06\x05\x00\x01\x07\x02\x04\x03\x06\x05\x00\x01\x07\x04\x02"
        "\x03\x06\x05\x00\x02\x07\x01\x04\x03\x06\x05\x00\x02\x07\x04\x01"
        "\x03\x06\x05\x00\x07\x01\x02\x04\x03\x06\x05\x00\x07\x01\x04\x02"
        "\x03\x06\x05\x00\x07\x02\x01\x04\x03\x06\x05\x00\x07\x02\x04\x01"
        "\x03\x06\x05\x01\x00\x07\x02\x04\x03\x06\x05\x01\x00\x07\x04\x02"
        "\x03\x06\x05\x01\x02\x07\x00\x04\x03\x06\x05\x01\x07\x00\x02\x04"
        "\x03\x06\x05\x01\x07\x00\x04\x02\x03\x06\x05\x01\x07\x02\x00\x04"
        "\x03\x06\x05\x07\x00\x01\x02\x04\x03\x06\x05\x07\x00\x01\x04\x02"
        "\x03\x06\x05\x07\x00\x02\x01\x04\x03\x06\x05\x07\x00\x02\x04\x01"
        "\x03\x06\x05\x07\x01\x00\x02\x04\x03\x06\x05\x07\x01\x00\x04\x02"
        "\x03\x06\x05\x07\x01\x02\x00\x04\x03\x06\x05\x07\x02\x00\x01\x04"
        "\x03\x06\x05\x07\x02\x00\x04\x01\x03\x06\x05\x07\x02\x01\x00\x04"
        "\x03\x06\x07\x00\x01\x02\x04\x05\x03\x06\x07\x00\x02\x01\x04\x05"
        "\x03\x06\x07\x01\x00\x02\x04\x05\x03\x06\x07\x01\x02\x00\x04\x05"
        "\x03\x06\x07\x05\x00\x01\x02\x04\x03\x06\x07\x05\x00\x01\x04\x02"
        "\x03\x06\x07\x05\x00\x02\x01\x04\x03\x06\x07\x05\x00\x02\x04\x01"
        "\x03\x06\x07\x05\x01\x00\x02\x04\x03\x06\x07\x05\x01\x00\x04\x02"
        "\x03\x06\x07\x05\x01\x02\x00\x04\x03\x06\x07\x05\x02\x00\x01\x04"
        "\x03\x06\x07\x05\x02\x00\x04\x01\x03\x06\x07\x05\x02\x01\x00\x04"
        "\x03\x07\x00\x01\x06\x02\x04\x05\x03\x07\x00\x05\x06\x01\x02\x04"
        "\x03\x07\x00\x05\x06\x01\x04\x02\x03\x07\x00\x05\x06\x02\x01\x04"
        "\x03\x07\x00\x05\x06\x02\x04\x01\x03\x07\x00\x06\x01\x02\x04\x05"
        "\x03\x07\x00\x06\x02\x01\x04\x05\x03\x07\x04\x00\x06\x01\x02\x05"
        "\x03\x07\x04\x00\x06\x02\x01\x05\x03\x07\x04\x01\x06\x00\x02\x05"
        "\x03\x07\x04\x01\x06\x02\x00\x05\x03\x07\x04\x05\x06\x00\x01\x02"
        "\x03\x07\x04\x05\x06\x00\x02\x01\x03\x07\x04\x05\x06\x01\x00\x02"
        "\x03\x07\x04\x05\x06\x02\x00\x01\x03\x07\x04\x06\x00\x01\x02\x05"
        "\x03\x07\x04\x06\x00\x02\x01\x05\x03\x07\x04\x06\x01\x00\x02\x05"
        "\x03\x07\x04\x06\x01\x02\x00\x05\x03\x07\x04\x06\x02\x00\x01\x05"
        "\x03\x07\x04\x06\x02\x01\x00\x05\x03\x07\x05\x00\x06\x01\x02\x04"
        "\x03\x07\x05\x00\x06\x01\x04\x02\x03\x07\x05\x00\x06\x02\x01\x04"
        "\x03\x07\x05\x00\x06\x02\x04\x01\x03\x07\x05\x01\x06\x00\x02\x04"
        "\x03\x07\x05\x01\x06\x00\x04\x02\x03\x07\x05\x01\x06\x02\x00\x04"
        "\x03\x07\x05\x06\x00\x01\x02\x04\x03\x07\x05\x06\x00\x01\x04\x02"
        "\x03\x07\x05\x06\x00\x02\x01\x04\x03\x07\x05\x06\x00\x02\x04\x01"
        "\x03\x07\x05\x06\x01\x00\x02\x04\x03\x07\x05\x06\x01\x00\x04\x02"
        "\x03\x07\x05\x06\x01\x02\x00\x04\x03\x07\x05\x06\x02\x00\x01\x04"
        "\x03\x07\x05\x06\x02\x00\x04\x01\x03\x07\x05\x06\x02\x01\x00\x04"
        "\x03\x07\x06\x00\x01\x02\x04\x05\x03\x07\x06\x00\x02\x01\x04\x05"
        "\x03\x07\x06\x01\x00\x02\x04\x05\x03\x07\x06\x01\x02\x00\x04\x05"
        "\x03\x07\x06\x05\x00\x01\x02\x04\x03\x07\x06\x05\x00\x01\x04\x02"
        "\x03\x07\x06\x05\x00\x02\x01\x04\x03\x07\x06\x05\x00\x02\x04\x01"
        "\x03\x07\x06\x05\x01\x00\x02\x04\x03\x07\x06\x05\x01\x00\x04\x02"
        "\x03\x07\x06\x05\x01\x02\x00\x04\x03\x07\x06\x05\x02\x00\x01\x04"
        "\x03\x07\x06\x05\x02\x00\x04\x01\x03\x07\x06\x05\x02\x01\x00\x04"
        "\x04\x03\x00\x01\x06\x07\x02\x05\x04\x03\x00\x05\x06\x07\x01\x02"
        "\x04\x03\x00\x05\x06\x07\x02\x01\x04\x03\x00\x06\x01\x07\x02\x05"
        "\x04\x03\x00\x06\x02\x07\x01\x05\x04\x03\x00\x06\x07\x01\x02\x05"
        "\x04\x03\x00\x06\x07\x02\x01\x05\x04\x03\x00\x07\x06\x01\x02\x05"
        "\x04\x03\x00\x07\x06\x02\x01\x05\x04\x03\x05\x00\x06\x07\x01\x02"
        "\x04\x03\x05\x00\x06\x07\x02\x01\x04\x03\x05\x01\x06\x07\x00\x02"
        "\x04\x03\x05\x06\x00\x07\x01\x02\x04\x03\x05\x06\x00\x07\x02\x01"
        "\x04\x03\x05\x06\x01\x07\x00\x02\x04\x03\x05\x06\x02\x07\x00\x01"
        "\x04\x03\x05\x06\x07\x00\x01\x02\x04\x03\x05\x06\x07\x00\x02\x01"
        "\x04\x03\x05\x06\x07\x01\x00\x02\x04\x03\x05\x06\x07\x02\x00\x01"
        "\x04\x03\x05\x07\x06\x00\x01\x02\x04\x03\x05\x07\x06\x00\x02\x01"
        "\x04\x03\x05\x07\x06\x01\x00\x02\x04\x03\x05\x07\x06\x02\x00\x01"
        "\x04\x03\x06\x00\x01\x07\x02\x05\x04\x03\x06\x00\x02\x07\x01\x05"
        "\x04\x03\x06\x00\x07\x01\x02\x05\x04\x03\x06\x00\x07\x02\x01\x05"
        "\x04\x03\x06\x01\x00\x07\x02\x05\x04\x03\x06\x01\x02\x07\x00\x05"
        "\x04\x03\x06\x01\x07\x00\x02\x05\x04\x03\x06\x01\x07\x02\x00\x05"
        "\x04\x03\x06\x05\x00\x07\x01\x02\x04\x03\x06\x05\x00\x07\x02\x01"
        "\x04\x03\x06\x05\x01\x07\x00\x02\x04\x03\x06\x05\x02\x07\x00\x01"
        "\x04\x03\x06\x05\x07\x00\x01\x02\x04\x03\x06\x05\x07\x00\x02\x01"
        "\x04\x03\x06\x05\x07\x01\x00\x02\x04\x03\x06\x05\x07\x02\x00\x01"
        "\x04\x03\x06\x07\x00\x01\x02\x05\x04\x03\x06\x07\x00\x02\x01\x05"
        "\x04\x03\x06\x07\x01\x00\x02\x05\x04\x03\x06\x07\x01\x02\x00\x05"
        "\x04\x03\x06\x07\x02\x00\x01\x05\x04\x03\x06\x07\x02\x01\x00\x05"
        "\x04\x03\x07\x00\x06\x01\x02\x05\x04\x03\x07\x00\x06\x02\x01\x05"
        "\x04\x03\x07\x01\x06\x00\x02\x05\x04\x03\x07\x01\x06\x02\x00\x05"
        "\x04\x03\x07\x05\x06\x00\x01\x02\x04\x03\x07\x05\x06\x00\x02\x01"
        "\x04\x03\x07\x05\x06\x01\x00\x02\x04\x03\x07\x05\x06\x02\x00\x01"
        "\x04\x03\x07\x06\x00\x01\x02\x05\x04\x03\x07\x06\x00\x02\x01\x05"
        "\x04\x03\x07\x06\x01\x00\x02\x05\x04\x03\x07\x06\x01\x02\x00\x05"
        "\x04\x03\x07\x06\x02\x00\x01\x05\x04\x03\x07\x06\x02\x01\x00\x05"
        "\x04\x05\x00\x01\x06\x07\x02\x03\x04\x05\x00\x01\x06\x07\x03\x02"
        "\x04\x05\x00\x06\x01\x07\x02\x03\x04\x05\x00\x06\x01\x07\x03\x02"
        "\x04\x05\x00\x06\x02\x07\x01\x03\x04\x05\x00\x06\x02\x07\x03\x01"
        "\x04\x05\x00\x06\x07\x01\x02\x03\x04\x05\x00\x06\x07\x01\x03\x02"
        "\x04\x05\x00\x06\x07\x02\x01\x03\x04\x05\x00\x06\x07\x02\x03\x01"
        "\x04\x05\x00\x06\x07\x03\x01\x02\x04\x05\x00\x06\x07\x03\x02\x01"
        "\x04\x05\x00\x07\x06\x01\x02\x03\x04\x05\x00\x07\x06\x01\x03\x02"
        "\x04\x05\x00\x07\x06\x02\x01\x03\x04\x05\x00\x07\x06\x02\x03\x01"
        "\x04\x05\x00\x07\x06\x03\x01\x02\x04\x05\x00\x07\x06\x03\x02\x01"
        "\x04\x05\x06\x00\x01\x07\x02\x03\x04\x05\x06\x00\x01\x07\x03\x02"
        "\x04\x05\x06\x00\x02\x07\x01\x03\x04\x05\x06\x00\x02\x07\x03\x01"
        "\x04\x05\x06\x00\x07\x01\x02\x03\x04\x05\x06\x00\x07\x01\x03\x02"
        "\x04\x05\x06\x00\x07\x02\x01\x03\x04\x05\x06\x00\x07\x02\x03\x01"
        "\x04\x05\x06\x00\x07\x03\x01\x02\x04\x05\x06\x00\x07\x03\x02\x01"
        "\x04\x05\x06\x01\x00\x07\x02\x03\x04\x05\x06\x01\x00\x07\x03\x02"
        "\x04\x05\x06\x01\x02\x07\x00\x03\x04\x05\x06\x01\x07\x00\x02\x03"
        "\x04\x05\x06\x01\x07\x00\x03\x02\x04\x05\x06\x01\x07\x02\x00\x03"
        "\x04\x05\x06\x01\x07\x03\x00\x02\x04\x05\x06\x07\x00\x01\x02\x03"
        "\x04\x05\x06\x07\x00\x01\x03\x02\x04\x05\x06\x07\x00\x02\x01\x03"
        "\x04\x05\x06\x07\x00\x02\x03\x01\x04\x05\x06\x07\x00\x03\x01\x02"
        "\x04\x05\x06\x07\x00\x03\x02\x01\x04\x05\x06\x07\x01\x00\x02\x03"
        "\x04\x05\x06\x07\x01\x00\x03\x02\x04\x05\x06\x07\x01\x02\x00\x03"
        "\x04\x05\x06\x07\x01\x03\x00\x02\x04\x05\x06\x07\x02\x00\x01\x03"
        "\x04\x05\x06\x07\x02\x00\x03\x01\x04\x05\x06\x07\x02\x01\x00\x03"
        "\x04\x05\x06\x07\x02\x03\x00\x01\x04\x05\x07\x00\x06\x01\x02\x03"
        "\x04\x05\x07\x00\x06\x01\x03\x02\x04\x05\x07\x00\x06\x02\x01\x03"
        "\x04\x05\x07\x00\x06\x02\x03\x01\x04\x05\x07\x00\x06\x03\x01\x02"
        "\x04\x05\x07\x00\x06\x03\x02\x01\x04\x05\x07\x01\x06\x00\x02\x03"
        "\x04\x05\x07\x01\x06\x00\x03\x02\x04\x05\x07\x01\x06\x02\x00\x03"
        "\x04\x05\x07\x01\x06\x03\x00\x02\x04\x05\x07\x06\x00\x01\x02\x03"
        "\x04\x05\x07\x06\x00\x01\x03\x02\x04\x05\x07\x06\x00\x02\x01\x03"
        "\x04\x05\x07\x06\x00\x02\x03\x01\x04\x05\x07\x06\x00\x03\x01\x02"
        "\x04\x05\x07\x06\x00\x03\x02\x01\x04\x05\x07\x06\x01\x00\x02\x03"
        "\x04\x05\x07\x06\x01\x00\x03\x02\x04\x05\x07\x06\x01\x02\x00\x03"
        "\x04\x05\x07\x06\x01\x03\x00\x02\x04\x05\x07\x06\x02\x00\x01\x03"
        "\x04\x05\x07\x06\x02\x00\x03\x01\x04\x05\x07\x06\x02\x01\x00\x03"
        "\x04\x05\x07\x06\x02\x03\x00\x01\x04\x06\x00\x01\x02\x07\x03\x05"
        "\x04\x06\x00\x01\x07\x02\x03\x05\x04\x06\x00\x01\x07\x03\x02\x05"
        "\x04\x06\x00\x05\x01\x07\x02\x03\x04\x06\x00\x05\x01\x07\x03\x02"
        "\x04\x06\x00\x05\x02\x07\x01\x03\x04\x06\x00\x05\x02\x07\x03\x01"
        "\x04\x06\x00\x05\x07\x01\x02\x03\x04\x06\x00\x05\x07\x01\x03\x02"
        "\x04\x06\x00\x05\x07\x02\x01\x03\x04\x06\x00\x05\x07\x02\x03\x01"
        "\x04\x06\x00\x05\x07\x03\x01\x02\x04\x06\x00\x05\x07\x03\x02\x01"
        "\x04\x06\x00\x07\x01\x02\x03\x05\x04\x06\x00\x07\x01\x03\x02\x05"
        "\x04\x06\x00\x07\x02\x01\x03\x05\x04\x06\x00\x07\x02\x03\x01\x05"
        "\x04\x06\x05\x00\x01\x07\x02\x03\x04\x06\x05\x00\x01\x07\x03\x02"
        "\x04\x06\x05\x00\x02\x07\x01\x03\x04\x06\x05\x00\x02\x07\x03\x01"
        "\x04\x06\x05\x00\x07\x01\x02\x03\x04\x06\x05\x00\x07\x01\x03\x02"
        "\x04\x06\x05\x00\x07\x02\x01\x03\x04\x06\x05\x00\x07\x02\x03\x01"
        "\x04\x06\x05\x00\x07\x03\x01\x02\x04\x06\x05\x00\x07\x03\x02\x01"
        "\x04\x06\x05\x01\x00\x07\x02\x03\x04\x06\x05\x01\x00\x07\x03\x02"
        "\x04\x06\x05\x01\x02\x07\x00\x03\x04\x06\x05\x01\x07\x00\x02\x03"
        "\x04\x06\x05\x01\x07\x00\x03\x02\x04\x06\x05\x01\x07\x02\x00\x03"
        "\x04\x06\x05\x01\x07\x03\x00\x02\x04\x06\x05\x07\x00\x01\x02\x03"
        "\x04\x06\x05\x07\x00\x01\x03\x02\x04\x06\x05\x07\x00\x02\x01\x03"
        "\x04\x06\x05\x07\x00\x02\x03\x01\x04\x06\x05\x07\x00\x03\x01\x02"
        "\x04\x06\x05\x07\x00\x03\x02\x01\x04\x06\x05\x07\x01\x00\x02\x03"
        "\x04\x06\x05\x07\x01\x00\x03\x02\x04\x06\x05\x07\x01\x02\x00\x03"
        "\x04\x06\x05\x07\x01\x03\x00\x02\x04\x06\x05\x07\x02\x00\x01\x03"
        "\x04\x06\x05\x07\x02\x00\x03\x01\x04\x06\x05\x07\x02\x01\x00\x03"
        "\x04\x06\x05\x07\x02\x03\x00\x01\x04\x06\x07\x00\x01\x02\x03\x05"
        "\x04\x06\x07\x00\x01\x03\x02\x05\x04\x06\x07\x00\x02\x01\x03\x05"
        "\x04\x06\x07\x00\x02\x03\x01\x05\x04\x06\x07\x01\x00\x02\x03\x05"
        "\x04\x06\x07\x01\x00\x03\x02\x05\x04\x06\x07\x01\x02\x00\x03\x05"
        "\x04\x06\x07\x01\x02\x03\x00\x05\x04\x06\x07\x05\x00\x01\x02\x03"
        "\x04\x06\x07\x05\x00\x01\x03\x02\x04\x06\x07\x05\x00\x02\x01\x03"
        "\x04\x06\x07\x05\x00\x02\x03\x01\x04\x06\x07\x05\x00\x03\x01\x02"
        "\x04\x06\x07\x05\x00\x03\x02\x01\x04\x06\x07\x05\x01\x00\x02\x03"
        "\x04\x06\x07\x05\x01\x00\x03\x02\x04\x06\x07\x05\x01\x02\x00\x03"
        "\x04\x06\x07\x05\x01\x03\x00\x02\x04\x06\x07\x05\x02\x00\x01\x03"
        "\x04\x06\x07\x05\x02\x00\x03\x01\x04\x06\x07\x05\x02\x01\x00\x03"
        "\x04\x06\x07\x05\x02\x03\x00\x01\x04\x07\x00\x01\x06\x02\x03\x05"
        "\x04\x07\x00\x01\x06\x03\x02\x05\x04\x07\x00\x05\x06\x01\x02\x03"
        "\x04\x07\x00\x05\x06\x01\x03\x02\x04\x07\x00\x05\x06\x02\x01\x03"
        "\x04\x07\x00\x05\x06\x02\x03\x01\x04\x07\x00\x05\x06\x03\x01\x02"
        "\x04\x07\x00\x05\x06\x03\x02\x01\x04\x07\x00\x06\x01\x02\x03\x05"
        "\x04\x07\x00\x06\x01\x03\x02\x05\x04\x07\x00\x06\x02\x01\x03\x05"
        "\x04\x07\x00\x06\x02\x03\x01\x05\x04\x07\x05\x00\x06\x01\x02\x03"
        "\x04\x07\x05\x00\x06\x01\x03\x02\x04\x07\x05\x00\x06\x02\x01\x03"
        "\x04\x07\x05\x00\x06\x02\x03\x01\x04\x07\x05\x00\x06\x03\x01\x02"
        "\x04\x07\x05\x00\x06\x03\x02\x01\x04\x07\x05\x01\x06\x00\x02\x03"
        "\x04\x07\x05\x01\x06\x00\x03\x02\x04\x07\x05\x01\x06\x02\x00\x03"
        "\x04\x07\x05\x01\x06\x03\x00\x02\x04\x07\x05\x06\x00\x01\x02\x03"
        "\x04\x07\x05\x06\x00\x01\x03\x02\x04\x07\x05\x06\x00\x02\x01\x03"
        "\x04\x07\x05\x06\x00\x02\x03\x01\x04\x07\x05\x06\x00\x03\x01\x02"
        "\x04\x07\x05\x06\x00\x03\x02\x01\x04\x07\x05\x06\x01\x00\x02\x03"
        "\x04\x07\x05\x06\x01\x00\x03\x02\x04\x07\x05\x06\x01\x02\x00\x03"
        "\x04\x07\x05\x06\x01\x03\x00\x02\x04\x07\x05\x06\x02\x00\x01\x03"
        "\x04\x07\x05\x06\x02\x00\x03\x01\x04\x07\x05\x06\x02\x01\x00\x03"
        "\x04\x07\x05\x06\x02\x03\x00\x01\x04\x07\x06\x00\x01\x02\x03\x05"
        "\x04\x07\x06\x00\x01\x03\x02\x05\x04\x07\x06\x00\x02\x01\x03\x05"
        "\x04\x07\x06\x00\x02\x03\x01\x05\x04\x07\x06\x01\x00\x02\x03\x05"
        "\x04\x07\x06\x01\x00\x03\x02\x05\x04\x07\x06\x01\x02\x00\x03\x05"
        "\x04\x07\x06\x01\x02\x03\x00\x05\x04\x07\x06\x05\x00\x01\x02\x03"
        "\x04\x07\x06\x05\x00\x01\x03\x02\x04\x07\x06\x05\x00\x02\x01\x03"
        "\x04\x07\x06\x05\x00\x02\x03\x01\x04\x07\x06\x05\x00\x03\x01\x02"
        "\x04\x07\x06\x05\x00\x03\x02\x01\x04\x07\x06\x05\x01\x00\x02\x03"
        "\x04\x07\x06\x05\x01\x00\x03\x02\x04\x07\x06\x05\x01\x02\x00\x03"
        "\x04\x07\x06\x05\x01\x03\x00\x02\x04\x07\x06\x05\x02\x00\x01\x03"
        "\x04\x07\x06\x05\x02\x00\x03\x01\x04\x07\x06\x05\x02\x01\x00\x03"
        "\x04\x07\x06\x05\x02\x03\x00\x01\x05\x03\x00\x01\x06\x07\x02\x04"
        "\x05\x03\x00\x01\x06\x07\x04\x02\x05\x03\x00\x06\x01\x07\x02\x04"
        "\x05\x03\x00\x06\x01\x07\x04\x02\x05\x03\x00\x06\x02\x07\x01\x04"
        "\x05\x03\x00\x06\x02\x07\x04\x01\x05\x03\x00\x06\x07\x01\x02\x04"
        "\x05\x03\x00\x06\x07\x01\x04\x02\x05\x03\x00\x06\x07\x02\x01\x04"
        "\x05\x03\x00\x06\x07\x02\x04\x01\x05\x03\x00\x07\x06\x01\x02\x04"
        "\x05\x03\x00\x07\x06\x01\x04\x02\x05\x03\x00\x07\x06\x02\x01\x04"
        "\x05\x03\x00\x07\x06\x02\x04\x01\x05\x03\x04\x00\x06\x07\x01\x02"
        "\x05\x03\x04\x00\x06\x07\x02\x01\x05\x03\x04\x01\x06\x07\x00\x02"
        "\x05\x03\x04\x06\x00\x07\x01\x02\x05\x03\x04\x06\x00\x07\x02\x01"
        "\x05\x03\x04\x06\x01\x07\x00\x02\x05\x03\x04\x06\x02\x07\x00\x01"
        "\x05\x03\x04\x06\x07\x00\x01\x02\x05\x03\x04\x06\x07\x00\x02\x01"
        "\x05\x03\x04\x06\x07\x01\x00\x02\x05\x03\x04\x06\x07\x02\x00\x01"
        "\x05\x03\x04\x07\x06\x00\x01\x02\x05\x03\x04\x07\x06\x00\x02\x01"
        "\x05\x03\x04\x07\x06\x01\x00\x02\x05\x03\x04\x07\x06\x02\x00\x01"
        "\x05\x03\x06\x00\x01\x07\x02\x04\x05\x03\x06\x00\x01\x07\x04\x02"
        "\x05\x03\x06\x00\x02\x07\x01\x04\x05\x03\x06\x00\x02\x07\x04\x01"
        "\x05\x03\x06\x00\x07\x01\x02\x04\x05\x03\x06\x00\x07\x01\x04\x02"
        "\x05\x03\x06\x00\x07\x02\x01\x04\x05\x03\x06\x00\x07\x02\x04\x01"
        "\x05\x03\x06\x01\x00\x07\x02\x04\x05\x03\x06\x01\x00\x07\x04\x02"
        "\x05\x03\x06\x01\x02\x07\x00\x04\x05\x03\x06\x01\x07\x00\x02\x04"
        "\x05\x03\x06\x01\x07\x00\x04\x02\x05\x03\x06\x01\x07\x02\x00\x04"
        "\x05\x03\x06\x07\x00\x01\x02\x04\x05\x03\x06\x07\x00\x01\x04\x02"
        "\x05\x03\x06\x07\x00\x02\x01\x04\x05\x03\x06\x07\x00\x02\x04\x01"
        "\x05\x03\x06\x07\x01\x00\x02\x04\x05\x03\x06\x07\x01\x00\x04\x02"
        "\x05\x03\x06\x07\x01\x02\x00\x04\x05\x03\x06\x07\x02\x00\x01\x04"
        "\x05\x03\x06\x07\x02\x00\x04\x01\x05\x03\x06\x07\x02\x01\x00\x04"
        "\x05\x03\x07\x00\x06\x01\x02\x04\x05\x03\x07\x00\x06\x01\x04\x02"
        "\x05\x03\x07\x00\x06\x02\x01\x04\x05\x03\x07\x00\x06\x02\x04\x01"
        "\x05\x03\x07\x01\x06\x00\x02\x04\x05\x03\x07\x01\x06\x00\x04\x02"
        "\x05\x03\x07\x01\x06\x02\x00\x04\x05\x03\x07\x06\x00\x01\x02\x04"
        "\x05\x03\x07\x06\x00\x01\x04\x02\x05\x03\x07\x06\x00\x02\x01\x04"
        "\x05\x03\x07\x06\x00\x02\x04\x01\x05\x03\x07\x06\x01\x00\x02\x04"
        "\x05\x03\x07\x06\x01\x00\x04\x02\x05\x03\x07\x06\x01\x02\x00\x04"
        "\x05\x03\x07\x06\x02\x00\x01\x04\x05\x03\x07\x06\x02\x00\x04\x01"
        "\x05\x03\x07\x06\x02\x01\x00\x04\x05\x04\x00\x01\x06\x07\x02\x03"
        "\x05\x04\x00\x01\x06\x07\x03\x02\x05\x04\x00\x06\x01\x07\x02\x03"
        "\x05\x04\x00\x06\x01\x07\x03\x02\x05\x04\x00\x06\x02\x07\x01\x03"
        "\x05\x04\x00\x06\x02\x07\x03\x01\x05\x04\x00\x06\x07\x01\x02\x03"
        "\x05\x04\x00\x06\x07\x01\x03\x02\x05\x04\x00\x06\x07\x02\x01\x03"
        "\x05\x04\x00\x06\x07\x02\x03\x01\x05\x04\x00\x06\x07\x03\x01\x02"
        "\x05\x04\x00\x06\x07\x03\x02\x01\x05\x04\x00\x07\x06\x01\x02\x03"
        "\x05\x04\x00\x07\x06\x01\x03\x02\x05\x04\x00\x07\x06\x02\x01\x03"
        "\x05\x04\x00\x07\x06\x02\x03\x01\x05\x04\x00\x07\x06\x03\x01\x02"
        "\x05\x04\x00\x07\x06\x03\x02\x01\x05\x04\x06\x00\x01\x07\x02\x03"
        "\x05\x04\x06\x00\x01\x07\x03\x02\x05\x04\x06\x00\x02\x07\x01\x03"
        "\x05\x04\x06\x00\x02\x07\x03\x01\x05\x04\x06\x00\x07\x01\x02\x03"
        "\x05\x04\x06\x00\x07\x01\x03\x02\x05\x04\x06\x00\x07\x02\x01\x03"
        "\x05\x04\x06\x00\x07\x02\x03\x01\x05\x04\x06\x00\x07\x03\x01\x02"
        "\x05\x04\x06\x00\x07\x03\x02\x01\x05\x04\x06\x01\x00\x07\x02\x03"
        "\x05\x04\x06\x01\x00\x07\x03\x02\x05\x04\x06\x01\x02\x07\x00\x03"
        "\x05\x04\x06\x01\x07\x00\x02\x03\x05\x04\x06\x01\x07\x00\x03\x02"
        "\x05\x04\x06\x01\x07\x02\x00\x03\x05\x04\x06\x01\x07\x03\x00\x02"
        "\x05\x04\x06\x07\x00\x01\x02\x03\x05\x04\x06\x07\x00\x01\x03\x02"
        "\x05\x04\x06\x07\x00\x02\x01\x03\x05\x04\x06\x07\x00\x02\x03\x01"
        "\x05\x04\x06\x07\x00\x03\x01\x02\x05\x04\x06\x07\x00\x03\x02\x01"
        "\x05\x04\x06\x07\x01\x00\x02\x03\x05\x04\x06\x07\x01\x00\x03\x02"
        "\x05\x04\x06\x07\x01\x02\x00\x03\x05\x04\x06\x07\x01\x03\x00\x02"
        "\x05\x04\x06\x07\x02\x00\x01\x03\x05\x04\x06\x07\x02\x00\x03\x01"
        "\x05\x04\x06\x07\x02\x01\x00\x03\x05\x04\x06\x07\x02\x03\x00\x01"
        "\x05\x04\x07\x00\x06\x01\x02\x03\x05\x04\x07\x00\x06\x01\x03\x02"
        "\x05\x04\x07\x00\x06\x02\x01\x03\x05\x04\x07\x00\x06\x02\x03\x01"
        "\x05\x04\x07\x00\x06\x03\x01\x02\x05\x04\x07\x00\x06\x03\x02\x01"
        "\x05\x04\x07\x01\x06\x00\x02\x03\x05\x04\x07\x01\x06\x00\x03\x02"
        "\x05\x04\x07\x01\x06\x02\x00\x03\x05\x04\x07\x01\x06\x03\x00\x02"
        "\x05\x04\x07\x06\x00\x01\x02\x03\x05\x04\x07\x06\x00\x01\x03\x02"
        "\x05\x04\x07\x06\x00\x02\x01\x03\x05\x04\x07\x06\x00\x02\x03\x01"
        "\x05\x04\x07\x06\x00\x03\x01\x02\x05\x04\x07\x06\x00\x03\x02\x01"
        "\x05\x04\x07\x06\x01\x00\x02\x03\x05\x04\x07\x06\x01\x00\x03\x02"
        "\x05\x04\x07\x06\x01\x02\x00\x03\x05\x04\x07\x06\x01\x03\x00\x02"
        "\x05\x04\x07\x06\x02\x00\x01\x03\x05\x04\x07\x06\x02\x00\x03\x01"
        "\x05\x04\x07\x06\x02\x01\x00\x03\x05\x04\x07\x06\x02\x03\x00\x01"
        "\x05\x06\x00\x01\x02\x07\x03\x04\x05\x06\x00\x01\x02\x07\x04\x03"
        "\x05\x06\x00\x01\x07\x02\x03\x04\x05\x06\x00\x01\x07\x02\x04\x03"
        "\x05\x06\x00\x01\x07\x03\x02\x04\x05\x06\x00\x01\x07\x03\x04\x02"
        "\x05\x06\x00\x07\x01\x02\x03\x04\x05\x06\x00\x07\x01\x02\x04\x03"
        "\x05\x06\x00\x07\x01\x03\x02\x04\x05\x06\x00\x07\x01\x03\x04\x02"
        "\x05\x06\x00\x07\x02\x01\x03\x04\x05\x06\x00\x07\x02\x01\x04\x03"
        "\x05\x06\x00\x07\x02\x03\x01\x04\x05\x06\x00\x07\x02\x03\x04\x01"
        "\x05\x06\x04\x00\x01\x07\x02\x03\x05\x06\x04\x00\x01\x07\x03\x02"
        "\x05\x06\x04\x00\x02\x07\x01\x03\x05\x06\x04\x00\x02\x07\x03\x01"
        "\x05\x06\x04\x00\x07\x01\x02\x03\x05\x06\x04\x00\x07\x01\x03\x02"
        "\x05\x06\x04\x00\x07\x02\x01\x03\x05\x06\x04\x00\x07\x02\x03\x01"
        "\x05\x06\x04\x00\x07\x03\x01\x02\x05\x06\x04\x00\x07\x03\x02\x01"
        "\x05\x06\x04\x01\x00\x07\x02\x03\x05\x06\x04\x01\x00\x07\x03\x02"
        "\x05\x06\x04\x01\x02\x07\x00\x03\x05\x06\x04\x01\x07\x00\x02\x03"
        "\x05\x06\x04\x01\x07\x00\x03\x02\x05\x06\x04\x01\x07\x02\x00\x03"
        "\x05\x06\x04\x01\x07\x03\x00\x02\x05\x06\x04\x07\x00\x01\x02\x03"
        "\x05\x06\x04\x07\x00\x01\x03\x02\x05\x06\x04\x07\x00\x02\x01\x03"
        "\x05\x06\x04\x07\x00\x02\x03\x01\x05\x06\x04\x07\x00\x03\x01\x02"
        "\x05\x06\x04\x07\x00\x03\x02\x01\x05\x06\x04\x07\x01\x00\x02\x03"
        "\x05\x06\x04\x07\x01\x00\x03\x02\x05\x06\x04\x07\x01\x02\x00\x03"
        "\x05\x06\x04\x07\x01\x03\x00\x02\x05\x06\x04\x07\x02\x00\x01\x03"
        "\x05\x06\x04\x07\x02\x00\x03\x01\x05\x06\x04\x07\x02\x01\x00\x03"
        "\x05\x06\x04\x07\x02\x03\x00\x01\x05\x06\x07\x00\x01\x02\x03\x04"
        "\x05\x06\x07\x00\x01\x02\x04\x03\x05\x06\x07\x00\x01\x03\x02\x04"
        "\x05\x06\x07\x00\x01\x03\x04\x02\x05\x06\x07\x00\x02\x01\x03\x04"
        "\x05\x06\x07\x00\x02\x01\x04\x03\x05\x06\x07\x00\x02\x03\x01\x04"
        "\x05\x06\x07\x00\x02\x03\x04\x01\x05\x06\x07\x01\x00\x02\x03\x04"
        "\x05\x06\x07\x01\x00\x02\x04\x03\x05\x06\x07\x01\x00\x03\x02\x04"
        "\x05\x06\x07\x01\x00\x03\x04\x02\x05\x06\x07\x01\x02\x00\x03\x04"
        "\x05\x06\x07\x01\x02\x00\x04\x03\x05\x06\x07\x01\x02\x03\x00\x04"
        "\x05\x07\x00\x01\x06\x02\x03\x04\x05\x07\x00\x01\x06\x02\x04\x03"
        "\x05\x07\x00\x01\x06\x03\x02\x04\x05\x07\x00\x01\x06\x03\x04\x02"
        "\x05\x07\x00\x06\x01\x02\x03\x04\x05\x07\x00\x06\x01\x02\x04\x03"
        "\x05\x07\x00\x06\x01\x03\x02\x04\x05\x07\x00\x06\x01\x03\x04\x02"
        "\x05\x07\x00\x06\x02\x01\x03\x04\x05\x07\x00\x06\x02\x01\x04\x03"
        "\x05\x07\x00\x06\x02\x03\x01\x04\x05\x07\x00\x06\x02\x03\x04\x01"
        "\x05\x07\x04\x00\x06\x01\x02\x03\x05\x07\x04\x00\x06\x01\x03\x02"
        "\x05\x07\x04\x00\x06\x02\x01\x03\x05\x07\x04\x00\x06\x02\x03\x01"
        "\x05\x07\x04\x00\x06\x03\x01\x02\x05\x07\x04\x00\x06\x03\x02\x01"
        "\x05\x07\x04\x01\x06\x00\x02\x03\x05\x07\x04\x01\x06\x00\x03\x02"
        "\x05\x07\x04\x01\x06\x02\x00\x03\x05\x07\x04\x01\x06\x03\x00\x02"
        "\x05\x07\x04\x06\x00\x01\x02\x03\x05\x07\x04\x06\x00\x01\x03\x02"
        "\x05\x07\x04\x06\x00\x02\x01\x03\x05\x07\x04\x06\x00\x02\x03\x01"
        "\x05\x07\x04\x06\x00\x03\x01\x02\x05\x07\x04\x06\x00\x03\x02\x01"
        "\x05\x07\x04\x06\x01\x00\x02\x03\x05\x07\x04\x06\x01\x00\x03\x02"
        "\x05\x07\x04\x06\x01\x02\x00\x03\x05\x07\x04\x06\x01\x03\x00\x02"
        "\x05\x07\x04\x06\x02\x00\x01\x03\x05\x07\x04\x06\x02\x00\x03\x01"
        "\x05\x07\x04\x06\x02\x01\x00\x03\x05\x07\x04\x06\x02\x03\x00\x01"
        "\x05\x07\x06\x00\x01\x02\x03\x04\x05\x07\x06\x00\x01\x02\x04\x03"
        "\x05\x07\x06\x00\x01\x03\x02\x04\x05\x07\x06\x00\x01\x03\x04\x02"
        "\x05\x07\x06\x00\x02\x01\x03\x04\x05\x07\x06\x00\x02\x01\x04\x03"
        "\x05\x07\x06\x00\x02\x03\x01\x04\x05\x07\x06\x00\x02\x03\x04\x01"
        "\x05\x07\x06\x01\x00\x02\x03\x04\x05\x07\x06\x01\x00\x02\x04\x03"
        "\x05\x07\x06\x01\x00\x03\x02\x04\x05\x07\x06\x01\x00\x03\x04\x02"
        "\x05\x07\x06\x01\x02\x00\x03\x04\x05\x07\x06\x01\x02\x00\x04\x03"
        "\x05\x07\x06\x01\x02\x03\x00\x04\x06\x03\x00\x01\x02\x07\x04\x05"
        "\x06\x03\x00\x01\x07\x02\x04\x05\x06\x03\x00\x05\x01\x07\x02\x04"
        "\x06\x03\x00\x05\x01\x07\x04\x02\x06\x03\x00\x05\x02\x07\x01\x04"
        "\x06\x03\x00\x05\x02\x07\x04\x01\x06\x03\x00\x05\x07\x01\x02\x04"
        "\x06\x03\x00\x05\x07\x01\x04\x02\x06\x03\x00\x05\x07\x02\x01\x04"
        "\x06\x03\x00\x05\x07\x02\x04\x01\x06\x03\x00\x07\x01\x02\x04\x05"
        "\x06\x03\x00\x07\x02\x01\x04\x05\x06\x03\x04\x00\x01\x07\x02\x05"
        "\x06\x03\x04\x00\x02\x07\x01\x05\x06\x03\x04\x00\x07\x01\x02\x05"
        "\x06\x03\x04\x00\x07\x02\x01\x05\x06\x03\x04\x01\x00\x07\x02\x05"
        "\x06\x03\x04\x01\x02\x07\x00\x05\x06\x03\x04\x01\x07\x00\x02\x05"
        "\x06\x03\x04\x01\x07\x02\x00\x05\x06\x03\x04\x05\x00\x07\x01\x02"
        "\x06\x03\x04\x05\x00\x07\x02\x01\x06\x03\x04\x05\x01\x07\x00\x02"
        "\x06\x03\x04\x05\x02\x07\x00\x01\x06\x03\x04\x05\x07\x00\x01\x02"
        "\x06\x03\x04\x05\x07\x00\x02\x01\x06\x03\x04\x05\x07\x01\x00\x02"
        "\x06\x03\x04\x05\x07\x02\x00\x01\x06\x03\x04\x07\x00\x01\x02\x05"
        "\x06\x03\x04\x07\x00\x02\x01\x05\x06\x03\x04\x07\x01\x00\x02\x05"
        "\x06\x03\x04\x07\x01\x02\x00\x05\x06\x03\x04\x07\x02\x00\x01\x05"
        "\x06\x03\x04\x07\x02\x01\x00\x05\x06\x03\x05\x00\x01\x07\x02\x04"
        "\x06\x03\x05\x00\x01\x07\x04\x02\x06\x03\x05\x00\x02\x07\x01\x04"
        "\x06\x03\x05\x00\x02\x07\x04\x01\x06\x03\x05\x00\x07\x01\x02\x04"
        "\x06\x03\x05\x00\x07\x01\x04\x02\x06\x03\x05\x00\x07\x02\x01\x04"
        "\x06\x03\x05\x00\x07\x02\x04\x01\x06\x03\x05\x01\x00\x07\x02\x04"
        "\x06\x03\x05\x01\x00\x07\x04\x02\x06\x03\x05\x01\x02\x07\x00\x04"
        "\x06\x03\x05\x01\x07\x00\x02\x04\x06\x03\x05\x01\x07\x00\x04\x02"
        "\x06\x03\x05\x01\x07\x02\x00\x04\x06\x03\x05\x07\x00\x01\x02\x04"
        "\x06\x03\x05\x07\x00\x01\x04\x02\x06\x03\x05\x07\x00\x02\x01\x04"
        "\x06\x03\x05\x07\x00\x02\x04\x01\x06\x03\x05\x07\x01\x00\x02\x04"
        "\x06\x03\x05\x07\x01\x00\x04\x02\x06\x03\x05\x07\x01\x02\x00\x04"
        "\x06\x03\x05\x07\x02\x00\x01\x04\x06\x03\x05\x07\x02\x00\x04\x01"
        "\x06\x03\x05\x07\x02\x01\x00\x04\x06\x03\x07\x00\x01\x02\x04\x05"
        "\x06\x03\x07\x00\x02\x01\x04\x05\x06\x03\x07\x01\x00\x02\x04\x05"
        "\x06\x03\x07\x01\x02\x00\x04\x05\x06\x03\x07\x05\x00\x01\x02\x04"
        "\x06\x03\x07\x05\x00\x01\x04\x02\x06\x03\x07\x05\x00\x02\x01\x04"
        "\x06\x03\x07\x05\x00\x02\x04\x01\x06\x03\x07\x05\x01\x00\x02\x04"
        "\x06\x03\x07\x05\x01\x00\x04\x02\x06\x03\x07\x05\x01\x02\x00\x04"
        "\x06\x03\x07\x05\x02\x00\x01\x04\x06\x03\x07\x05\x02\x00\x04\x01"
        "\x06\x03\x07\x05\x02\x01\x00\x04\x06\x04\x00\x01\x02\x07\x03\x05"
        "\x06\x04\x00\x01\x07\x02\x03\x05\x06\x04\x00\x01\x07\x03\x02\x05"
        "\x06\x04\x00\x05\x01\x07\x02\x03\x06\x04\x00\x05\x01\x07\x03\x02"
        "\x06\x04\x00\x05\x02\x07\x01\x03\x06\x04\x00\x05\x02\x07\x03\x01"
        "\x06\x04\x00\x05\x07\x01\x02\x03\x06\x04\x00\x05\x07\x01\x03\x02"
        "\x06\x04\x00\x05\x07\x02\x01\x03\x06\x04\x00\x05\x07\x02\x03\x01"
        "\x06\x04\x00\x05\x07\x03\x01\x02\x06\x04\x00\x05\x07\x03\x02\x01"
        "\x06\x04\x00\x07\x01\x02\x03\x05\x06\x04\x00\x07\x01\x03\x02\x05"
        "\x06\x04\x00\x07\x02\x01\x03\x05\x06\x04\x00\x07\x02\x03\x01\x05"
        "\x06\x04\x05\x00\x01\x07\x02\x03\x06\x04\x05\x00\x01\x07\x03\x02"
        "\x06\x04\x05\x00\x02\x07\x01\x03\x06\x04\x05\x00\x02\x07\x03\x01"
        "\x06\x04\x05\x00\x07\x01\x02\x03\x06\x04\x05\x00\x07\x01\x03\x02"
        "\x06\x04\x05\x00\x07\x02\x01\x03\x06\x04\x05\x00\x07\x02\x03\x01"
        "\x06\x04\x05\x00\x07\x03\x01\x02\x06\x04\x05\x00\x07\x03\x02\x01"
        "\x06\x04\x05\x01\x00\x07\x02\x03\x06\x04\x05\x01\x00\x07\x03\x02"
        "\x06\x04\x05\x01\x02\x07\x00\x03\x06\x04\x05\x01\x07\x00\x02\x03"
        "\x06\x04\x05\x01\x07\x00\x03\x02\x06\x04\x05\x01\x07\x02\x00\x03"
        "\x06\x04\x05\x01\x07\x03\x00\x02\x06\x04\x05\x07\x00\x01\x02\x03"
        "\x06\x04\x05\x07\x00\x01\x03\x02\x06\x04\x05\x07\x00\x02\x01\x03"
        "\x06\x04\x05\x07\x00\x02\x03\x01\x06\x04\x05\x07\x00\x03\x01\x02"
        "\x06\x04\x05\x07\x00\x03\x02\x01\x06\x04\x05\x07\x01\x00\x02\x03"
        "\x06\x04\x05\x07\x01\x00\x03\x02\x06\x04\x05\x07\x01\x02\x00\x03"
        "\x06\x04\x05\x07\x01\x03\x00\x02\x06\x04\x05\x07\x02\x00\x01\x03"
        "\x06\x04\x05\x07\x02\x00\x03\x01\x06\x04\x05\x07\x02\x01\x00\x03"
        "\x06\x04\x05\x07\x02\x03\x00\x01\x06\x04\x07\x00\x01\x02\x03\x05"
        "\x06\x04\x07\x00\x01\x03\x02\x05\x06\x04\x07\x00\x02\x01\x03\x05"
        "\x06\x04\x07\x00\x02\x03\x01\x05\x06\x04\x07\x01\x00\x02\x03\x05"
        "\x06\x04\x07\x01\x00\x03\x02\x05\x06\x04\x07\x01\x02\x00\x03\x05"
        "\x06\x04\x07\x01\x02\x03\x00\x05\x06\x04\x07\x05\x00\x01\x02\x03"
        "\x06\x04\x07\x05\x00\x01\x03\x02\x06\x04\x07\x05\x00\x02\x01\x03"
        "\x06\x04\x07\x05\x00\x02\x03\x01\x06\x04\x07\x05\x00\x03\x01\x02"
        "\x06\x04\x07\x05\x00\x03\x02\x01\x06\x04\x07\x05\x01\x00\x02\x03"
        "\x06\x04\x07\x05\x01\x00\x03\x02\x06\x04\x07\x05\x01\x02\x00\x03"
        "\x06\x04\x07\x05\x01\x03\x00\x02\x06\x04\x07\x05\x02\x00\x01\x03"
        "\x06\x04\x07\x05\x02\x00\x03\x01\x06\x04\x07\x05\x02\x01\x00\x03"
        "\x06\x04\x07\x05\x02\x03\x00\x01\x06\x05\x00\x01\x02\x07\x03\x04"
        "\x06\x05\x00\x01\x02\x07\x04\x03\x06\x05\x00\x01\x07\x02\x03\x04"
        "\x06\x05\x00\x01\x07\x02\x04\x03\x06\x05\x00\x01\x07\x03\x02\x04"
        "\x06\x05\x00\x01\x07\x03\x04\x02\x06\x05\x00\x07\x01\x02\x03\x04"
        "\x06\x05\x00\x07\x01\x02\x04\x03\x06\x05\x00\x07\x01\x03\x02\x04"
        "\x06\x05\x00\x07\x01\x03\x04\x02\x06\x05\x00\x07\x02\x01\x03\x04"
        "\x06\x05\x00\x07\x02\x01\x04\x03\x06\x05\x00\x07\x02\x03\x01\x04"
        "\x06\x05\x00\x07\x02\x03\x04\x01\x06\x05\x04\x00\x01\x07\x02\x03"
        "\x06\x05\x04\x00\x01\x07\x03\x02\x06\x05\x04\x00\x02\x07\x01\x03"
        "\x06\x05\x04\x00\x02\x07\x03\x01\x06\x05\x04\x00\x07\x01\x02\x03"
        "\x06\x05\x04\x00\x07\x01\x03\x02\x06\x05\x04\x00\x07\x02\x01\x03"
        "\x06\x05\x04\x00\x07\x02\x03\x01\x06\x05\x04\x00\x07\x03\x01\x02"
        "\x06\x05\x04\x00\x07\x03\x02\x01\x06\x05\x04\x01\x00\x07\x02\x03"
        "\x06\x05\x04\x01\x00\x07\x03\x02\x06\x05\x04\x01\x02\x07\x00\x03"
        "\x06\x05\x04\x01\x07\x00\x02\x03\x06\x05\x04\x01\x07\x00\x03\x02"
        "\x06\x05\x04\x01\x07\x02\x00\x03\x06\x05\x04\x01\x07\x03\x00\x02"
        "\x06\x05\x04\x07\x00\x01\x02\x03\x06\x05\x04\x07\x00\x01\x03\x02"
        "\x06\x05\x04\x07\x00\x02\x01\x03\x06\x05\x04\x07\x00\x02\x03\x01"
        "\x06\x05\x04\x07\x00\x03\x01\x02\x06\x05\x04\x07\x00\x03\x02\x01"
        "\x06\x05\x04\x07\x01\x00\x02\x03\x06\x05\x04\x07\x01\x00\x03\x02"
        "\x06\x05\x04\x07\x01\x02\x00\x03\x06\x05\x04\x07\x01\x03\x00\x02"
        "\x06\x05\x04\x07\x02\x00\x01\x03\x06\x05\x04\x07\x02\x00\x03\x01"
        "\x06\x05\x04\x07\x02\x01\x00\x03\x06\x05\x04\x07\x02\x03\x00\x01"
        "\x06\x05\x07\x00\x01\x02\x03\x04\x06\x05\x07\x00\x01\x02\x04\x03"
        "\x06\x05\x07\x00\x01\x03\x02\x04\x06\x05\x07\x00\x01\x03\x04\x02"
        "\x06\x05\x07\x00\x02\x01\x03\x04\x06\x05\x07\x00\x02\x01\x04\x03"
        "\x06\x05\x07\x00\x02\x03\x01\x04\x06\x05\x07\x00\x02\x03\x04\x01"
        "\x06\x05\x07\x01\x00\x02\x03\x04\x06\x05\x07\x01\x00\x02\x04\x03"
        "\x06\x05\x07\x01\x00\x03\x02\x04\x06\x05\x07\x01\x00\x03\x04\x02"
        "\x06\x05\x07\x01\x02\x00\x03\x04\x06\x05\x07\x01\x02\x00\x04\x03"
        "\x06\x05\x07\x01\x02\x03\x00\x04\x06\x07\x00\x01\x02\x03\x04\x05"
        "\x06\x07\x00\x05\x01\x02\x03\x04\x06\x07\x00\x05\x01\x02\x04\x03"
        "\x06\x07\x00\x05\x01\x03\x02\x04\x06\x07\x00\x05\x01\x03\x04\x02"
        "\x06\x07\x00\x05\x02\x01\x03\x04\x06\x07\x00\x05\x02\x01\x04\x03"
        "\x06\x07\x00\x05\x02\x03\x01\x04\x06\x07\x00\x05\x02\x03\x04\x01"
        "\x06\x07\x04\x00\x01\x02\x03\x05\x06\x07\x04\x00\x01\x03\x02\x05"
        "\x06\x07\x04\x00\x02\x01\x03\x05\x06\x07\x04\x00\x02\x03\x01\x05"
        "\x06\x07\x04\x01\x00\x02\x03\x05\x06\x07\x04\x01\x00\x03\x02\x05"
        "\x06\x07\x04\x01\x02\x00\x03\x05\x06\x07\x04\x01\x02\x03\x00\x05"
        "\x06\x07\x04\x05\x00\x01\x02\x03\x06\x07\x04\x05\x00\x01\x03\x02"
        "\x06\x07\x04\x05\x00\x02\x01\x03\x06\x07\x04\x05\x00\x02\x03\x01"
        "\x06\x07\x04\x05\x00\x03\x01\x02\x06\x07\x04\x05\x00\x03\x02\x01"
        "\x06\x07\x04\x05\x01\x00\x02\x03\x06\x07\x04\x05\x01\x00\x03\x02"
        "\x06\x07\x04\x05\x01\x02\x00\x03\x06\x07\x04\x05\x01\x03\x00\x02"
        "\x06\x07\x04\x05\x02\x00\x01\x03\x06\x07\x04\x05\x02\x00\x03\x01"
        "\x06\x07\x04\x05\x02\x01\x00\x03\x06\x07\x04\x05\x02\x03\x00\x01"
        "\x06\x07\x05\x00\x01\x02\x03\x04\x06\x07\x05\x00\x01\x02\x04\x03"
        "\x06\x07\x05\x00\x01\x03\x02\x04\x06\x07\x05\x00\x01\x03\x04\x02"
        "\x06\x07\x05\x00\x02\x01\x03\x04\x06\x07\x05\x00\x02\x01\x04\x03"
        "\x06\x07\x05\x00\x02\x03\x01\x04\x06\x07\x05\x00\x02\x03\x04\x01"
        "\x06\x07\x05\x01\x00\x02\x03\x04\x06\x07\x05\x01\x00\x02\x04\x03"
        "\x06\x07\x05\x01\x00\x03\x02\x04\x06\x07\x05\x01\x00\x03\x04\x02"
        "\x06\x07\x05\x01\x02\x00\x03\x04\x06\x07\x05\x01\x02\x00\x04\x03"
        "\x06\x07\x05\x01\x02\x03\x00\x04";
const static unsigned short
    encshort[] = {
        0x0381, 0x0172, 0x0096, 0x0117, 0x02ca, 0x0467, 0x03ce, 0x007a,
        0x0157, 0x01f1, 0x0317, 0x0255, 0x0295, 0x02c2, 0x0306, 0x0266,
        0x0367, 0x0278, 0x03e5, 0x0109, 0x0002, 0x038d, 0x0370, 0x01b7,
        0x03e1, 0x0092, 0x01b1, 0x026e, 0x010e, 0x00fd, 0x03e4, 0x046e,
        0x014a, 0x0289, 0x0003, 0x0086, 0x0431, 0x0134, 0x014e, 0x0284,
        0x03c0, 0x010c, 0x0418, 0x047c, 0x02e5, 0x04a4, 0x007b, 0x021b,
        0x019e, 0x044c, 0x0325, 0x023e, 0x04ec, 0x0280, 0x008a, 0x0030,
        0x0218, 0x029c, 0x0012, 0x04d8, 0x023f, 0x03ef, 0x014d, 0x00b8,
        0x0148, 0x04ac, 0x043d, 0x0291, 0x01a6, 0x02b6, 0x049d, 0x027e,
        0x00ee, 0x0213, 0x0233, 0x0321, 0x02fd, 0x013f, 0x0122, 0x01e5,
        0x0499, 0x04a2, 0x01d9, 0x01ac, 0x03ff, 0x0160, 0x017e, 0x0199,
        0x017d, 0x03fc, 0x02b8, 0x044a, 0x0403, 0x01ff, 0x04bc, 0x0498,
        0x03f4, 0x02da, 0x0485, 0x0067, 0x02c5, 0x00ce, 0x01d8, 0x03b2,
        0x0048, 0x0383, 0x02cd, 0x0100, 0x01ab, 0x0260, 0x00ba, 0x03a9,
        0x0378, 0x0458, 0x013a, 0x0356, 0x0281, 0x02df, 0x02e8, 0x021a,
        0x019c, 0x0256, 0x00a2, 0x04d2, 0x0185, 0x01ae, 0x0114, 0x00a4,
        0x007e, 0x030e, 0x0235, 0x01d0, 0x0173, 0x0095, 0x0357, 0x0053,
        0x020a, 0x000a, 0x01e8, 0x026f, 0x0481, 0x01b6, 0x02c7, 0x001d,
        0x01e3, 0x0074, 0x01fa, 0x00c1, 0x0008, 0x00bd, 0x031d, 0x02f2,
        0x0371, 0x000c, 0x0476, 0x018d, 0x0203, 0x037a, 0x0088, 0x011b,
        0x035b, 0x00e4, 0x0487, 0x029a, 0x0210, 0x01d2, 0x03c8, 0x048b,
        0x045a, 0x0276, 0x0347, 0x028c, 0x02b5, 0x0414, 0x043f, 0x0131,
        0x005c, 0x0225, 0x0320, 0x02a7, 0x0128, 0x0177, 0x0344, 0x01cc,
        0x004c, 0x0183, 0x002e, 0x02c6, 0x0497, 0x03af, 0x03d0, 0x0136,
        0x015f, 0x0337, 0x0388, 0x0121, 0x0211, 0x00b1, 0x0110, 0x03e3,
        0x0153, 0x0168, 0x042c, 0x00a5, 0x0189, 0x0217, 0x01eb, 0x013d,
        0x01a2, 0x0077, 0x0228, 0x01e2, 0x03a5, 0x0332, 0x0181, 0x003c,
        0x04ae, 0x00cd, 0x026a, 0x04ba, 0x0221, 0x03ca, 0x03cd, 0x0335,
        0x0423, 0x0006, 0x0451, 0x0097, 0x03d8, 0x02e7, 0x03a1, 0x024c,
        0x02f8, 0x0123, 0x0393, 0x0036, 0x005b, 0x0060, 0x00e8, 0x041f,
        0x0417, 0x04d4, 0x02f0, 0x03d7, 0x032a, 0x0195, 0x04b1, 0x00f4,
        0x016f, 0x03f0, 0x01d4, 0x02de, 0x0369, 0x0339, 0x017c, 0x0379,
        0x00f3, 0x0178, 0x0046, 0x01ea, 0x0294, 0x0310, 0x03dc, 0x035f,
        0x044b, 0x01bd, 0x0193, 0x0264, 0x04b6, 0x045d, 0x000f, 0x0382,
        0x02ed, 0x0022, 0x00e6, 0x03c3, 0x046c, 0x00e5, 0x015d, 0x02e3,
        0x0069, 0x03b4, 0x02d0, 0x0068, 0x0062, 0x040d, 0x0248, 0x0273,
        0x0445, 0x0083, 0x048a, 0x01db, 0x0495, 0x03be, 0x0330, 0x00c0,
        0x0056, 0x0105, 0x030f, 0x025c, 0x001e, 0x049c, 0x01ed, 0x0028,
        0x03d2, 0x0082, 0x0422, 0x03dd, 0x02b3, 0x0164, 0x0057, 0x0212,
        0x04ca, 0x0196, 0x01f0, 0x0454, 0x00ea, 0x00f8, 0x003e, 0x0240,
        0x012f, 0x02cc, 0x036c, 0x0163, 0x02fa, 0x02f1, 0x03ab, 0x01f8,
        0x04e5, 0x01c0, 0x0241, 0x022b, 0x04c5, 0x04a7, 0x04c9, 0x034d,
        0x009c, 0x0251, 0x0259, 0x004e, 0x01c2, 0x0307, 0x04c1, 0x015a,
        0x02e0, 0x0368, 0x0489, 0x01ec, 0x02f3, 0x0267, 0x04c6, 0x02b9,
        0x01dd, 0x0052, 0x0319, 0x0254, 0x0448, 0x0299, 0x0149, 0x041d,
        0x0072, 0x0324, 0x0312, 0x0359, 0x04dc, 0x0315, 0x03aa, 0x01a9,
        0x022a, 0x0443, 0x02b7, 0x017a, 0x01af, 0x0040, 0x0353, 0x047f,
        0x01f5, 0x0219, 0x025f, 0x00db, 0x03c9, 0x02d1, 0x01be, 0x00a0,
        0x01aa, 0x0214, 0x0412, 0x0355, 0x0316, 0x01f2, 0x025b, 0x031c,
        0x0127, 0x03b0, 0x042a, 0x02aa, 0x001f, 0x02b4, 0x0041, 0x02e1,
        0x02bb, 0x00ec, 0x0270, 0x0009, 0x0490, 0x032d, 0x024e, 0x03cc,
        0x0139, 0x0133, 0x01fd, 0x00d3, 0x044e, 0x032f, 0x01da, 0x0400,
        0x03fe, 0x0190, 0x019a, 0x0380, 0x0150, 0x03c2, 0x034f, 0x002b,
        0x032b, 0x0279, 0x0287, 0x0346, 0x04b0, 0x013e, 0x04ab, 0x040a,
        0x0465, 0x0361, 0x049e, 0x01f9, 0x040e, 0x01a4, 0x00a3, 0x0050,
        0x0076, 0x0430, 0x02bf, 0x0184, 0x00b7, 0x02c4, 0x048e, 0x01a5,
        0x041a, 0x02e4, 0x032c, 0x009b, 0x02c0, 0x0470, 0x0376, 0x0475,
        0x04d7, 0x029e, 0x039d, 0x01f6, 0x03a0, 0x0224, 0x0094, 0x01d3,
        0x0043, 0x03b3, 0x017b, 0x03d6, 0x0071, 0x017f, 0x03ac, 0x02db,
        0x0410, 0x0078, 0x0283, 0x00f5, 0x03b1, 0x02a4, 0x016c, 0x0437,
        0x02d8, 0x003f, 0x04bf, 0x046b, 0x004a, 0x006f, 0x0354, 0x0032,
        0x0170, 0x0011, 0x029f, 0x01c6, 0x03a2, 0x03ba, 0x02a2, 0x006c,
        0x0488, 0x036d, 0x03fd, 0x0331, 0x0034, 0x01f7, 0x00d6, 0x0147,
        0x0200, 0x04a9, 0x02c8, 0x00c3, 0x03e8, 0x01e1, 0x00df, 0x043c,
        0x049a, 0x02d6, 0x00e2, 0x0104, 0x04b7, 0x028d, 0x04e7, 0x006a,
        0x01ca, 0x0452, 0x03fb, 0x0409, 0x03ae, 0x0179, 0x02a0, 0x022e,
        0x01c4, 0x033a, 0x0145, 0x049f, 0x0250, 0x0314, 0x0045, 0x0411,
        0x027c, 0x00bf, 0x0015, 0x0348, 0x0274, 0x02cb, 0x0151, 0x0473,
        0x0292, 0x04c3, 0x0031, 0x03eb, 0x0349, 0x024d, 0x04ce, 0x0268,
        0x0262, 0x039e, 0x012c, 0x0141, 0x012e, 0x004f, 0x049b, 0x002a,
        0x03a6, 0x0434, 0x00e7, 0x01d7, 0x00d8, 0x0358, 0x0026, 0x0408,
        0x020c, 0x0326, 0x0066, 0x04e3, 0x02eb, 0x039f, 0x007d, 0x0343,
        0x01d6, 0x0226, 0x0209, 0x00ef, 0x020d, 0x0323, 0x01fb, 0x0005,
        0x02f9, 0x0058, 0x018c, 0x01b0, 0x01c5, 0x024b, 0x009d, 0x03df,
        0x02b1, 0x04aa, 0x0446, 0x0390, 0x03b6, 0x005d, 0x031b, 0x0329,
        0x0143, 0x0420, 0x04cd, 0x035d, 0x04e8, 0x00e0, 0x02f5, 0x0302,
        0x0425, 0x01fe, 0x0044, 0x00bb, 0x0201, 0x01bf, 0x0103, 0x01c3,
        0x03f1, 0x02a9, 0x0432, 0x00d7, 0x033d, 0x0198, 0x027f, 0x0017,
        0x0392, 0x00d5, 0x0484, 0x0098, 0x01a8, 0x02ba, 0x0064, 0x0019,
        0x0107, 0x04b3, 0x0450, 0x0406, 0x0242, 0x0439, 0x03db, 0x0318,
        0x0480, 0x0208, 0x006d, 0x03f9, 0x0305, 0x00bc, 0x008e, 0x0236,
        0x018f, 0x02d3, 0x0433, 0x0000, 0x04b2, 0x0303, 0x0377, 0x0486,
        0x022f, 0x008c, 0x0334, 0x0223, 0x0144, 0x029b, 0x04ee, 0x0252,
        0x026c, 0x010f, 0x0341, 0x0054, 0x03f7, 0x018b, 0x043e, 0x010b,
        0x036e, 0x03f8, 0x02b0, 0x0023, 0x0186, 0x0338, 0x0206, 0x0158,
        0x04be, 0x00b5, 0x0102, 0x01cd, 0x00a9, 0x0063, 0x03f3, 0x030d,
        0x00c6, 0x0428, 0x04e1, 0x0253, 0x0020, 0x031f, 0x011d, 0x012a,
        0x00ae, 0x025a, 0x04b9, 0x0301, 0x019d, 0x0246, 0x020f, 0x020e,
        0x0296, 0x0194, 0x015c, 0x02d5, 0x0360, 0x03bd, 0x0397, 0x021f,
        0x014b, 0x04ea, 0x023d, 0x01f3, 0x0449, 0x0389, 0x03b8, 0x0187,
        0x0197, 0x01ad, 0x00dc, 0x004d, 0x02fe, 0x014f, 0x0258, 0x03ad,
        0x041c, 0x00ac, 0x048d, 0x0055, 0x03b7, 0x02a1, 0x0075, 0x01cf,
        0x0461, 0x0304, 0x02ad, 0x00af, 0x0231, 0x04e0, 0x023b, 0x0042,
        0x027a, 0x0463, 0x0483, 0x033e, 0x0118, 0x0282, 0x0130, 0x0455,
        0x00d2, 0x02ae, 0x0132, 0x02c9, 0x02d2, 0x0018, 0x038c, 0x0375,
        0x0202, 0x0227, 0x0111, 0x0340, 0x03ed, 0x0161, 0x01fc, 0x0402,
        0x0364, 0x0401, 0x0491, 0x009a, 0x0462, 0x0366, 0x04e2, 0x03f5,
        0x01bc, 0x015b, 0x02f4, 0x0350, 0x03c1, 0x042b, 0x028a, 0x04d9,
        0x039b, 0x0084, 0x009e, 0x02c3, 0x01b9, 0x00c9, 0x02ec, 0x00c8,
        0x00fa, 0x0288, 0x03c7, 0x036b, 0x04ed, 0x04a8, 0x0365, 0x0247,
        0x02f6, 0x00e1, 0x0146, 0x04ad, 0x04c2, 0x032e, 0x045f, 0x00c2,
        0x0142, 0x0328, 0x0004, 0x00f2, 0x00ca, 0x0482, 0x040c, 0x038b,
        0x04a5, 0x048f, 0x0384, 0x00ab, 0x0180, 0x00a7, 0x011c, 0x04a6,
        0x0033, 0x04c8, 0x01e6, 0x030c, 0x04b8, 0x002f, 0x036a, 0x03cb,
        0x01a7, 0x005a, 0x0387, 0x034e, 0x0079, 0x0436, 0x04e6, 0x02dd,
        0x0478, 0x028e, 0x0175, 0x0352, 0x0090, 0x00fc, 0x04e9, 0x0207,
        0x0166, 0x00f9, 0x0232, 0x0113, 0x003d, 0x04ef, 0x0135, 0x0447,
        0x0263, 0x01a3, 0x0204, 0x02d7, 0x00d9, 0x0038, 0x01de, 0x037d,
        0x00c5, 0x0220, 0x00be, 0x03c4, 0x0249, 0x033c, 0x03b9, 0x000b,
        0x01b4, 0x0460, 0x022d, 0x03d5, 0x03bb, 0x03a3, 0x02d4, 0x03bf,
        0x0010, 0x02ab, 0x038e, 0x04e4, 0x025e, 0x0474, 0x03cf, 0x0472,
        0x02af, 0x00ff, 0x01b8, 0x01e0, 0x0116, 0x0427, 0x0363, 0x0156,
        0x01e4, 0x02ff, 0x042d, 0x00b9, 0x02c1, 0x021e, 0x027d, 0x0120,
        0x00f1, 0x01e7, 0x044f, 0x03ee, 0x005f, 0x0479, 0x041b, 0x0001,
        0x03e6, 0x0124, 0x036f, 0x00d0, 0x03b5, 0x024f, 0x0373, 0x02ea,
        0x042e, 0x01c1, 0x002d, 0x0126, 0x010a, 0x0013, 0x04a0, 0x019b,
        0x0385, 0x0081, 0x011e, 0x0169, 0x04d5, 0x011a, 0x02f7, 0x001b,
        0x0192, 0x0125, 0x00fb, 0x04cc, 0x0244, 0x023c, 0x0469, 0x00e9,
        0x0154, 0x03de, 0x03a4, 0x040f, 0x0362, 0x0021, 0x03f6, 0x043b,
        0x02be, 0x00b4, 0x00f6, 0x00fe, 0x0293, 0x026d, 0x037e, 0x0396,
        0x0333, 0x0215, 0x047b, 0x0174, 0x03bc, 0x0342, 0x009f, 0x0440,
        0x00b6, 0x0391, 0x0024, 0x00b0, 0x005e, 0x046f, 0x02ac, 0x0457,
        0x0119, 0x006b, 0x0014, 0x01a0, 0x035c, 0x0051, 0x016b, 0x030b,
        0x0466, 0x0494, 0x0374, 0x04b5, 0x0239, 0x031a, 0x045b, 0x0162,
        0x00e3, 0x03ec, 0x02a6, 0x0386, 0x02e2, 0x00a8, 0x0027, 0x01a1,
        0x04bd, 0x011f, 0x031e, 0x039a, 0x0308, 0x01dc, 0x0101, 0x0309,
        0x047a, 0x0137, 0x04d3, 0x007c, 0x034c, 0x00cb, 0x0404, 0x038f,
        0x0438, 0x045e, 0x00a6, 0x0416, 0x01df, 0x024a, 0x0087, 0x04c7,
        0x018a, 0x0277, 0x016a, 0x0424, 0x03a7, 0x0112, 0x0286, 0x0106,
        0x008d, 0x0413, 0x03d1, 0x00cc, 0x0049, 0x0300, 0x00ad, 0x046a,
        0x0471, 0x0230, 0x0047, 0x0468, 0x028b, 0x0089, 0x02bd, 0x0039,
        0x02a8, 0x0351, 0x000e, 0x01c7, 0x04c0, 0x00de, 0x037f, 0x026b,
        0x025d, 0x0245, 0x0167, 0x014c, 0x0237, 0x04cf, 0x023a, 0x01bb,
        0x0311, 0x0421, 0x008b, 0x012d, 0x0336, 0x04df, 0x02a3, 0x0080,
        0x0016, 0x0395, 0x0129, 0x00f7, 0x022c, 0x03e7, 0x044d, 0x04dd,
        0x02dc, 0x0165, 0x0297, 0x0029, 0x0435, 0x0037, 0x001c, 0x00da,
        0x0407, 0x04b4, 0x047d, 0x02bc, 0x0269, 0x04de, 0x01ee, 0x0399,
        0x0444, 0x0152, 0x0394, 0x002c, 0x0442, 0x003a, 0x02ef, 0x001a,
        0x00b2, 0x007f, 0x0265, 0x008f, 0x021c, 0x0492, 0x03d3, 0x03da,
        0x02ee, 0x01e9, 0x0035, 0x003b, 0x0272, 0x01c9, 0x00b3, 0x0261,
        0x015e, 0x0464, 0x030a, 0x021d, 0x038a, 0x0234, 0x042f, 0x04a1,
        0x0025, 0x0313, 0x016d, 0x0243, 0x0155, 0x02e9, 0x00f0, 0x0327,
        0x048c, 0x0176, 0x0085, 0x0238, 0x00d1, 0x00aa, 0x01d5, 0x00c7,
        0x0191, 0x04cb, 0x047e, 0x03e2, 0x02cf, 0x0298, 0x013b, 0x0093,
        0x0456, 0x033f, 0x04a3, 0x03ea, 0x04db, 0x0171, 0x0426, 0x04eb,
        0x012b, 0x0372, 0x00d4, 0x0405, 0x045c, 0x03c5, 0x01cb, 0x04d0,
        0x0453, 0x0188, 0x035a, 0x0345, 0x0398, 0x0007, 0x0493, 0x039c,
        0x03d4, 0x0429, 0x04af, 0x0496, 0x01b3, 0x0419, 0x02b2, 0x0140,
        0x019f, 0x0271, 0x0205, 0x01ba, 0x0290, 0x004b, 0x0322, 0x01b5,
        0x0070, 0x00dd, 0x0285, 0x0216, 0x02ce, 0x02fb, 0x006e, 0x00a1,
        0x04bb, 0x01b2, 0x041e, 0x0182, 0x034a, 0x0159, 0x0415, 0x0275,
        0x020b, 0x00cf, 0x046d, 0x0065, 0x01c8, 0x04c4, 0x02e6, 0x00eb,
        0x0073, 0x0222, 0x040b, 0x04d6, 0x03d9, 0x034b, 0x0441, 0x029d,
        0x01f4, 0x0115, 0x0091, 0x0138, 0x028f, 0x037c, 0x010d, 0x04da,
        0x02fc, 0x037b, 0x04f0, 0x033b, 0x043a, 0x03c6, 0x01ce, 0x0059,
        0x027b, 0x03e0, 0x03fa, 0x0477, 0x0099, 0x01ef, 0x0229, 0x03f2,
        0x000d, 0x04d1, 0x02a5, 0x03e9, 0x013c, 0x016e, 0x01d1, 0x035e,
        0x0108, 0x0459, 0x00c4, 0x00ed, 0x0061, 0x0257, 0x03a8, 0x018e,
        0x02d9 };



void encmain_decode(speed_challenge_net_context *ctx, unsigned char *data, int size) {
    int             i,
                    x1,
                    x2;
    unsigned char   tmp[8];

    while(size) {
        x1 = encshort[ctx->ecx44];
        ctx->ecx44++;
        if(ctx->ecx44 > 1264) ctx->ecx44 = 0;

        if(size < 8) {
            memcpy(tmp, data, size);
            for(i = 0; i < 8; i++) {
                x2 = encbyte[(x1 << 3) + i];
                if(x2 < size) *data++ = tmp[x2];
            }
            break;
        }

        memcpy(tmp, data, 8);
        for(i = 0; i < 8; i++) {
            *data++ = tmp[encbyte[(x1 << 3) + i]];
        }

        size -= 8;
    }
}



void encmain_encode(speed_challenge_net_context *ctx, unsigned char *data, int size) {
    int             i,
                    x1,
                    x2;
    unsigned char   tmp[8],
                    *tmpfast;

    while(size) {
        x1 = encshort[ctx->ecx44];
        ctx->ecx44++;
        if(ctx->ecx44 > 1264) ctx->ecx44 = 0;

        tmpfast = tmp;

        if(size < 8) {
            memcpy(tmp, data, size);
            for(i = 0; i < 8; i++) {
                x2 = encbyte[(x1 << 3) + i];
                if(x2 < size) data[x2] = *tmpfast++;
            }
            break;
        }

        memcpy(tmp, data, 8);
        for(i = 0; i < 8; i++) {
            data[encbyte[(x1 << 3) + i]] = *tmpfast++;
        }

        data += 8;
        size -= 8;
    }
}



void strings_scramble(speed_challenge_net_context *ctx, unsigned char *data, int size) {
    #define XECXDOIT(x, y)  *data ^= x[ctx->ecx[y]]; \
                            ctx->ecx[y]++; \
                            if(ctx->ecx[y] == (sizeof(x) - 1)) { \
                                ctx->ecx[y] = 0; \
                            }

    while(size--) {
        XECXDOIT(X4d4638, 0);
        XECXDOIT(X4d4660, 1);
        XECXDOIT(X4d468c, 2);
        XECXDOIT(X4d46bc, 3);
        XECXDOIT(X4d46f4, 4);
        XECXDOIT(X4d4720, 5);
        XECXDOIT(X4d4754, 6);
        XECXDOIT(X4d4788, 7);
        data++;
    }

    #undef XECXDOIT
}



void speed_challenge_net_init(speed_challenge_net_context *ctx) {
    int     i;

    for(i = 0; i < 8; i++) ctx->ecx[i] = 0;
    ctx->ecx44 = 0;
}



void speed_challenge_net_decode(speed_challenge_net_context *ctx, unsigned char *data, int size) {
    int     tmp,
            rest;

    strings_scramble(ctx, data, size);

    encmain_decode(ctx, data, size);

    rest = size - 1;
    tmp = *data & 0xf;
    while(rest--) {
        *data ^= (*data ^ *(data + 1)) & 0xf;
        data++;
    }
    *data = (*data & 0xf0) | tmp;

    rest = size - 1;
    while(rest--) {
        *data ^= *(data - 1);
        data--;
    }
}



void speed_challenge_net_encode(speed_challenge_net_context *ctx, unsigned char *data, int size) {
    int     tmp,
            rest;

    data++;
    rest = size - 1;
    while(rest--) {
        *data ^= *(data - 1);
        data++;
    }

    data--;
    rest = size - 1;
    tmp = *data & 0xf;
    while(rest--) {
        *data ^= (*data ^ *(data - 1)) & 0xf;
        data--;
    }
    *data = (*data & 0xf0) | tmp;

    encmain_encode(ctx, data, size);

    strings_scramble(ctx, data, size);
}


