/*

Speed Challenge network encryption/decryption algorithm 0.2
by Luigi Auriemma
e-mail: aluigi@autistici.org
web:    aluigi.org


INTRODUCTION
============
This file contains the algorithm needed to encrypt and decrypt any data
sent and received by the Ubisoft game called Speed Challenge.
This game uses an algorithm probably called CSimpleCrypt and it seems to
be used only by this game.

The data is contained in the TCP stream and is composed by:

  |##|##########################################|
  |  |
  |  data_block
  size of the block (big-endian format, 16 bits)

  Example:  00 04 11 22 33 44


USAGE
=====
The algorithm is composed by 3 functions:

- speed_challenge_net_init()
  --------------------------
  used to initialize the global variables needed for the
  encryption/decryption.
  You MUST call this function each time a new connection is made and
  NEVER during the connection.
  Arguments:
  - context:         it is a structure that contains the current
                     parameters for the encryption/decryption, in fact
                     they change each time that data is handled.
                     You must use a context for each TCP stream so one
                     for the client and another for the server.

- speed_challenge_net_decode()
  ----------------------------
  used to decrypt the data block
  Arguments:
  - context:         the same structure as above
  - data_block:      the data
  - data_block_size: its length

- speed_challenge_net_encode()
  ----------------------------
  used to encrypt the data block
  Arguments: just as above


USAGE EXAMPLE
=============
I have written some tools that explain how to use my functions, watch
on my website in the Research and Fake_Players_Bug sections.


LICENSE
=======
    Copyright 2004,2005,2006 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl.txt

*/



typedef struct {
    unsigned char   ecx[8];
    int             ecx44;
} speed_challenge_net_context;



void speed_challenge_net_init(
    speed_challenge_net_context *ctx
);

void speed_challenge_net_encode(
    speed_challenge_net_context *ctx,
    unsigned char *data,
    int size
);

void speed_challenge_net_decode(
    speed_challenge_net_context *ctx,
    unsigned char *data,
    int size
);


