/*
  by Luigi Auriemma
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>



#define VER     "0.1a"



void sg_filefolder(char *buff, int decenc) {    // encodes or decodes the names of files and folders
    static char tab[] = "bafedcgnmlopxwuvtsrqkjihzy";
    char    *p,
            a;

    for(p = buff; (a = *p); p++) {
        if((a - 0x41) <= 25) a += 0x20; // tolower(), this is exactly as in the code
        if((a >= 'a') && (a <= 'z')) {
            if(decenc) {    // encoding
                a = tab[a - 'a'];
            } else {        // decoding
                a = 'a' + (strchr(tab, a) - tab);
            }
        }
        *p = a;
    }
}



void sg_files_dec(unsigned char *buff, int len) {
    int     i;

    for(i = 0; i < len; i++) {
        if(buff[i] & 1) {
            buff[i]--;
        } else {
            buff[i]++;
        }
    }
}



void check_overwrite(char *fname) {
    FILE    *fd;
    char    ans[16];

    fd = fopen(fname, "rb");
    if(!fd) return;
    fclose(fd);
    printf("  the file already exists, do you want to overwrite it (y/N)? ");
    fgets(ans, sizeof(ans), stdin);
    if(tolower(ans[0]) != 'y') exit(1);
}



void std_err(void) {
    perror("\nError");
    exit(1);
}



int main(int argc, char *argv[]) {
    typedef struct {
        unsigned int    boh;
        unsigned int    header_size;
    } sgp_t;

    sgp_t   sgp;
    FILE    *fd,
            *fdo;
    int     len;
    unsigned char   *buff,
            *file_in,
            *file_out;

    fputs("\n"
        "Spike Girls SGP* files decoder "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <input_file> <output_file>\n"
            "\n", argv[0]);
        exit(1);
    }

    file_in  = argv[1];
    file_out = argv[2];

    if(!strcmp(file_out, ".")) {
        sg_filefolder(file_in, 0);
        printf("- decoded name: %s\n", file_in);
        return(0);
    }

    printf("- open file %s\n", file_in);
    fd = fopen(file_in, "rb");
    if(!fd) std_err();

    printf("- create file %s\n", file_out);
    check_overwrite(file_out);
    fdo = fopen(file_out, "wb");
    if(!fdo) std_err();

    if(fread(&sgp, 1, sizeof(sgp_t), fd) != sizeof(sgp_t)) exit(1);
    printf("- encoded header size of %08x bytes\n", sgp.header_size);
    buff = malloc(sgp.header_size);
    if(!buff) std_err();

    len = fread(buff, 1, sgp.header_size, fd);
    sg_files_dec(buff, len);
    fwrite(buff, 1, len, fdo);

    while((len = fread(buff, 1, sgp.header_size, fd))) {
        fwrite(buff, 1, len, fdo);  // copy the rest of the file
    }

    fclose(fd);
    fclose(fdo);
    printf("- done\n");
    return(0);
}

