/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>



#define VER     "0.1"
#define OKKO    "\x00\x00\x01\x01\x00\x00\x01\x01" \
                "\x01\x01\x01\x01\x01\x01\x01\x01" \
                "\x01\x01\x00\x00\x01\x00\x01\x00" \
                "\x00\x01\x00\x01\x01\x00\x01\x00" \
                "\x01\x00\x01\x01\x00\x00\x01\x00"



int main(int argc, char *argv[]) {
    int             i,
                    slen;
    unsigned char   cdkey[19],
                    *ptr,
                    *ptr1;
    unsigned int   eax,
                    ecx,
                    edx,
                    final;



    setbuf(stdout, NULL);

    fputs("\n"
        "CD-Key checker for Soldier of fortune II "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);


    if(argc < 2) {
        printf("\nUsage: %s <SOF2-key>\n"
            "\n", argv[0]);
        exit(1);
    }


    slen = strlen(argv[1]);
    ptr = argv[1];
    ptr1 = cdkey;
    for(eax = 0, i = 0; i < slen; i++, ptr++) {
        if(*ptr == '-') continue;
        *ptr1 = *ptr;
        ptr1++;
        eax++;
        if(eax == 19) {
            fputs("\nError: CD-Key must be 18 bytes long (yours is major)\n", stdout);
            exit(1);
        }
    }
    if(eax < 18) {
        fputs("\nError: CD-Key must be 18 bytes long (yours is minor)\n", stdout);
        exit(1);
    }
    *ptr1 = 0;


    sscanf(cdkey + 16, "%02lX", &final);
    edx = 0;
    ptr = cdkey;
    for(i = 0; i < 16; i++) {
        if((*ptr >= 0x61) && (*ptr <= 0x7a)) *ptr += 0xe0;
        ecx = *ptr - 0x33;
        if(ecx > 0x27) break;
        if(OKKO[ecx]) break;
        edx <<= 1;
        edx ^= *ptr;
        ptr++;
    }

    edx &= 0xff;
    if((i == 16) && (edx == final)) fputs("\nYour Cd-Key is OK\n\n", stdout);
        else fputs("\nYour Cd-Key is invalid\n\n", stdout);
    return(0);
}



