/*
    Copyright 2009 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl-2.0.txt
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ctype.h>
#include <sys/stat.h>
#include <time.h>

typedef uint8_t     u8;
typedef uint32_t    u32;



#define VER         "0.1"



void tdu_xtea_encrypt(u8 *data, int datalen, u8 *key, int type);
int tdu_xtea_decrypt(u8 *data, int datalen, u8 *key, int type);
u8 *fdload(u8 *fname, int *fsize);
void fddump(u8 *fname, u8 *data, int datasz);
void std_err(void);



int main(int argc, char *argv[]) {
    int     type    = 0,
            buffsz;
    u8      key[] =
                "\x2C\x43\xEA\x64\x24\x5B\xA3\xF8\x81\xCD\x8E\x01\xAC\xBE\x26\x83"  // savegame
                "\x4A\x3C\xE2\x4F\x11\xC2\xBA\x80\x3A\xBD\x17\x69\xBD\x8E\x52\xF0", // others + special type
            *buff,
            *enc,
            *fin,
            *fout;

    fputs("\n"
        "Test Drive Unlimited savegames/files decrypter/encrypter "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 4) {
        printf("\n"
            "Usage: %s <d/e> <input> <output> [type]\n"
            "\n"
            "by default type is set to 0 for decrypting the savegame/playersave files,\n"
            "use 1 as type for decrypting other files (like .btrq, .db and so on)\n"
            "\n", argv[0]);
        exit(1);
    }

    enc  = argv[1];
    fin  = argv[2];
    fout = argv[3];
    if(argc > 4) type = atoi(argv[4]);

    buff = fdload(fin, &buffsz);

    printf("- %d bytes\n", buffsz);
    printf("- %s type\n", type ? "non-savegame" : "savegame");

    if(tolower(enc[0]) == 'd') {
        buffsz = tdu_xtea_decrypt(buff, buffsz, key, type);
    } else {
        if(type) {
            buffsz += 8;
            buff = realloc(buff, buffsz);
            memmove(buff + 8, buff, buffsz - 8);
            *(u32 *)buff       = time(NULL);
            *(u32 *)(buff + 4) = ~time(NULL);
        }
        tdu_xtea_encrypt(buff, buffsz, key, type);
    }

    fddump(fout, buff, buffsz);
    printf("- done\n");
    free(buff);
    return(0);
}



void tdu_xtea_encrypt(u8 *data, int datalen, u8 *key, int type) {
    u32     *d, *k, y, z, i, sum;
    int     blocks;

    if(datalen < 8) return;
    if(type) {
        key += 16;
        datalen -= 8;
    }
    d = (u32 *)data;
    k = (u32 *)key;
    for(blocks = datalen >> 3; blocks; blocks--) {
        if(type) {
            y = d[0] ^ d[2];
            z = d[1] ^ d[3];
        } else {
            y = d[0];
            z = d[1];
        }

        sum = 0;
        for(i = 0; i < 32; i++) {
            y += (z + ((z >> 5) ^ (z << 4))) ^ (sum + k[sum & 3]);
            sum -= 0x61c88647;
            z += (y + ((y >> 5) ^ (y << 4))) ^ (sum + k[(sum >> 11) & 3]);
        }

        if(type) {
            d[2] = y;
            d[3] = z;
        } else {
            d[0] = y;
            d[1] = z;
        }
        d += 2;
    }
}



int tdu_xtea_decrypt(u8 *data, int datalen, u8 *key, int type) {
    u32     *d, *k, y, z, i, sum;
    int     blocks;

    if(datalen < 8) return(0);
    if(type) {
        key += 16;
        datalen -= 8;
    }
    d = (u32 *)data;
    k = (u32 *)key;
    for(blocks = datalen >> 3; blocks; blocks--) {
        if(type) {
            y = d[2];
            z = d[3];
        } else {
            y = d[0];
            z = d[1];
        }

        sum = 0xc6ef3720;
        for(i = 0; i < 32; i++) {
            z -= (y + ((y >> 5) ^ (y << 4))) ^ (sum + k[(sum >> 11) & 3]);
            sum += 0x61c88647;
            y -= (z + ((z >> 5) ^ (z << 4))) ^ (sum + k[sum & 3]);
        }

        if(type) {
            d[0] ^= y;
            d[1] ^= z;
        } else {
            d[0] = y;
            d[1] = z;
        }
        d += 2;
    }
    return(datalen);
}



u8 *fdload(u8 *fname, int *fsize) {
    struct stat xstat;
    FILE    *fd;
    int     size;
    u8      *buff;

    printf("- open %s\n", fname);
    fd = fopen(fname, "rb");
    if(!fd) std_err();
    fstat(fileno(fd), &xstat);
    size = xstat.st_size;
    buff = malloc(size);
    if(!buff) std_err();
    fread(buff, 1, size, fd);
    fclose(fd);
    *fsize = size;
    return(buff);
}



int check_overwrite(u8 *fname) {
    FILE    *fd;
    u8      ans[16];

    if(!fname) return(0);
    fd = fopen(fname, "rb");
    if(!fd) return(0);
    fclose(fd);
    printf("- the file already exists, do you want to overwrite it (y/N)? ");
    fgets(ans, sizeof(ans), stdin);
    if(tolower(ans[0]) == 'y') return(0);
    return(-1);
}



void fddump(u8 *fname, u8 *data, int datasz) {
    FILE    *fd;

    printf("- create %s\n", fname);
    if(check_overwrite(fname) < 0) return;
    fd = fopen(fname, "wb");
    if(!fd) std_err();
    fwrite(data, 1, datasz, fd);
    fclose(fd);
}



void std_err(void) {
    perror("\nError");
    exit(1);
}


