/*
    Copyright 2005,2006,2007,2008,2009 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    aint with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl-2.0.txt
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#ifdef WIN32
#else
    #define stricmp strcasecmp
#endif

typedef unsigned char   u8;
typedef unsigned short  u16;
typedef unsigned int    u32;



#define VER         "0.3"



void filecopy(u8 *in, u8 *out);
void tnt_rw(FILE *fd, void *ret_buff, int size, int encrypt);
int tntnameinit(u8 *fname);
int tnt_brute_check(FILE *fd);
void tnt_crypt(u8 *data, int len);
u8 tnt_crypt_init(u8 num);
int myfr(FILE *fd, void *data, int size);
int myfw(FILE *fd, void *data, int size);
int get_num(u8 *str);
void std_err(void);



#pragma pack(2)
typedef struct {
    u32 sign;
    u16 ver;
    u16 flag;
    u16 method;
    u32 timedate;
    u32 crc;
    u32 comp_size;
    u32 uncomp_size;
    u16 name_len;
    u16 extra_len;
    /* filename */
    /* extra */
} local_dir_t;

typedef struct {
    u32 sign;
    u16 ver_made;
    u16 ver_ext;
    u16 flag;
    u16 method;
    u32 timedate;
    u32 crc;
    u32 comp_size;
    u32 uncomp_size;
    u16 name_len;
    u16 extra_len;
    u16 comm_len;
    u16 disk_start;
    u16 int_attr;
    u32 ext_attr;
    u32 offset;
    /* filename */
    /* extra */
    /* comment */
} central_dir_t;

typedef struct {
    u32 sign;
    u16 disk_num;
    u16 disk_num_start;
    u16 tot_ent_disk;
    u16 tot_ent_dir;
    u32 dir_size;
    u32 offset;
    u16 comm_len;
    /* comment */
} end_central_dir_t;
#pragma pack()



int main(int argc, char *argv[]) {
    local_dir_t         local_dir;
    central_dir_t       central_dir;
    end_central_dir_t   end_central_dir;
    FILE    *fd;
    int     i,
            files,
            init,
            encrypt     = 0;
    u8      *iname,
            *oname,
            *p;

    setbuf(stdout, NULL);

    fputs("\n"
        "TNTFOLDER files decrypter/encrypter "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\n"
            "Usage decrypt: %s <input.TNTFOLDER> [output.zip] [init_crypt]\n"
            "Usage encrypt: %s <input.ZIP>       [output.tntFolder] [init_crypt]\n"
            "\n"
            "- if not specified, the output file will have the same name and path of the\n"
            "  input file plus the .zip (decryption) or tntFolder (encryption) extension\n"
            "- if the input file is a zip archive the tool will encrypt it else decrypt it\n"
            "- remember that the filenames are case sensitives, this is important in\n"
            "  encryption mode anyway you can specify it also as third argument (eg 0xa2)\n"
            "\n", argv[0], argv[0]);
        exit(1);
    }

    iname = argv[1];
    p = strrchr(iname, '.');
    if(p && !stricmp(p, ".zip")) {
        encrypt = 1;
    } else {
        encrypt = 0;
    }
    if(!p) p = iname + strlen(iname);

    if(argc > 2) {
        oname = argv[2];
    } else {
        oname = malloc((p - iname) + 32);
        if(!oname) std_err();
        sprintf(oname,
            encrypt ? "%.*s.tntFolder" : "%.*s.zip",
            p - iname, iname);
    }

    printf(
        "- %s activated\n"
        "- input:  %s\n"
        "- output: %s\n",
        encrypt ? "encryption" : "decryption",
        iname, oname);

    printf("- copy the input file to the output one\n");
    filecopy(iname, oname);

    fd = fopen(oname, "r+b");
    if(!fd) std_err();

    if(argc > 3) {
        init = get_num(argv[3]);
        tnt_crypt_init(init);
        printf("- forced init crypt value 0x%02x", init);
    } else {
        printf("- calculate the init crypt value: ");
        init = tntnameinit(iname);
        tnt_crypt_init(init);
        printf("0x%02x\n", init);

        if(!encrypt) {
            i = tnt_brute_check(fd);
            if(i >= 0) init = i;
            tnt_crypt_init(init);
        }
    }

    // the encryption has an exact order which must be respected or it fails
    if(fseek(fd, -sizeof(end_central_dir_t), SEEK_END)) std_err();

    printf("  %08x end_central_dir\n", (u32)ftell(fd));
    tnt_rw(fd, &end_central_dir, sizeof(end_central_dir), encrypt);
    tnt_rw(fd, NULL, end_central_dir.comm_len, encrypt);
    files = end_central_dir.tot_ent_dir;

    if(fseek(fd, end_central_dir.offset, SEEK_SET)) std_err();

    printf("- %08x central_dir:\n", (u32)ftell(fd));
    for(i = 0; i < files; i++) {
        tnt_rw(fd, &central_dir, sizeof(central_dir), encrypt);
        tnt_rw(fd, NULL, central_dir.name_len,  encrypt);
        tnt_rw(fd, NULL, central_dir.extra_len, encrypt);
        tnt_rw(fd, NULL, central_dir.comm_len,  encrypt);
        fputc('.', stdout);
    }

    fseek(fd, 0, SEEK_SET);

    printf("\n- %08x local_dir:\n", (u32)ftell(fd));
    for(i = 0; i < files; i++) {
        tnt_rw(fd, &local_dir, sizeof(local_dir), encrypt);
        tnt_rw(fd, NULL, local_dir.name_len,  encrypt);
        tnt_rw(fd, NULL, local_dir.extra_len, encrypt);
        if(fseek(fd, local_dir.comp_size, SEEK_CUR)) std_err(); // only the zip headers are encrypted
        fputc('.', stdout);
    }

    fclose(fd);
    printf("\n- %d files found in the zip\n", files);
    return(0);
}



void filecopy(u8 *in, u8 *out) {
    FILE    *fdi,
            *fdo;
    int     len;
    u8      buff[4096];

    if(!strcmp(in, "-")) {
        fdi = stdin;
    } else {
        fdi = fopen(in,  "rb");
        if(!fdi) std_err();
    }

    fdo = fopen(out, "rb");
    if(fdo) {
        fclose(fdo);
        printf("- the output file already exists, do you want to overwrite it (y/N)?\n  ");
        fflush(stdin);
        for(;;) {
            len = fgetc(stdin);
            if(len <= ' ') continue;
            if(tolower(len) != 'y') exit(1);
            break;
        }
    }
    fdo = fopen(out, "wb");
    if(!fdo) std_err();

    while((len = fread(buff, 1, sizeof(buff), fdi))) {
        if(!fwrite(buff, len, 1, fdo)) {
            printf("\nError: impossible to write the output file, check your disk space\n\n");
            exit(1);
        }
    }

    if(fdi != stdin) fclose(fdi);
    fclose(fdo);
}



void tnt_rw(FILE *fd, void *ret_buff, int size, int encrypt) {
    static int  buffsz  = 0;
    static u8   *buff   = NULL;

    if(size <= 0) return;

    if(buffsz < size) {
        buffsz = size + 64;
        buff = realloc(buff, buffsz);
        if(!buff) std_err();
    }
    myfr(fd, buff, size);
    if(ret_buff && encrypt) memcpy(ret_buff, buff, size);
    tnt_crypt(buff, size);
    if(ret_buff && !encrypt) memcpy(ret_buff, buff, size);
    fseek(fd, -size, SEEK_CUR);
    myfw(fd, buff, size);
    fflush(fd); // needed or doesn't work!!!
}



int tntnameinit(u8 *fname) {
    int     ret;
    u8      *p,
            *l;

    for(p = l = fname; *p; p++) {
        if((*p == '\\') || (*p == '/')) l = p + 1;
    }

    ret = 0;
    for(p = l; *p && (*p != '.'); p++) {
        // the function is case sensitive!!!
        ret += *p;
    }
    return(ret & 0xff);
}



int tnt_brute_check(FILE *fd) {
    u32     brute,
            brutebck;
    int     i;

    if(fseek(fd, -sizeof(end_central_dir_t), SEEK_END)) std_err();
    myfr(fd, &brutebck, 4);

    brute = brutebck;
    tnt_crypt((u8 *)&brute, 4);
    if(brute == 0x06054b50) {
        return(-1); // found
    }

    printf(
        "- the init value calculated on the filename seems wrong\n"
        "  this happens if the filename is not the original one or if you have renamed\n"
        "  it using capital letters (the algorithm is case sensitive!)\n"
        "- start init value brute forcing\n");

    for(i = 0xff; i; i--) {  // brute forcer
        tnt_crypt_init(i);
        brute = brutebck;
        tnt_crypt((u8 *)&brute, 4);
        if(brute == 0x06054b50) break;
    }
    if(!i) {
        printf("\n"
            "Error: wrong file format, no zip header found\n"
            "       probably the input file is encrypted by another program like the version\n"
            "       available on TryGames.com where data files uses the Trymedia encryption.\n"
            "\n"
            "       so check with a hex editor if you see a \"TMSAMVOH\" at the beginning\n"
            "       of the file, then decrypt it with ActiveMARKDecrypter\n"
            "       (http://arteam.accessroot.com/arteam/site/download.php?view.270) and\n"
            "       then convert it to zip with this tool.\n"
            "\n");
        exit(1);
    }

    printf("- init crypt value 0x%02x\n", i);
    return(i);
}



void tnt_crypt(u8 *data, int len) {
    u8      *limit;

    for(limit = data + len; data < limit; data++) {
        *data ^= tnt_crypt_init(0);
    }
}



u8 tnt_crypt_init(u8 num) {
    static u32  tnt_crypt_num   = 0;

    if(num) {
        tnt_crypt_num = num | (num << 8) | (num << 16) | (num << 24);
        return(num);
    } else {
        tnt_crypt_num = ((tnt_crypt_num * 29) + 27) % 0x72ebcafe;
        return((tnt_crypt_num ^ (tnt_crypt_num >> 8) ^ (tnt_crypt_num >> 16) ^ (tnt_crypt_num >> 24)) & 0xff);
    }
}



int myfr(FILE *fd, void *data, int size) {
    int     len;

    len = fread(data, 1, size, fd);
    if(len != size) {
        printf("\nError: incomplete input file, can't read %u bytes\n", size - len);
        exit(1);
    }
    return(len);
}



int myfw(FILE *fd, void *data, int size) {
    int     len;

    len = fwrite(data, 1, size, fd);
    if(len != size) {
        printf("\nError: impossible to write %u bytes\n", size - len);
        exit(1);
    }
    return(len);
}



int get_num(u8 *str) {
    int     offset;

    if(!strncmp(str, "0x", 2) || !strncmp(str, "0X", 2)) {
        sscanf(str + 2, "%x", &offset);
    } else {
        sscanf(str, "%u", &offset);
    }
    return(offset);
}



void std_err(void) {
    perror("\nError");
    exit(1);
}


