/*
UBI.COM gschat encoding/decoding algorithm 0.2
by Luigi Auriemma
e-mail: aluigi@autistici.org
web:    aluigi.org

------------
INTRODUCTION
------------
The program Ubi.com (also called GS4 or Gameservice or gameclient)  uses
a very simple encoding/decoding algorithm to hide the communication
between the GS4 client and the IRC server gschat.ubisoft.com
(also known as spud.ubisoft.com or gsxirc02.gs.mdc.ubisoft.com).
The algorithm is just a Blowfish encryption.

---------------
SOME BASIC INFO
---------------
Using my functions is really very simple, BUT you need to know some
informations.
"data_block" is the block of data received from the Ubi server.
Each network packet (TCP data) can contain multiple sequential Ubi data
blocks.
For example:

TCP packet:
  _______________________________________________
  |############|#########################|######|
  |first blcok |second block             |third

Data block has the following structure:

  "\x00\x06" "data" "\x04\x00"
   |          |      |
   |          |      real size of the data (little-endian)
   |          the data you want to decode or encode
   size of the entire data block less 2 in big-endian (network) format.
   If the block is 28 bytes, this value is 26:
    24 for the encoded data and 2 for the real length of the data.

Practical examples:

  http://aluigi.org/papers.htm#ubi

-------
LICENSE
-------
    Copyright 2004,2005,2006,2007,2008 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl-2.0.txt
*/

unsigned int  ubi_gschat_sbox[] = {
 0x7d534b3b, 0x62efc73a, 0x969984ab, 0xde17df73,
 0x6c819824, 0x4fb6e4e6, 0xb86d4e76, 0xbad9457f,
 0x89071a49, 0x23bd3e2c, 0x219e1f09, 0x32b330aa,
 0x683d97e1, 0xac3ddab6, 0x397a7933, 0x3ba6beca,
 0x6e07ba4e, 0x212ed4a7, 0x95e620a6, 0x698b9b73,
 0x082b364c, 0x5e1d5e06, 0x5f8f034c, 0x631c7567,
 0x9621ba3a, 0x66704d9e, 0xb9e6bf43, 0x97cd7047,
 0x85bbeae7, 0xc0a12d0e, 0x960712ed, 0x279e3e35,
 0x49f2fe84, 0x69554f89, 0xb7f8cdd6, 0x4e4f7822,
 0x6aeeb9b3, 0xe10462d6, 0xbf97b9ea, 0x92db49ac,
 0x8e138e40, 0xe7c36b7c, 0x69d7a80a, 0x0f8b63a4,
 0xd39513b5, 0x8b4d63cb, 0x9ff77163, 0xf0184190,
 0x037518aa, 0x0c59df14, 0x62c198d7, 0xe2647625,
 0xadd69c81, 0x573f76f9, 0xc1a8579b, 0x0e47dedc,
 0xa9874318, 0x343cc91f, 0xa10703db, 0x8977e1fd,
 0xbb3c3149, 0x4854d4cd, 0x6517cb5b, 0xe426006d,
 0xa39a2876, 0xb63e0510, 0x3a750e39, 0x1ce65029,
 0x5c3a8196, 0x35f361e9, 0xa02a7631, 0x09e6d5b9,
 0x23c30eb8, 0x2b721189, 0x9bd76ee6, 0x7f8b9af9,
 0x6c806214, 0x930f30a4, 0xff649d43, 0x3828ec51,
 0xc8d6e992, 0x8041721d, 0xaa1144e7, 0x3229c71d,
 0xd8ce29d1, 0x8b52ee50, 0xef7675d2, 0x16df79ce,
 0xe76e0e61, 0xbaf1e259, 0x4eb79d99, 0x39233316,
 0xf3bbe3ea, 0x4466f62d, 0x9b707896, 0x5d0d3281,
 0x32db3bd2, 0x85e1ae39, 0x8c79abef, 0xde5717cf,
 0x0e02ddb8, 0x743291f4, 0xa020b26e, 0x18a8e91c,
 0x5b38d24c, 0x1bc11195, 0x8d3af775, 0x7e192ebb,
 0x8507a8f3, 0x3b21f00a, 0x3ad8437a, 0xe7097480,
 0xc1291f3a, 0x6e15f95e, 0xe270f22c, 0x400db04a,
 0x410d74ef, 0x80fc6c24, 0xc96939a7, 0x8b6b3140,
 0x71bd65a6, 0x85e9266c, 0xd6690e05, 0x90a4501d,
 0xcf3e92b4, 0x789ab025, 0x93d93c10, 0xe0c7b082,
 0x2e7d5006, 0x9e0946b7, 0xcc804e83, 0x282e391a,
 0x6e416136, 0x112fb982, 0x104a90d2, 0xb606d2fd,
 0x7b00ea01, 0x6a588226, 0xf507283d, 0x792652c9,
 0x86e63d17, 0xcd3e8286, 0x0b8b9c1c, 0xd2d9a61e,
 0x6609737e, 0x0d4913dd, 0xcc44ebe6, 0xfbcf72c1,
 0x108ba524, 0x62f5d09f, 0x54ad6460, 0x62f609c6,
 0x64a71062, 0xad235231, 0x00daf4ad, 0x8288b12d,
 0x81b33bd7, 0x37eaa2c4, 0x924e8e37, 0xd10f6aa0,
 0x387bd549, 0x7e5989f6, 0xf54d04fc, 0x17258f1c,
 0xebfb8082, 0x873212b5, 0x605bf190, 0x9dc788d9,
 0x85c4d707, 0x564c91e1, 0xf520c09a, 0x10c49bba,
 0x7d8a9740, 0x5d808ade, 0x045e602a, 0xdfefd01d,
 0x7a21f3d4, 0x5f533bee, 0x6a3d1e4d, 0x3c5b2e3b,
 0x5424e5ff, 0x3e4b8472, 0x1977af0a, 0x5f737dd0,
 0x6a2bebcf, 0x5e9a452a, 0x9a5631dd, 0x56b001ee,
 0x2b53ee6b, 0xf701516a, 0x9f9dd8f3, 0xeb0947c2,
 0x1da2b231, 0xd33680c7, 0x88d515c0, 0x04ed11b7,
 0xd9e770aa, 0xcd389784, 0x3ea8bc0c, 0x59049448,
 0xe71738d8, 0xa5aeded6, 0x3a47bf6c, 0x2bf8d666,
 0x4ff49c85, 0x29f6b70e, 0xaeb15e21, 0x4ed7e3fd,
 0x9929fce9, 0xa4305cce, 0x09279e37, 0x28a5ecbc,
 0xc66ddb13, 0x7a385fe2, 0x42fde727, 0xb50290e0,
 0x04e855c8, 0xce94d39b, 0x2d59f2e9, 0xbeb23d30,
 0x2a92531e, 0xae3f2ecf, 0x46ee9d11, 0x1a7a145d,
 0x884e4b21, 0x01cffae4, 0x294d2aef, 0xb9ff2515,
 0x92e67b09, 0xb445e5a5, 0x1b95a397, 0x668f56a0,
 0xf9006eab, 0x772bb81c, 0xfbe78ce4, 0x5d57bdba,
 0xce257ff0, 0x57c98048, 0xa7e43d5a, 0x06fefe99,
 0x90aad687, 0x3bb673c3, 0xb731198b, 0x32ee79aa,
 0x63f08e87, 0xc0db278b, 0xf1f7ba12, 0xd1cabe5a,
 0xc9284e2a, 0x2d4c2a9d, 0xfe9d086e, 0x75faf6fe,
 0xd5c5a840, 0xecb94fda, 0x0a053678, 0x93190cfa,
 0x3b709fc1, 0xedcff3bd, 0x57c7b747, 0xf91a7c65,
 0x4ce549b0, 0x0c3ac609, 0x33b6139d, 0x60cebe6c,
 0x585353e5, 0x8c49f73d, 0xfce66857, 0x6a41b6ad,
 0x74fd0228, 0x48b5d687, 0xfb5324a0, 0x3cef55ee,
 0x4e289d29, 0x42c39cae, 0x2ebbf514, 0x4793cbcd,
 0x6f7ba208, 0xe56b6d97, 0xecfb5bb4, 0x4c877b4c,
 0x4d5da287, 0x7daf39bb, 0xcb1f9fa4, 0x88a5b36e,
 0x51c74945, 0x45179299, 0x92fa2c4a, 0x43c56415,
 0x0320f4f9, 0x68d5ed19, 0x09abe789, 0x909aea30,
 0x6d7fb3c5, 0x30938076, 0x5392f959, 0x07e5f4d2,
 0xf33e4028, 0xd44f2ef0, 0xdd230d1b, 0x49e646e9,
 0x6f21bd50, 0xded74cfb, 0x35de78d1, 0xef578807,
 0xd067fa1e, 0xed5975f5, 0xb4cb3b94, 0x6a5149a7,
 0x9272e07c, 0x73542452, 0x0e6ff2ee, 0x8b50b8fc,
 0x7dd6fd18, 0x7eccca6e, 0x95afef66, 0x02f15fdb,
 0x6a356fa0, 0x505306d5, 0x02e5afa2, 0x399ecca1,
 0x3ebf0563, 0xb96a9093, 0x905d7504, 0xccc7fd85,
 0xc6fcc1e5, 0xbabbfb0a, 0x9925a245, 0x32332e23,
 0xb1daa8fb, 0x660670e9, 0xc1b9d6b0, 0x8ba31904,
 0xb576e598, 0xecdea011, 0x1534a5ad, 0xc33d1a8a,
 0x0f3800c4, 0x943ddfd6, 0x8eb52a05, 0xa66b6bbb,
 0xdd160424, 0x93799b19, 0x3abc042a, 0x90814fea,
 0x33d2f573, 0x54899538, 0xf6d632ce, 0x7978aa11,
 0x6166ac76, 0x33a293dd, 0x1a35ad4a, 0x398e0f31,
 0x8a0e2a75, 0xa653506c, 0xb9368613, 0x432b7030,
 0xbf759f91, 0xcaeb5b37, 0x7a48ef54, 0x7531595f,
 0xff6c9b52, 0xfb291c39, 0xeae9183a, 0x2379ed28,
 0x7d224404, 0x917e9722, 0xce8704dc, 0x6eab0487,
 0xe49802a6, 0x3544454b, 0x137173a8, 0x9d2b33bd,
 0x84013e0f, 0x856cc03f, 0x597bbad0, 0xfba1dddc,
 0x81ef6196, 0xdf59585e, 0x40222892, 0xc9a2ffc1,
 0x6b9e8806, 0x75973658, 0x50ac148c, 0x6a5c53d1,
 0xc315c528, 0x270d1b3c, 0x4196b2ab, 0xfd7c20a6,
 0x922abb78, 0x60caa117, 0xb28a7951, 0x251ee435,
 0xa39b18c5, 0x2825807f, 0x5a675f4b, 0xffc93b8d,
 0x5b2c37a4, 0x19318471, 0x893fd270, 0xe063b1c4,
 0xb82a1e5e, 0xae84c8bb, 0x7cf0e263, 0x8b246c99,
 0xf6cb3c6e, 0x01a652eb, 0xce941e8e, 0x4171f48d,
 0xa7403e24, 0xbd9c5e06, 0x129e8ee6, 0xc15c1432,
 0x43315e3e, 0xc2050d00, 0x5b7ceb56, 0xac9beb6b,
 0xb85b9ab6, 0x6ec070fb, 0x7b4c4152, 0x62657dfd,
 0x90303886, 0xb9fd6c97, 0xf5b8b765, 0xbed19a11,
 0x22f137ac, 0x30e8d742, 0x79216c81, 0x664a3aa8,
 0xe695b5d2, 0xd021f39a, 0x83ca650e, 0xbf249ce5,
 0xd7494070, 0xe333d0a5, 0x8daad530, 0xedb0eceb,
 0x047f7a41, 0x9d6d42e1, 0x492533c7, 0x1a806865,
 0xa98e9d94, 0xa3a88d79, 0xceac7c47, 0x3d0aacfc,
 0xe1dc5e40, 0x5ecb6ca1, 0x17f25d42, 0xec242cf9,
 0xd49e925b, 0xeb201656, 0xc63fe1db, 0xa63306ce,
 0xd3798dd5, 0xc57db0b5, 0x3c081268, 0xb65f3495,
 0x73b61273, 0x40b7418a, 0x23fc2ba5, 0xf2e9a205,
 0xe8691be0, 0x6e5a763c, 0xb7cf1647, 0xcc548751,
 0xfbbef5ca, 0x0eb7fb19, 0xc7b75804, 0x8ee642e2,
 0xe0aec829, 0xbc917ef2, 0xac0fc0e1, 0x1a6232f1,
 0xc6ca9465, 0xb1a117aa, 0x067d974c, 0xa716e3dd,
 0x214c5592, 0xb99710d0, 0x9dff256e, 0x4b6603ef,
 0xf4d3a626, 0xa034e14e, 0xbcd98e65, 0xe4f4f734,
 0x6ff13834, 0xba938012, 0xcef8349d, 0x376ba34f,
 0x4176ee6b, 0x8bcbfde0, 0x13145616, 0x7b1e2e90,
 0x577cad5a, 0xf6b172e8, 0x9f6f02da, 0x2f4cd4d6,
 0x3ff118f3, 0x0304ee50, 0xc704df0b, 0x9fdb8365,
 0xccef4ea5, 0xd837f82a, 0xeec934a1, 0x1c674e26,
 0xa1b17d66, 0xa2e44633, 0x823e1e7f, 0xc23e6526,
 0x25ba3da0, 0x14a21c28, 0xc1a1a46b, 0xa4a10aa4,
 0x160260ad, 0x2dd8befe, 0x5c2d9e5b, 0x9ed9c7a6,
 0x80b4f786, 0xe168a01f, 0x7f813abe, 0x29e5bed6,
 0x2f21747e, 0x4ce7dafc, 0x016cfc49, 0x2e5304f8,
 0xea90e7f9, 0x2cf8d63a, 0x8f9abf82, 0x33366db5,
 0x95987021, 0x83117669, 0xadfcecd7, 0x812d45e2,
 0x26e594b1, 0x6e5e0f32, 0xeae8633f, 0x14f8af56,
 0x439b1995, 0xc5ba8cf7, 0x68b5a040, 0xec590d8d,
 0x5070603b, 0x76d1bd7c, 0xca008839, 0x22f22f2f,
 0x504fcc97, 0x596cafb2, 0x24936b02, 0xef7d11f0,
 0x810222a3, 0x611646a8, 0x725ef6e9, 0x5ce1c8ac,
 0xccb647e8, 0xed96eda8, 0xa8126fc7, 0xed365893,
 0xed71c68d, 0x38f78e02, 0xd68ee65f, 0x963af8cb,
 0x2d6b2454, 0x124e7801, 0x7308c458, 0xd79bd61a,
 0xa5e6e41e, 0xc4307827, 0x76afffde, 0x2215581a,
 0x8f31cc31, 0x5dd8bd56, 0x22d5c628, 0x557c4cb2,
 0x9c68ec66, 0x6a15a69c, 0xb10c9ac1, 0x98a4ab57,
 0xc79434c1, 0xd42e04a7, 0x5aff5cfe, 0xd406f8a0,
 0x9d8f51a5, 0x5e9ff4bf, 0x05fd767d, 0xfd163a6f,
 0x9ca511d9, 0xcd3e283b, 0xddde27d3, 0xedd6f460,
 0xc6f1daed, 0x880b533c, 0xf6e18bbb, 0x38c34e28,
 0x7b193f81, 0x36f0d738, 0x820278be, 0xc2d762c9,
 0x1dd83cb2, 0xc2081002, 0x3ff73dbd, 0x93106051,
 0x8a206cc8, 0x0062dc43, 0xa726277e, 0xed30d615,
 0x55d999c1, 0x4f2a5f47, 0x5639520f, 0x8c5bc43a,
 0x419b526c, 0xef0ebff9, 0xd1fdd244, 0x147d6404,
 0xced92314, 0xf3212ec2, 0x3d01b888, 0x6729f516,
 0x4c01ec65, 0x00a1d637, 0x3614871c, 0xfa115533,
 0x7c2b9fdf, 0x7e38988b, 0x3e1589f0, 0x6000740e,
 0x11e2b916, 0x031257c2, 0x6173c707, 0xa895bf8c,
 0x831dae90, 0x53fe73d3, 0x358538c9, 0x80905969,
 0x43a73af5, 0x07c7a19c, 0xe169b4a8, 0x17fec826,
 0xe87aa4c1, 0x0e443116, 0x4db50d6e, 0x7d4d329f,
 0x48684434, 0x0b20b82c, 0x325319b5, 0xfe3d4296,
 0x1268f74f, 0x30851eff, 0xe054a1ef, 0xd407d3ad,
 0x11eec964, 0x37d1eec3, 0x9c0c0f91, 0x4e9a830a,
 0xbb66f603, 0xccd40365, 0x3aa26543, 0x32228a92,
 0xd654f674, 0x2d9d8319, 0x5086f54d, 0x877a06b1,
 0x8adbca38, 0xd992ef45, 0xd86814af, 0x50abe373,
 0xadaed318, 0x9b9b28c8, 0xa5c18fbe, 0x3eb86912,
 0xa1107d2a, 0x8fff58a3, 0x9ba4f6e9, 0x81f6a9a1,
 0x4d8d508c, 0xbee476de, 0xeb32c9fd, 0xc2320719,
 0x42ee6148, 0xf40dd799, 0x5305a1ce, 0xfdf1a7b7,
 0x684fdeb7, 0xb93a089c, 0xd4a570ba, 0x79bc08b6,
 0x5e4af883, 0x95f496dc, 0x7c57816e, 0x91bb7695,
 0x5f1c55af, 0xdc53952d, 0x492b2434, 0xffac8c03,
 0xd72d9166, 0xe8f351c2, 0xeb59f14a, 0x3d5328e7,
 0x221d5f23, 0xe5499756, 0xe65383fa, 0x0ce5c488,
 0x8d6aa151, 0xd229c1fd, 0xceb93bc8, 0x84c0f770,
 0xa5a1c6dd, 0x64f4af22, 0x3e062d09, 0xb9d15672,
 0x4aa8a75f, 0x10d3f511, 0x332c538f, 0xfdb169f1,
 0xb7e68f0b, 0xb1ea3115, 0xb72f7bee, 0x0fefb7cd,
 0x8c150017, 0xa80ec01b, 0xc5e5e171, 0x42521d00,
 0x70e55786, 0x9f2d8ff4, 0xd855f397, 0xbab1e725,
 0x7ace8e49, 0x7cee1ef2, 0x92f1346f, 0xd9a192bf,
 0xb4a3585d, 0x2271a727, 0xc07c433c, 0x588c4fce,
 0x55556c1c, 0xd1e10751, 0x3443f454, 0x5f0429d8,
 0x9e1fa563, 0xadf3d095, 0x4e1f93a1, 0x626221dc,
 0xca0d60c6, 0xd46a199f, 0x8b4238fa, 0x00473c18,
 0xc8bb9fc5, 0x7d411664, 0xbbfa18b2, 0x9bd40244,
 0x123e3013, 0xacfcce07, 0x84c86031, 0x89a00515,
 0x6367c669, 0xcc3aa138, 0x2b05a83d, 0xf6fd8026,
 0x62798ae4, 0x883a038a, 0x8a6a7cad, 0x15b3560b,
 0x7e4eb436, 0xbdb7b4fa, 0x34cd1128, 0x721250ad,
 0xcf7f167c, 0x4964424d, 0x8533ebda, 0x46ec788d,
 0x656f8dee, 0xf0348673, 0xa18c99c1, 0xada8ca5b,
 0x74d2b2f4, 0xad12f74c, 0x0df64845, 0x71f223c2,
 0x2e0c1b72, 0x8529c249, 0x9d5b4813, 0x484187cd,
 0x9434648f, 0x3e84f799, 0x9c966fa9, 0x60755385,
 0x37b75e8b, 0xef0a5a88, 0x17f407ac, 0x6bd9c129,
 0x5db626df, 0x24dd5a56, 0x845934d9, 0x445cb5b5,
 0xe135907a, 0x8ed16394, 0x6774c5b0, 0x1b944422,
 0x467dfb60, 0xce6c32c0, 0xdeef91f1, 0xc04fb508,
 0x918fbc48, 0x24da7074, 0x333afaf0, 0x961c7a76,
 0x830c812c, 0xfd618771, 0x52ae60f1, 0x01f469e7,
 0xbcde87b3, 0xc5232a45, 0xe7c0e1ba, 0xdc0ee464,
 0xa7d0315a, 0xb64a1a8a, 0x1a288044, 0xcb03b4d2,
 0x6e500e87, 0xa6c6df5d, 0xd3c5c122, 0x4041e921,
 0x33f9173a, 0xda293425, 0x0db8730a, 0x378ef24a,
 0xd2ea07c4, 0x7444d94e, 0x8570e176, 0x384d95ca,
 0x5bcf579e, 0xaf34f244, 0x7cb37d9e, 0xf880fa20,
 0x414e10f3, 0xa23fc900, 0x3a63fa6c, 0x40d0ac97,
 0xa1831cf3, 0x27deafc6, 0x9ee4bebc, 0x23524bf2,
 0x89915f98, 0x3ee262fa, 0xef3a7dde, 0x5c6a1676,
 0x88bc0780, 0x466bca94, 0x7e4c7bff, 0x9041377e,
 0xaaefa091, 0x3e16ab71, 0x6d5dc006, 0xc49de4cb,
 0x69c51f07, 0x0f3f2a7d, 0xa170da78, 0x1edf1356,
 0x83af66f6, 0x71e3bfec, 0x8de2815d, 0xe1fea1f4,
 0x5336832a, 0xec12edca, 0x8b1ab2d5, 0x600839f7,
 0x35328895, 0x37f18f40, 0x4de359b5, 0x44584d11,
 0xc4b5dbd0, 0x033a78d2, 0xebbaba35, 0xac30d252,
 0x8eb43a04, 0x179b277c, 0x85ca2729, 0x91cf59b4,
 0x85c525ed, 0x6f007951, 0x1af111d5, 0x86885ca3,
 0x8489e581, 0xdde185b6, 0xeb51f92e, 0xe7589272,
 0x8fcdd791, 0x21c9221c, 0x268c7674, 0x3f93cde2,
 0x41d907da, 0xea008728, 0xa655fc06, 0x958bdf38,
 0xe6872627, 0x7b7be98f, 0x2f35251a, 0x945eb054,
 0xc81e3ebd, 0x403a2e1f, 0x2e1ff3bb, 0xb6a48052,
 0xb90e2be4, 0x0bb2a345, 0x68b0ad40, 0xdf314550,
 0x325bd931, 0x78ee2222, 0xabb00331, 0xdfa9a7e9,
 0xedaf8095, 0xb3c1dc89, 0x408c9dad, 0x02dcb049,
 0xc16ef7de, 0x9e202225, 0xf560636b, 0x88ba6f2d,
 0x91cdffa9, 0xe50246f4, 0xce24349b, 0x869b1df2,
 0xc4490740, 0x7542caef, 0x5df82051, 0x8e3bf5f3,
 0x475ec74e, 0x55c55d75, 0x6b699775, 0xadaf3436,
 0x1d7f8c44, 0xcff55e6d, 0x4bc2917f, 0xb9ad8eb0,
 0x90a8cbbe, 0x58628a1b, 0x489beba6, 0xaffd43f1,
 0xb42d2590, 0x8edfd19b, 0x693f8c59, 0xcb206975,
 0xd205e635, 0x3d018c71, 0x460878e9, 0x5a0c9e24,
 0x5455b789, 0xe7b83ec5, 0x771b8706, 0x1e586af5,
 0x4f4aadff, 0x1c309a27, 0x11134ab0, 0x905673af,
 0xeb71a8cd, 0x57998faf, 0xa9f8e484, 0x35e9b455,
 0x3712c766, 0x24c05e03, 0xd778ba7e, 0xc78b1808,
 0xebbf3956, 0xaf9aba38, 0x4cda0a35, 0x1a461525,
 0x331604be, 0x5d129774, 0x0541568a, 0x7c635930,
 0xe51c886f, 0x7e23d82d, 0xde3d4a66, 0x7c716bf9,
 0xe4a21b31, 0x7f5e5bc3, 0xac1028d7, 0x7af1bfb3,
 0x504e629d, 0x5ad66270, 0x7b172f3d, 0xe42476da,
 0x57ee8acf, 0x27ac80ba, 0x9ec80198, 0x13429379,
 0x5e448845, 0xf44f5115, 0x9ab322e0, 0xc8a02feb,
 0xcad2a214, 0x63f04be7, 0xb8bcfac2, 0x49a3aa36,
 0x284e3765, 0x9a0819b2, 0xfbc11568, 0xf0786378,
 0xb0269983, 0xeeb2cbad, 0xc58b2f6a, 0xfef747e8,
 0x962a8bc6, 0xb0deaf42, 0x92db2c37, 0xf0481c4b,
 0xd6e61b7e, 0x9cd6cafa, 0x2ca8d240, 0x44b0118d,
 0x703b2752, 0x1779f076, 0x83b887c1, 0xf3f905ce,
 0x9f70cc46, 0x600f357e, 0xd3ef9eac, 0xf06f2c11,
 0x2819508d, 0x24343228, 0x3a8f5477, 0x32b9ada7,
 0xd5a0e207, 0x598cda0e, 0xf4ac5df1, 0x12c35fa1,
 0x602850f0, 0xebb6b84e, 0x7ac5ea46, 0x8eda8925,
 0xb1ef5c39, 0xde1172cc, 0xf51c19ca, 0xd2d26a4e,
 0xc32bb512, 0x13e580b7, 0x8e6b2c55, 0xbf765304,
 0xe86db62e, 0x7bf455cd, 0x1c82593d, 0xcdf5ae77,
 0x9215265a, 0x47f39cf6, 0x243f6a88, 0x85a308d3,
 0x13198a2e, 0x03707344, 0xa4093822, 0x299f31d0,
 0x082efa98, 0xec4e6c89, 0x452821e6, 0x38d01377,
 0xbe5466cf, 0x34e90c6c, 0xc0ac29b7, 0xc97c50dd,
 0x3f84d5b5, 0xb5470917, 0x9216d5d9, 0x8979fb1b,
 0xd1310ba6, 0x98dfb5ac, 0x2ffd72db, 0xd01adfb7,
 0xb8e1afed, 0x6a267e96, 0xba7c9045, 0xf12c7f99,
 0x24a19947, 0xb3916cf7, 0x0801f2e2, 0x858efc16,
 0x636920d8, 0x71574e69, 0xa458fea3, 0xf4933d7e,
 0x0d95748f, 0x728eb658, 0x718bcd58, 0x82154aee,
 0x7b54a41d, 0xc25a59b5, 0x9c30d539, 0x2af26013,
 0xc5d1b023, 0x286085f0, 0xca417918, 0xb8db38ef,
 0x8e79dcb0, 0x603a180e, 0x6c9e0e8b, 0xb01e8a3e,
 0xd71577c1, 0xbd314b27, 0x78af2fda, 0x55605c60,
 0xe65525f3, 0xaa55ab94, 0x57489862, 0x63e81440,
 0x55ca396a, 0x2aab10b6, 0xb4cc5c34, 0x1141e8ce,
 0xa15486af, 0x7c72e993, 0xb3ee1411, 0x636fbc2a,
 0x2ba9c55d, 0x741831f6, 0xce5c3e16, 0x9b87931e,
 0xafd6ba33, 0x6c24cf5c, 0x7a325381, 0x28958677,
 0x3b8f4898, 0x6b4bb9af, 0xc4bfe81b, 0x66282193,
 0x61d809cc, 0xfb21a991, 0x487cac60, 0x5dec8032,
 0xef845d5d, 0xe98575b1, 0xdc262302, 0xeb651b88,
 0x23893e81, 0xd396acc5, 0x0f6d6ff3, 0x83f44239,
 0x2e0b4482, 0xa4842004, 0x69c8f04a, 0x9e1f9b5e,
 0x21c66842, 0xf6e96c9a, 0x670c9c61, 0xabd388f0,
 0x6a51a0d2, 0xd8542f68, 0x960fa728, 0xab5133a3,
 0x6eef0b6c, 0x137a3be4, 0xba3bf050, 0x7efb2a98,
 0xa1f1651d, 0x39af0176, 0x66ca593e, 0x82430e88,
 0x8cee8619, 0x456f9fb4, 0x7d84a5c3, 0x3b8b5ebe,
 0xe06f75d8, 0x85c12073, 0x401a449f, 0x56c16aa6,
 0x4ed3aa62, 0x363f7706, 0x1bfedf72, 0x429b023d,
 0x37d0d724, 0xd00a1248, 0xdb0fead3, 0x49f1c09b,
 0x075372c9, 0x80991b7b, 0x25d479d8, 0xf6e8def7,
 0xe3fe501a, 0xb6794c3b, 0x976ce0bd, 0x04c006ba,
 0xc1a94fb6, 0x409f60c4, 0x5e5c9ec2, 0x196a2463,
 0x68fb6faf, 0x3e6c53b5, 0x1339b2eb, 0x3b52ec6f,
 0x6dfc511f, 0x9b30952c, 0xcc814544, 0xaf5ebd09,
 0xbee3d004, 0xde334afd, 0x660f2807, 0x192e4bb3,
 0xc0cba857, 0x45c8740f, 0xd20b5f39, 0xb9d3fbdb,
 0x5579c0bd, 0x1a60320a, 0xd6a100c6, 0x402c7279,
 0x679f25fe, 0xfb1fa3cc, 0x8ea5e9f8, 0xdb3222f8,
 0x3c7516df, 0xfd616b15, 0x2f501ec8, 0xad0552ab,
 0x323db5fa, 0xfd238760, 0x53317b48, 0x3e00df82,
 0x9e5c57bb, 0xca6f8ca0, 0x1a87562e, 0xdf1769db,
 0xd542a8f6, 0x287effc3, 0xac6732c6, 0x8c4f5573,
 0x695b27b0, 0xbbca58c8, 0xe1ffa35d, 0xb8f011a0,
 0x10fa3d98, 0xfd2183b8, 0x4afcb56c, 0x2dd1d35b,
 0x9a53e479, 0xb6f84565, 0xd28e49bc, 0x4bfb9790,
 0xe1ddf2da, 0xa4cb7e33, 0x62fb1341, 0xcee4c6e8,
 0xef20cada, 0x36774c01, 0xd07e9efe, 0x2bf11fb4,
 0x95dbda4d, 0xae909198, 0xeaad8e71, 0x6b93d5a0,
 0xd08ed1d0, 0xafc725e0, 0x8e3c5b2f, 0x8e7594b7,
 0x8ff6e2fb, 0xf2122b64, 0x8888b812, 0x900df01c,
 0x4fad5ea0, 0x688fc31c, 0xd1cff191, 0xb3a8c1ad,
 0x2f2f2218, 0xbe0e1777, 0xea752dfe, 0x8b021fa1,
 0xe5a0cc0f, 0xb56f74e8, 0x18acf3d6, 0xce89e299,
 0xb4a84fe0, 0xfd13e0b7, 0x7cc43b81, 0xd2ada8d9,
 0x165fa266, 0x80957705, 0x93cc7314, 0x211a1477,
 0xe6ad2065, 0x77b5fa86, 0xc75442f5, 0xfb9d35cf,
 0xebcdaf0c, 0x7b3e89a0, 0xd6411bd3, 0xae1e7e49,
 0x00250e2d, 0x2071b35e, 0x226800bb, 0x57b8e0af,
 0x2464369b, 0xf009b91e, 0x5563911d, 0x59dfa6aa,
 0x78c14389, 0xd95a537f, 0x207d5ba2, 0x02e5b9c5,
 0x83260376, 0x6295cfa9, 0x11c81968, 0x4e734a41,
 0xb3472dca, 0x7b14a94a, 0x1b510052, 0x9a532915,
 0xd60f573f, 0xbc9bc6e4, 0x2b60a476, 0x81e67400,
 0x08ba6fb5, 0x571be91f, 0xf296ec6b, 0x2a0dd915,
 0xb6636521, 0xe7b9f9b6, 0xff34052e, 0xc5855664,
 0x53b02d5d, 0xa99f8fa1, 0x08ba4799, 0x6e85076a,
 0x4b7a70e9, 0xb5b32944, 0xdb75092e, 0xc4192623,
 0xad6ea6b0, 0x49a7df7d, 0x9cee60b8, 0x8fedb266,
 0xecaa8c71, 0x699a17ff, 0x5664526c, 0xc2b19ee1,
 0x193602a5, 0x75094c29, 0xa0591340, 0xe4183a3e,
 0x3f54989a, 0x5b429d65, 0x6b8fe4d6, 0x99f73fd6,
 0xa1d29c07, 0xefe830f5, 0x4d2d38e6, 0xf0255dc1,
 0x4cdd2086, 0x8470eb26, 0x6382e9c6, 0x021ecc5e,
 0x09686b3f, 0x3ebaefc9, 0x3c971814, 0x6b6a70a1,
 0x687f3584, 0x52a0e286, 0xb79c5305, 0xaa500737,
 0x3e07841c, 0x7fdeae5c, 0x8e7d44ec, 0x5716f2b8,
 0xb03ada37, 0xf0500c0d, 0xf01c1f04, 0x0200b3ff,
 0xae0cf51a, 0x3cb574b2, 0x25837a58, 0xdc0921bd,
 0xd19113f9, 0x7ca92ff6, 0x94324773, 0x22f54701,
 0x3ae5e581, 0x37c2dadc, 0xc8b57634, 0x9af3dda7,
 0xa9446146, 0x0fd0030e, 0xecc8c73e, 0xa4751e41,
 0xe238cd99, 0x3bea0e2f, 0x3280bba1, 0x183eb331,
 0x4e548b38, 0x4f6db908, 0x6f420d03, 0xf60a04bf,
 0x2cb81290, 0x24977c79, 0x5679b072, 0xbcaf89af,
 0xde9a771f, 0xd9930810, 0xb38bae12, 0xdccf3f2e,
 0x5512721f, 0x2e6b7124, 0x501adde6, 0x9f84cd87,
 0x7a584718, 0x7408da17, 0xbc9f9abc, 0xe94b7d8c,
 0xec7aec3a, 0xdb851dfa, 0x63094366, 0xc464c3d2,
 0xef1c1847, 0x3215d908, 0xdd433b37, 0x24c2ba16,
 0x12a14d43, 0x2a65c451, 0x50940002, 0x133ae4dd,
 0x71dff89e, 0x10314e55, 0x81ac77d6, 0x5f11199b,
 0x043556f1, 0xd7a3c76b, 0x3c11183b, 0x5924a509,
 0xf28fe6ed, 0x97f1fbfa, 0x9ebabf2c, 0x1e153c6e,
 0x86e34570, 0xeae96fb1, 0x860e5e0a, 0x5a3e2ab3,
 0x771fe71c, 0x4e3d06fa, 0x2965dcb9, 0x99e71d0f,
 0x803e89d6, 0x5266c825, 0x2e4cc978, 0x9c10b36a,
 0xc6150eba, 0x94e2ea78, 0xa5fc3c53, 0x1e0a2df4,
 0xf2f74ea7, 0x361d2b3d, 0x1939260f, 0x19c27960,
 0x5223a708, 0xf71312b6, 0xebadfe6e, 0xeac31f66,
 0xe3bc4595, 0xa67bc883, 0xb17f37d1, 0x018cff28,
 0xc332ddef, 0xbe6c5aa5, 0x65582185, 0x68ab9802,
 0xeecea50f, 0xdb2f953b, 0x2aef7dad, 0x5b6e2f84,
 0x1521b628, 0x29076170, 0xecdd4775, 0x619f1510,
 0x13cca830, 0xeb61bd96, 0x0334fe1e, 0xaa0363cf,
 0xb5735c90, 0x4c70a239, 0xd59e9e0b, 0xcbaade14,
 0xeecc86bc, 0x60622ca7, 0x9cab5cab, 0xb2f3846e,
 0x648b1eaf, 0x19bdf0ca, 0xa02369b9, 0x655abb50,
 0x40685a32, 0x3c2ab4b3, 0x319ee9d5, 0xc021b8f7,
 0x9b540b19, 0x875fa099, 0x95f7997e, 0x623d7da8,
 0xf837889a, 0x97e32d77, 0x11ed935f, 0x16681281,
 0x0e358829, 0xc7e61fd6, 0x96dedfa1, 0x7858ba99,
 0x57f584a5, 0x1b227263, 0x9b83c3ff, 0x1ac24696,
 0xcdb30aeb, 0x532e3054, 0x8fd948e4, 0x6dbc3128,
 0x58ebf2ef, 0x34c6ffea, 0xfe28ed61, 0xee7c3c73,
 0x5d4a14d9, 0xe864b7e3, 0x42105d14, 0x203e13e0,
 0x45eee2b6, 0xa3aaabea, 0xdb6c4f15, 0xfacb4fd0,
 0xc742f442, 0xef6abbb5, 0x654f3b1d, 0x41cd2105,
 0xd81e799e, 0x86854dc7, 0xe44b476a, 0x3d816250,
 0xcf62a1f2, 0x5b8d2646, 0xfc8883a0, 0xc1c7b6a3,
 0x7f1524c3, 0x69cb7492, 0x47848a0b, 0x5692b285,
 0x095bbf00, 0xad19489d, 0x1462b174, 0x23820e00,
 0x58428d2a, 0x0c55f5ea, 0x1dadf43e, 0x233f7061,
 0x3372f092, 0x8d937e41, 0xd65fecf1, 0x6c223bdb,
 0x7cde3759, 0xcbee7460, 0x4085f2a7, 0xce77326e,
 0xa6078084, 0x19f8509e, 0xe8efd855, 0x61d99735,
 0xa969a7aa, 0xc50c06c2, 0x5a04abfc, 0x800bcadc,
 0x9e447a2e, 0xc3453484, 0xfdd56705, 0x0e1e9ec9,
 0xdb73dbd3, 0x105588cd, 0x675fda79, 0xe3674340,
 0xc5c43465, 0x713e38d8, 0x3d28f89e, 0xf16dff20,
 0x153e21e7, 0x8fb03d4a, 0xe6e39f2b, 0xdb83adf7,
 0xe93d5a68, 0x948140f7, 0xf64c261c, 0x94692934,
 0x411520f7, 0x7602d4f7, 0xbcf46b2e, 0xd4a20068,
 0xd4082471, 0x3320f46a, 0x43b7d4b7, 0x500061af,
 0x1e39f62e, 0x97244546, 0x14214f74, 0xbf8b8840,
 0x4d95fc1d, 0x96b591af, 0x70f4ddd3, 0x66a02f45,
 0xbfbc09ec, 0x03bd9785, 0x7fac6dd0, 0x31cb8504,
 0x96eb27b3, 0x55fd3941, 0xda2547e6, 0xabca0a9a,
 0x28507825, 0x530429f4, 0x0a2c86da, 0xe9b66dfb,
 0x68dc1462, 0xd7486900, 0x680ec0a4, 0x27a18dee,
 0x4f3ffea2, 0xe887ad8c, 0xb58ce006, 0x7af4d6b6,
 0xaace1e7c, 0xd3375fec, 0xce78a399, 0x406b2a42,
 0x20fe9e35, 0xd9f385b9, 0xee39d7ab, 0x3b124e8b,
 0x1dc9faf7, 0x4b6d1856, 0x26a36631, 0xeae397b2,
 0x3a6efa74, 0xdd5b4332, 0x6841e7f7, 0xca7820fb,
 0xfb0af54e, 0xd8feb397, 0x454056ac, 0xba489527,
 0x55533a3a, 0x20838d87, 0xfe6ba9b7, 0xd096954b,
 0x55a867bc, 0xa1159a58, 0xcca92963, 0x99e1db33,
 0xa62a4a56, 0x3f3125f9, 0x5ef47e1c, 0x9029317c,
 0xfdf8e802, 0x04272f70, 0x80bb155c, 0x05282ce3,
 0x95c11548, 0xe4c66d22, 0x48c1133f, 0xc70f86dc,
 0x07f9c9ee, 0x41041f0f, 0x404779a4, 0x5d886e17,
 0x325f51eb, 0xd59bc0d1, 0xf2bcc18f, 0x41113564,
 0x257b7834, 0x602a9c60, 0xdff8e8a3, 0x1f636c1b,
 0x0e12b4c2, 0x02e1329e, 0xaf664fd1, 0xcad18115,
 0x6b2395e0, 0x333e92e1, 0x3b240b62, 0xeebeb922,
 0x85b2a20e, 0xe6ba0d99, 0xde720c8c, 0x2da2f728,
 0xd0127845, 0x95b794fd, 0x647d0862, 0xe7ccf5f0,
 0x5449a36f, 0x877d48fa, 0xc39dfd27, 0xf33e8d1e,
 0x0a476341, 0x992eff74, 0x3a6f6eab, 0xf4f8fd37,
 0xa812dc60, 0xa1ebddf8, 0x991be14c, 0xdb6e6b0d,
 0xc67b5510, 0x6d672c37, 0x2765d43b, 0xdcd0e804,
 0xf1290dc7, 0xcc00ffa3, 0xb5390f92, 0x690fed0b,
 0x667b9ffb, 0xcedb7d9c, 0xa091cf0b, 0xd9155ea3,
 0xbb132f88, 0x515bad24, 0x7b9479bf, 0x763bd6eb,
 0x37392eb3, 0xcc115979, 0x8026e297, 0xf42e312d,
 0x6842ada7, 0xc66a2b3b, 0x12754ccc, 0x782ef11c,
 0x6a124237, 0xb79251e7, 0x06a1bbe6, 0x4bfb6350,
 0x1a6b1018, 0x11caedfa, 0x3d25bdd8, 0xe2e1c3c9,
 0x44421659, 0x0a121386, 0xd90cec6e, 0xd5abea2a,
 0x64af674e, 0xda86a85f, 0xbebfe988, 0x64e4c3fe,
 0x9dbc8057, 0xf0f7c086, 0x60787bf8, 0x6003604d,
 0xd1fd8346, 0xf6381fb0, 0x7745ae04, 0xd736fccc,
 0x83426b33, 0xf01eab71, 0xb0804187, 0x3c005e5f,
 0x77a057be, 0xbde8ae24, 0x55464299, 0xbf582e61,
 0x4e58f48f, 0xf2ddfda2, 0xf474ef38, 0x8789bdc2,
 0x5366f9c3, 0xc8b38e74, 0xb475f255, 0x46fcd9b9,
 0x7aeb2661, 0x8b1ddf84, 0x846a0e79, 0x915f95e2,
 0x466e598e, 0x20b45770, 0x8cd55591, 0xc902de4c,
 0xb90bace1, 0xbb8205d0, 0x11a86248, 0x7574a99e,
 0xb77f19b6, 0xe0a9dc09, 0x662d09a1, 0xc4324633,
 0xe85a1f02, 0x09f0be8c, 0x4a99a025, 0x1d6efe10,
 0x1ab93d1d, 0x0ba5a4df, 0xa186f20f, 0x2868f169,
 0xdcb7da83, 0x573906fe, 0xa1e2ce9b, 0x4fcd7f52,
 0x50115e01, 0xa70683fa, 0xa002b5c4, 0x0de6d027,
 0x9af88c27, 0x773f8641, 0xc3604c06, 0x61a806b5,
 0xf0177a28, 0xc0f586e0, 0x006058aa, 0x30dc7d62,
 0x11e69ed7, 0x2338ea63, 0x53c2dd94, 0xc2c21634,
 0xbbcbee56, 0x90bcb6de, 0xebfc7da1, 0xce591d76,
 0x6f05e409, 0x4b7c0188, 0x39720a3d, 0x7c927c24,
 0x86e3725f, 0x724d9db9, 0x1ac15bb4, 0xd39eb8fc,
 0xed545578, 0x08fca5b5, 0xd83d7cd3, 0x4dad0fc4,
 0x1e50ef5e, 0xb161e6f8, 0xa28514d9, 0x6c51133c,
 0x6fd5c7e7, 0x56e14ec4, 0x362abfce, 0xddc6c837,
 0xd79a3234, 0x92638212, 0x670efa8e, 0x406000e0,
 0x3a39ce37, 0xd3faf5cf, 0xabc27737, 0x5ac52d1b,
 0x5cb0679e, 0x4fa33742, 0xd3822740, 0x99bc9bbe,
 0xd5118e9d, 0xbf0f7315, 0xd62d1c7e, 0xc700c47b,
 0xb78c1b6b, 0x21a19045, 0xb26eb1be, 0x6a366eb4,
 0x5748ab2f, 0xbc946e79, 0xc6a376d2, 0x6549c2c8,
 0x530ff8ee, 0x468dde7d, 0xd5730a1d, 0x4cd04dc6,
 0x2939bbdb, 0xa9ba4650, 0xac9526e8, 0xbe5ee304,
 0xa1fad5f0, 0x6a2d519a, 0x63ef8ce2, 0x9a86ee22,
 0xc089c2b8, 0x43242ef6, 0xa51e03aa, 0x9cf2d0a4,
 0x83c061ba, 0x9be96a4d, 0x8fe51550, 0xba645bd6,
 0x2826a2f9, 0xa73a3ae1, 0x4ba99586, 0xef5562e9,
 0xc72fefd3, 0xf752f7da, 0x3f046f69, 0x77fa0a59,
 0x80e4a915, 0x87b08601, 0x9b09e6ad, 0x3b3ee593,
 0xe990fd5a, 0x9e34d797, 0x2cf0b7d9, 0x022b8b51,
 0x96d5ac3a, 0x017da67d, 0xd1cf3ed6, 0x7c7d2d28,
 0x1f9f25cf, 0xadf2b89b, 0x5ad6b472, 0x5a88f54c,
 0xe029ac71, 0xe019a5e6, 0x47b0acfd, 0xed93fa9b,
 0xe8d3c48d, 0x283b57cc, 0xf8d56629, 0x79132e28,
 0x785f0191, 0xed756055, 0xf7960e44, 0xe3d35e8c,
 0x15056dd4, 0x88f46dba, 0x03a16125, 0x0564f0bd,
 0xc3eb9e15, 0x3c9057a2, 0x97271aec, 0xa93a072a,
 0x1b3f6d9b, 0x1e6321f5, 0xf59c66fb, 0x26dcf319,
 0x7533d928, 0xb155fdf5, 0x03563482, 0x8aba3cbb,
 0x28517711, 0xc20ad9f8, 0xabcc5167, 0xccad925f,
 0x4de81751, 0x3830dc8e, 0x379d5862, 0x9320f991,
 0xea7a90c2, 0xfb3e7bce, 0x5121ce64, 0x774fbe32,
 0xa8b6e37e, 0xc3293d46, 0x48de5369, 0x6413e680,
 0xa2ae0810, 0xdd6db224, 0x69852dfd, 0x09072166,
 0xb39a460a, 0x6445c0dd, 0x586cdecf, 0x1c20c8ae,
 0x5bbef7dd, 0x1b588d40, 0xccd2017f, 0x6bb4e3bb,
 0xdda26a7e, 0x3a59ff45, 0x3e350a44, 0xbcb4cdd5,
 0x72eacea8, 0xfa6484bb, 0x8d6612ae, 0xbf3c6f47,
 0xd29be463, 0x542f5d9e, 0xaec2771b, 0xf64e6370,
 0x740e0d8d, 0xe75b1357, 0xf8721671, 0xaf537d5d,
 0x4040cb08, 0x4eb4e2cc, 0x34d2466a, 0x0115af84,
 0xe1b00428, 0x95983a1d, 0x06b89fb4, 0xce6ea048,
 0x6f3f3b82, 0x3520ab82, 0x011a1d4b, 0x277227f8,
 0x611560b1, 0xe7933fdc, 0xbb3a792b, 0x344525bd,
 0xa08839e1, 0x51ce794b, 0x2f32c9b7, 0xa01fbac9,
 0xe01cc87e, 0xbcc7d1f6, 0xcf0111c3, 0xa1e8aac7,
 0x1a908749, 0xd44fbd9a, 0xd0dadecb, 0xd50ada38,
 0x0339c32a, 0xc6913667, 0x8df9317c, 0xe0b12b4f,
 0xf79e59b7, 0x43f5bb3a, 0xf2d519ff, 0x27d9459c,
 0xbf97222c, 0x15e6fc2a, 0x0f91fc71, 0x9b941525,
 0xfae59361, 0xceb69ceb, 0xc2a86459, 0x12baa8d1,
 0xb6c1075e, 0xe3056a0c, 0x10d25065, 0xcb03a442,
 0xe0ec6e0e, 0x1698db3b, 0x4c98a0be, 0x3278e964,
 0x9f1f9532, 0xe0d392df, 0xd3a0342b, 0x8971f21e,
 0x1b0a7441, 0x4ba3348c, 0xc5be7120, 0xc37632d8,
 0xdf359f8d, 0x9b992f2e, 0xe60b6f47, 0x0fe3f11d,
 0xe54cda54, 0x1edad891, 0xce6279cf, 0xcd3e7e6f,
 0x1618b166, 0xfd2c1d05, 0x848fd2c5, 0xf6fb2299,
 0xf523f357, 0xa6327623, 0x93a83531, 0x56cccd02,
 0xacf08162, 0x5a75ebb5, 0x6e163697, 0x88d273cc,
 0xde966292, 0x81b949d0, 0x4c50901b, 0x71c65614,
 0xe6c6c7bd, 0x327a140a, 0x45e1d006, 0xc3f27b9a,
 0xc9aa53fd, 0x62a80f00, 0xbb25bfe2, 0x35bdd2f6,
 0x71126905, 0xb2040222, 0xb6cbcf7c, 0xcd769c2b,
 0x53113ec0, 0x1640e3d3, 0x38abbd60, 0x2547adf0,
 0xba38209c, 0xf746ce76, 0x77afa1c5, 0x20756060,
 0x85cbfe4e, 0x8ae88dd8, 0x7aaaf9b0, 0x4cf9aa7e,
 0x1948c25c, 0x02fb8a8c, 0x01c36ae4, 0xd6ebe1f9,
 0x90d4f869, 0xa65cdea0, 0x3f09252d, 0xc208e69f,
 0xb74e6132, 0xce77e25b, 0x578fdfe3, 0x3ac372e6
};



unsigned short ubi_gschat_dec(unsigned char *pck, int pcksz) {
    unsigned int    a,
                    b,
                    s,
                    *x,
                    *p,
                    *l;
    int             i;

    p = (unsigned int *)pck;
    for(l = (unsigned int *)(pck + ((pcksz - 2) & (~7))); p < l; p += 2) {
        a = p[0];
        s = p[1];
        x = ubi_gschat_sbox + 17;
        for(i = 0; i < 16; i++) {
            b = a ^ *x;
            a = (((ubi_gschat_sbox[18 + ((b >> 24) & 0xff)] +
                ubi_gschat_sbox[274 + ((b >> 16) & 0xff)]) ^
                ubi_gschat_sbox[530 + ((b >> 8) & 0xff)]) +
                ubi_gschat_sbox[786 + (b & 0xff)]) ^ s;
            s = b;
            x--;
        }
        p[1] = ubi_gschat_sbox[1] ^ a;
        p[0] = ubi_gschat_sbox[0] ^ s;
    }
    return(pck[pcksz - 2] | (pck[pcksz - 1] << 8));
}



unsigned short ubi_gschat_enc(unsigned char *pck, int pcksz) {
    unsigned int    a,
                    b,
                    s,
                    *x,
                    *p,
                    *l;
    int             i;

    p = (unsigned int *)pck;
    pcksz = (pcksz + 7) & (~7);
    for(l = (unsigned int *)(pck + pcksz); p < l; p += 2) {
        a = p[0];
        s = p[1];
        x = ubi_gschat_sbox;
        for(i = 0; i < 16; i++) {
            b = a ^ *x;
            a = (((ubi_gschat_sbox[18 + ((b >> 24) & 0xff)] +
                ubi_gschat_sbox[274 + ((b >> 16) & 0xff)]) ^
                ubi_gschat_sbox[530 + ((b >> 8) & 0xff)]) +
                ubi_gschat_sbox[786 + (b & 0xff)]) ^ s;
            s = b;
            x++;
        }
        p[1] = ubi_gschat_sbox[16] ^ a;
        p[0] = ubi_gschat_sbox[17] ^ s;
    }
    return(pcksz);
}


