/*
Ubi.com decoding algorithm 0.2
by Luigi Auriemma
e-mail: aluigi@autistici.org
web:    aluigi.org


============
INTRODUCTION
============
The application Ubi.com (also known as GS4) uses a method to encode the
data exchanged between the user's client and all the Ubi.com servers
(also called routers).
So the function I have written is able to decode ANY data from and to
ANY Ubi server.


=============
USAGE EXAMPLE
=============
Very simple:

  ubi_algo(data, size);

Remember that the data you must decode starts at offset 6 of each
packet, so probably the simplest example is:

  ubi_algo(packet + 6, packetsize - 6);

Note: on Linux/Unix you must use -lm to compile the software


=============
REAL EXAMPLES
=============
I have released a sniffer which decodes the data in real-time decoder:

  http://aluigi.org/papers.htm#ubi


=======
LICENSE
=======
    Copyright 2004,2005,2006,2007,2008 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl-2.0.txt
*/

#include <stdlib.h>
#include <math.h>



void ubi_algo(unsigned char *buff, int size) {
    int     i,
            a,
            c,
            s;
    unsigned char   *nbuff;

    if(size <= 0) return;

    s = (int)sqrt(size);
    if((s * s) != size) s++;
    nbuff = calloc(s, s);
    if(!nbuff) return;

    a = 0;
    c = 0;
    for(i = size; i; i--) {
        if(c >= s) {
            c = a + 2;
            a = s - 1;
        } else if(a < 0) {
            a = c;
            c = 0;
        }
        nbuff[(a * s) + c] = 1;
        a--;
        c++;
    }

    a = 0;
    c = 0;
    for(i = 0; i < size; a++) {
        if(a >= s) {
            c += s;
            a = 0;
        }
        if(nbuff[c + a]) {
            nbuff[c + a] = buff[i];
            i++;
        }
    }

    a = 0;
    c = 0;
    for(i = 0; i < size; i++) {
        if(c >= s) {
            c = a + 2;
            a = s - 1;
        } else if(a < 0) {
            a = c;
            c = 0;
        }
        buff[i] = nbuff[(a * s) + c];
        a--;
        c++;
    }

    for(i = 0; i < size; i++) {
        buff[i] ^= (i & 0xff) - 0x77;
    }

    free(nbuff);
}


