/*

    Copyright 2004,2005,2006 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl.txt

*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netdb.h>
#endif



#define VER         "0.1"
#define MASTER      "ut2003master.epicgames.com"
#define MASTERPORT  80
#define IPREQ       "GET /serverlist/full-all.txt HTTP/1.0\r\n\r\n"
//#define IPREQ       "GET /serverlist/demo-all.txt HTTP/1.0\r\n\r\n"
#define FAVHEAD     "[XInterface.Browser_ServerListPageFavorites]\n"
#define FAV         "Favorites=(ServerID=0,IP=\"%s\",Port=7787,QueryPort=7778,ServerName=\"ut2003fav-%010d\")\n"
#define RECVSZ      8192
#define INI         "UT2003.ini"
#define MAXIP       3000
#define MAXPING     300000
#define PING        "\x79\x00\x00\x00\x04"



int ut2003_ping(u_int ip);
int timeout(int sock);
u_int resolv(char *host);
void io_err(void);
void std_err(void);



int     maxping;



int main(void) {
    FILE                *fd;
    int                 sd,
                        err,
                        diff,
                        i,
                        tot,
                        totfav;
    struct  sockaddr_in peer;
    u_char              *buff,
                        *ptr,
                        *pb,
                        head;
    u_int              *ips;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif


    setbuf(stdout, NULL);

    fputs("\n"
        "UnrealTournament 2003 online servers added to favorites "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n"
        "This tool is a test to add the servers found on\n"
        "http://ut2003master.epicgames.com/serverlist/full-all.txt in your favorites\n"
        "server section\n"
        "This tool simply appends each good server to the file "INI" so sometimes\n"
        "remember to open this file with a text editor and remove all the favorites\n"
        "(search \"favorite\" in the file and you will find them)\n"
        "\n", stdout);

    fputs("\nOpening file "INI" to append the new favorites servers\n", stdout);

        // I don't use append "ab" because I want to check if the file
        // exists without spending too much code

    fd = fopen(INI, "r+b");
    if(!fd) std_err();

    fseek(fd, 0, SEEK_END);

    i = fwrite(FAVHEAD, sizeof(FAVHEAD) - 1, 1, fd);
    if(i != 1) io_err();

    buff = malloc(RECVSZ + 1);
    if(!buff) std_err();

    printf("\n"
        "Please choose a maximum ping timeout value so will be added only the servers\n"
        "with better network performances (if you don't insert a value, I will use %d\n"
        "I suggest you to use very low values so the first times you use this tool\n"
        "test different values. For a slow ADSL line the good ping to choose here is\n"
        "100 or less:\n",
        MAXPING / 1000);
    fflush(stdin);
    fgets(buff, 10, stdin);

    maxping = atoi(buff);
    if(!maxping) maxping = MAXPING;
        else maxping *= 1000;

    peer.sin_addr.s_addr = resolv(MASTER);
    peer.sin_port        = htons(MASTERPORT);
    peer.sin_family      = AF_INET;

    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();

    printf("- Connection to server %s:%d\n",
        inet_ntoa(peer.sin_addr),
        MASTERPORT);

    err = connect(sd, (struct sockaddr *)&peer, sizeof(peer));
    if(err < 0) std_err();

    fputs("- Sending request\n", stdout);
    err = send(sd, IPREQ, sizeof(IPREQ) - 1, 0);
    if(err < 0) std_err();

    ips = malloc(sizeof(u_int) * MAXIP);
    if(!ips) std_err();

    tot = 0;
    diff = 0;
    head = 1;
    while(1) {
        err = recv(sd, buff + diff, RECVSZ - diff, 0);
        if(err < 0) std_err();
        if(!err) break;

        err += diff;
        buff[err] = 0;       // we need it

        if(head) {
            ptr = strstr(buff, "\r\n\r\n");
            if(ptr) {
                head = 0;
                pb = ptr + 4;
            } else continue;
        } else {
            pb = buff;
        }

        fputc('.', stdout);

            // parsing
        do {
            ptr = strchr(pb, 0xa);
            if(ptr) {
                ips[tot] = inet_addr(pb);

                pb = ptr + 1;
                tot++;
                if(tot == MAXIP) break;
            }
        } while(ptr);

        if(tot == MAXIP) {
            fputs("\nAlert: Has been reached the maximum number of available IP addresses\n", stdout);
            break;
        }

        diff = err - (pb - buff);

            // cannot be used memcpy!!!
        ptr = buff;
        for(i = 0; i < diff; i++, ptr++, pb++) {
            *ptr = *pb;
        }
    }
    close(sd);

    printf("\n"
        "Now I will start to ping all the %d servers found\n"
        "The maximum accepted ping is %d\n"
        "You can stop the ping when you want simply using CTRL-C\n"
        "\n"
        "HOST              REMAINING\n"
        "===========================\n",
        tot,
        maxping);

    totfav = 0;

    for(i = 0; i < tot; i++) {
        printf("                  %8d\r", tot - i);

        err = ut2003_ping(ips[i]);
        if(err > 0) {

            ptr = inet_ntoa(*(struct in_addr *)&ips[i]);

            printf("%15s\n", ptr);

                // I have not used snprintf because it is not necessary

            err = sprintf(
                buff,
                FAV,
                ptr,
                totfav);

            err = fwrite(buff, err, 1, fd);
            if(err != 1) io_err();
            fflush(fd);

            totfav++;
        }
    }

    fclose(fd);
    free(buff);
    free(ips);

    printf("\n"
        "%d servers added to favorites\n"
        "\n"
        "Now press RETURN to exit\n", totfav);
    fflush(stdin);
    fgetc(stdin);

    return(0);
}



int ut2003_ping(u_int ip) {
    int                 sd,
                        err;
    struct  sockaddr_in peer;

    peer.sin_addr.s_addr = ip;
    peer.sin_port        = htons(7778);
    peer.sin_family      = AF_INET;

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    err = sendto(sd, PING, sizeof(PING) - 1, 0, (struct sockaddr *)&peer, sizeof(peer));
    if(err < 0) std_err();

    err = timeout(sd);

    close(sd);

    return(err);
}



int timeout(int sock) {
    struct  timeval tout;
    fd_set          fd_read;
    int             err;

    tout.tv_sec = 0;
    tout.tv_usec = maxping;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    err = select(sock + 1, &fd_read, NULL, NULL, &tout);
    if(err < 0) std_err();
    if(!err) return(-1);
    return(tout.tv_usec);
}



u_int resolv(char *host) {
    struct        hostent    *hp;
    u_int        host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u_int *)(hp->h_addr);
    }
    return(host_ip);
}



void io_err(void) {
    fputs("\n"
        "Error: I/O error, is impossible to write the file or the disk space is finished\n",
        stdout);
    exit(1);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif



