/*

    Copyright 2004,2005,2006 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl.txt

*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netdb.h>
#endif



#define VER         "0.2"
#define MASTER      "ut2003master.epicgames.com"
#define MASTERPORT  80
#define IPREQ       "GET /serverlist/full-all.txt HTTP/1.0\r\n\r\n"
//#define IPREQ       "GET /serverlist/demo-all.txt HTTP/1.0\r\n\r\n"
#define RECVSZ      8192



u_int resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    int                 sd,
                        err,
                        diff,
                        i,
                        tot;
    struct  sockaddr_in peer;
    u_char              ip[16],
                        *buff,
                        *ptr,
                        *pb,
                        head;
    u_short             data_port,
                        info_port;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif


    setbuf(stdout, NULL);

    fputs("\n"
        "UnrealTournament 2003 online servers list retriever "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    peer.sin_addr.s_addr = resolv(MASTER);
    peer.sin_port        = htons(MASTERPORT);
    peer.sin_family      = AF_INET;

    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();

    printf("- Connection to server %s:%d\n",
        inet_ntoa(peer.sin_addr),
        MASTERPORT);

    err = connect(sd, (struct sockaddr *)&peer, sizeof(peer));
    if(err < 0) std_err();

    fputs("- Sending request\n", stdout);
    err = send(sd, IPREQ, sizeof(IPREQ) - 1, 0);
    if(err < 0) std_err();

    fputs("\n"
        "IP                DATA    INFO\n"
        "===============================\n", stdout);

    buff = malloc(RECVSZ + 1);
    if(!buff) std_err();

    tot = 0;
    diff = 0;
    head = 1;
    while(1) {
        err = recv(sd, buff + diff, RECVSZ - diff, 0);
        if(err < 0) std_err();
        if(!err) break;

        err += diff;
        buff[err] = 0;       // we need it

        if(head) {
            ptr = strstr(buff, "\r\n\r\n");
            if(ptr) {
                head = 0;
                pb = ptr + 4;
            } else continue;
        } else {
            pb = buff;
        }

        do {
            ptr = strchr(pb, 0xa);
            if(ptr) {
                sscanf(pb, "%s %hu %hu",
                    ip,
                    &data_port,
                    &info_port);

                printf("%15s   %5hu   %hu\n",
                    ip,
                    data_port,
                    info_port);

                pb = ptr + 1;
                tot++;
            }
        } while(ptr);

        diff = err - (pb - buff);

            // cannot be used memcpy!!!
        ptr = buff;
        for(i = 0; i < diff; i++, ptr++, pb++) {
            *ptr = *pb;
        }
    }

    close(sd);

    printf("\n%d servers found\n", tot);

    return(0);
}



u_int resolv(char *host) {
    struct        hostent    *hp;
    u_int        host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u_int *)(hp->h_addr);
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif



