/*
    Copyright 2005,2006 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl.txt
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <openssl/aes.h>



#define VER     "0.1"
#define BUFFSZ  (16 << 10)
// 16  = default key size
// 128 = 16 * 8



int search_key(FILE *fd, unsigned char *key);
void std_err(void);



unsigned char   virtools_key[16] =  /* is it fixed? */
                "\x9d\x0b\x08\x5b\xd4\x13\x77\x60\xe7\x10\x3f\x0a\x2c\x55\xb8\x0a";



int main(int argc, char *argv[]) {
	AES_KEY         key_ctx;
    FILE            *fd,
                    *fdo;
    unsigned int    tot = 0;
    int             i,
                    len,
                    enckey = 1,
                    spaces = 0;
    unsigned char   key[16],
                    iv[16],
                    buff[BUFFSZ],
                    *p;


    setbuf(stdout, NULL);

    fputs("\n"
        "Virtools .crypted files decrypter "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 4) {
        printf("\n"
            "Usage: %s <file.CRYPTED> <output_file> <enc_key>\n"
            "\n"
            "enc_key can be 2 things:\n"
            "- the name of the objects file contained in the original VMO which usually has\n"
            "  the same name of the directory from which you have got the .crypted file.\n"
            "  this tool will \"try\" to find the key automatically but it's a work-around\n"
            "  the objects file can be extracted with my \"Virtools files unpacker\" tool\n"
            "- the encrypted or decrypted key found by you, in this case all you need is to\n"
            "  insert the encrypted key in hex format with spaces (like \"12 34 ab cf ...\")\n"
            "  or directly the plain-text decrypted key (like tXv11B72 for ChatPark3D or\n"
            "  vblmusic for DemoServerLight for example)\n"
            "\n"
            "Note: this tool has been tested on a small number of crypted projects so your\n"
            "      feedback and your suggestions are really needed and welcome\n"
            "\n", argv[0]);
        exit(1);
    }

    fd = fopen(argv[3], "rb");
    if(fd) {
        printf("- open file:     %s\n", argv[3]);
        if(search_key(fd, key) < 0) {
            fputs("\n"
                "Error: key not found in the file, this method is a work-around so it's normal\n"
                "\n", stdout);
            exit(1);
        }
        fclose(fd);
    } else {
        p = argv[3];
        for(i = 0; p[i]; i++) {
            if(p[i] == ' ') spaces++;
        }
        if(spaces == 15) {
            for(i = 0; i < 16; i++) {
                sscanf(p, "%02hhX ", &key[i]);
                p += 3;
            }
        } else {
            strncpy(key, argv[3], 16);
            enckey = 0;
        }
    }

    if(enckey) {
        AES_set_decrypt_key(virtools_key, 128, &key_ctx);
        AES_decrypt(key, key, &key_ctx);
    }
    printf("- Key:           %.16s\n", key);

    printf("- open file:     %s\n", argv[1]);
    fd = fopen(argv[1], "rb");
    if(!fd) std_err();

    printf("- create file:   %s\n", argv[2]);
    fdo = fopen(argv[2], "wb");
    if(!fdo) std_err();

    AES_set_decrypt_key(key, 128, &key_ctx);
    fread(iv, 16, 1, fd);

    while((len = fread(buff, 1, sizeof(buff), fd))) {
        if(len < 16) memset(buff + len, 0, 16 - len);   // useless?
        AES_cbc_encrypt(buff, buff, len, &key_ctx, iv, AES_DECRYPT);
        fwrite(buff, len, 1, fdo);
        tot += len;
    }

    fclose(fd);
    fclose(fdo);
    printf("- %u bytes decrypted\n\n", tot);
    return(0);
}



int search_key(FILE *fd, unsigned char *key) {
    struct  stat    xstat;
    int             len;
    unsigned char   *buff,
                    *p,
                    *l;

#define FINDME      "\xD4\x68\xA2\x1F\x34\x75\xFA\x22\x01\x00\x00\x00"
#define FINDMESZ    (sizeof(FINDME) - 1)

    fstat(fileno(fd), &xstat);
    len = xstat.st_size;
    buff = malloc(len);
    if(!buff) std_err();
    fread(buff, len, 1, fd);
    fclose(fd);

    l = buff + len - (FINDMESZ + 4 + 16);
    for(p = buff; p != l; p++) {
        if(!memcmp(p, FINDME, FINDMESZ)) break;
    }

    if(p != l) memcpy(key, p + FINDMESZ + 4, 16);
    free(buff);
#undef FINDME
#undef FINDMESZ

    if(p != l) return(0);
    return(-1);
}



void std_err(void) {
    perror("\nError");
    exit(1);
}


