/*

ZIP Hide (Winzip)
by Luigi Auriemma
e-mail: aluigi@autistici.org
web:    aluigi.org


Utility for hide the files in the zip

This trick seems to run only with Winzip!
It is very simple:

Winzip doesn't show the directories in Zip files (that have the
attribute 0x10) so we simply set every file in the zip as a
directory 8-)
Simple and funny


    Copyright 2004,2005,2006 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl.txt

*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <sys/stat.h>


#define VER        "0.3.1"
#define PK1        0x04034b50    /* local_head */
#define PK2        0x02014b50    /* central_dir */
#define PK3        0x06054b50    /* end_central_dir */
#define PK4        0x05054b50    /* digital sign */
#define PK5        0x06064b50    /* ZIP64, I don't kwnow how to implement it */
#define HIDE        0x10
#define bswap(x)    (((unsigned)x<<8)|((unsigned)x>>8))


void ziphide(void);
char *check_hide(void);
void len_err(void);
void std_err(void);


#pragma pack(2)

struct local_head {
    unsigned short    ver;
    unsigned short    flag;
    unsigned short    method;
    unsigned int    timedate;
    unsigned int    crc;
    unsigned int    comp_size;
    unsigned int    uncomp_size;
    unsigned short    name_len;
    unsigned short    extra_len;
    /* filename */
    /* extra */
} local_head;

struct central_dir {
    unsigned short    ver_made;
    unsigned short    ver_ext;
    unsigned short    flag;
    unsigned short    method;
    unsigned int    timedate;
    unsigned int    crc;
    unsigned int    comp_size;
    unsigned int    uncomp_size;
    unsigned short    name_len;
    unsigned short    extra_len;
    unsigned short    comm_len;
    unsigned short    disk_start;
    unsigned short    int_attr;
    unsigned short    ext_attr;
    unsigned short    file_attr;
    unsigned int    offset;
    /* filename */
    /* extra */
    /* comment */
} central_dir;



FILE    *fd;
int    hide,
    hb = HIDE;


int main(int argc, char *argv[]) {
    unsigned int    head_sign;
    int        err;


    setbuf(stdout, NULL);

    printf("\n"
        "ZIP Hide (Winzip) "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n");

    if(argc < 3) {
        printf("\nUsage: %s <0=unhide|1=hide> <file.zip> [*HIDE_byte(default 0x%02X)]\n"
            "\n* this option is not recommended. Use it only for tests\n",
            argv[0], HIDE);
        exit(1);
    }

    if(argc == 4) {
        if((argv[3][1] == 'x') || (argv[3][1] == 'X')) argv[3] += 2;
        sscanf(argv[3], "%02X", &hb);
        if(hb > 0xff) {
            printf("\nError: you must insert a number from 0x00 to 0xff\n");
            exit(1);
        }
    }

    printf("\nHIDE byte = 0x%02X\n\n", hb);

    hide = argv[1][0];
    if((hide > '1') || (hide < '0')) {
        printf("\nError: Use 0 for unhide and 1 for hide\n");
        exit(1);
    }

    fd = fopen(argv[2], "r+b");
    if(!fd) std_err();


    while(!feof(fd)) {
        err = fread(&head_sign, sizeof(char), sizeof(head_sign), fd);
        if(err < sizeof(head_sign)) len_err();

        switch(head_sign) {
            case PK1: {
                err = fread(&local_head, sizeof(char), sizeof(struct local_head), fd);
                if(err < sizeof(struct local_head)) len_err();

                err = fseek(fd, local_head.comp_size +
                    local_head.name_len +
                    local_head.extra_len, SEEK_CUR);
                if(err < 0) std_err();
                }; break;
            case PK2: ziphide(); break;
            default: goto uscita; break;
        }
    }

    goto uscita;

/* exit */
uscita: {
    fclose(fd);
    printf("\n");
    return(0);
}

}


void ziphide(void) {
    unsigned char    *buff;
    int        err,
            none;


    /* read struct */
    err = fread(&central_dir, sizeof(char), sizeof(struct central_dir), fd);
    if(err < sizeof(struct central_dir)) len_err();

    buff = alloca(central_dir.name_len);

    /* read file name */
    err = fread(buff, sizeof(char), central_dir.name_len, fd);
    if(err < central_dir.name_len) len_err();
    buff[central_dir.name_len] = 0;
    printf("----------------------------------\n"
        "Filename: %s\n"
        "Winzip invisibility:   %s --> ",
        buff,
        check_hide());

    /* if it is a file we make the operations */
    if(S_ISREG(central_dir.file_attr)) {
        none = 0;
        switch(hide) {
            case '0': {
                if((central_dir.ext_attr & 0xff) != hb) {
                    none = 1;
                    break;
                }
                central_dir.ext_attr -= hb;
                central_dir.ext_attr = bswap(central_dir.ext_attr);
                }; break;
            case '1': {
                if((central_dir.ext_attr & 0xff) == hb) {
                    none = 1;
                    break;
                }
                central_dir.ext_attr = bswap(central_dir.ext_attr);
                central_dir.ext_attr =
                    (central_dir.ext_attr - (central_dir.ext_attr & 0xff)) + hb;
                }; break;
        }
    } else none = 1;

    printf("%s\n", check_hide());

    if(!none) {
        err = fseek(fd, - (sizeof(struct central_dir) + central_dir.name_len), SEEK_CUR);
        if(err < 0) std_err();
        err = fwrite(&central_dir, sizeof(char), sizeof(struct central_dir), fd);
        if(err < sizeof(struct central_dir)) std_err();
        fflush(fd);

        err = fseek(fd, central_dir.name_len +
            central_dir.extra_len +
            central_dir.comm_len, SEEK_CUR);
        if(err < 0) std_err();
    } else {
        err = fseek(fd, central_dir.extra_len + central_dir.comm_len, SEEK_CUR);
        if(err < 0) std_err();
    }
}


char *check_hide(void) {
    if(S_ISREG(central_dir.file_attr)) {
        if((central_dir.ext_attr & 0xff) == hb) return("ON");
            else return("OFF");
    } else return("DIR");
}


void len_err(void) {
    printf("\nError: file is broken\n");
    fclose(fd);
    exit(1);
}


void std_err(void) {
    perror("\nError");
    exit(1);
}

