/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>



#define VER    "0.1"
#define HASH    "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789./"



void encode(unsigned char *password, int len);



int main(int argc, char *argv[]) {
    int        pwdlen;


    setbuf(stdout, NULL);

    fputs("\n"
        "Westwood Online chat password encoder "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);


    if(argc < 2) {
        printf("\nUsage: %s <text>\n"
            "\nNOTE:\n"
            "Original algorithm starts at offset 0x0041d440 of wchat.dat of 4.221 US version\n"
            "The algorithm is one-way, so the encoded password can NOT be completely decoded!\n"
            "\n", argv[0]);
        exit(1);
    }


    pwdlen = strlen(argv[1]);
    if(pwdlen > 8) {
        printf("\n(NOTE: Westwood passwords are max 8 bytes long: \"%.8s\")\n", argv[1]);
        pwdlen = 8;
    }

    encode(argv[1], pwdlen);

    return(0);
}



void encode(unsigned char *password, int len) {
    unsigned char    pwd1[9],
            pwd2[9],
            edx,
            esi,
            i,
            *p1,
            *p2;


    memset(pwd1, 0, sizeof(pwd1));
    memset(pwd2, 0, sizeof(pwd2));
    memcpy(pwd1, password, len);

    esi = len;
    p1 = pwd1;
    p2 = pwd2;
    for(i = 0; i < len; i++) {
        if(*p1 & 1) {
            edx = *p1 << 1;
            edx &= *(pwd1 + esi);
        } else {
            edx = *p1 ^ *(pwd1 + esi);
        }
        *p2++ = edx;
        esi--;
        p1++;
    }


    p1 = pwd1;
    p2 = pwd2;
    for(i = 0; i < 8; i++) {
        edx = *p2++ & 0x3f;
        *p1++ = HASH[edx];
    }

    printf("\nEncoded password is: %s\n\n", pwd1);
}



