#define TH_FIN  0x01
#define TH_SYN  0x02
#define TH_RST  0x04
#define TH_PSH  0x08
#define TH_ACK  0x10
#define TH_URG  0x20
#define TH_ECN  0x40
#define TH_CWR  0x80



#pragma pack(1)

typedef struct {
    uint8_t     ihl_ver;
    uint8_t     tos;
    uint16_t    tot_len;
    uint16_t    id;
    uint16_t    frag_off;
    uint8_t     ttl;
    uint8_t     protocol;
    uint16_t    check;
    uint32_t    saddr;
    uint32_t    daddr;
} iph;

typedef struct {
    uint16_t    source;
    uint16_t    dest;
    uint16_t    len;
    uint16_t    check;
} udph;

typedef struct {
    uint32_t    saddr;
    uint32_t    daddr;
    uint8_t     zero;
    uint8_t     protocol;
    uint16_t    length;
} udph_pseudo;

typedef struct {
    uint16_t    source;
    uint16_t    dest;
    uint32_t    seq;
    uint32_t    ack_seq;
    uint8_t     doff;
    uint8_t     flags;
    uint16_t    window;
    uint16_t    check;
    uint16_t    urg_ptr;
} tcph;

#pragma pack()
